/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.EnumArrayValueWrapper;
import com.jetbrains.jsonSchema.impl.EnumObjectValueWrapper;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReader {
    private static final int MAX_SCHEMA_LENGTH = FileUtilRt.LARGE_FOR_CONTENT_LOADING;
    public static final Logger LOG = Logger.getInstance(JsonSchemaReader.class);
    public static final NotificationGroup ERRORS_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"JSON Schema");
    private final Map<String, JsonSchemaObject> myIds = new HashMap<String, JsonSchemaObject>();
    private final ArrayDeque<Pair<JsonSchemaObject, JsonValueAdapter>> myQueue;
    private static final Map<String, MyReader> READERS_MAP = new HashMap<String, MyReader>();
    @Nullable
    private final VirtualFile myFile;

    public JsonSchemaReader(@Nullable VirtualFile file2) {
        this.myFile = file2;
        this.myQueue = new ArrayDeque();
    }

    @NotNull
    public static JsonSchemaObject readFromFile(@NotNull Project project, @NotNull VirtualFile file2) throws Exception {
        JsonSchemaObject object;
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(1);
        }
        if (!file2.isValid()) {
            throw new Exception(JsonBundle.message("schema.reader.cant.load.file", file2.getName()));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        JsonSchemaObject jsonSchemaObject = object = psiFile == null ? null : new JsonSchemaReader(file2).read(psiFile);
        if (object == null) {
            throw new Exception(JsonBundle.message("schema.reader.cant.load.model", file2.getName()));
        }
        JsonSchemaObject jsonSchemaObject2 = object;
        if (jsonSchemaObject2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(2);
        }
        return jsonSchemaObject2;
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String checkIfValidJsonSchema(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(4);
        }
        long length = file2.getLength();
        String fileName = file2.getName();
        if (length > (long)MAX_SCHEMA_LENGTH) {
            return JsonBundle.message("schema.reader.file.too.large", fileName, length);
        }
        if (length == 0L) {
            return JsonBundle.message("schema.reader.file.empty", fileName);
        }
        try {
            JsonSchemaReader.readFromFile(project, file2);
        }
        catch (Exception e) {
            String message2 = JsonBundle.message("schema.reader.file.not.found.or.error", fileName, e.getMessage());
            LOG.info(message2);
            return message2;
        }
        return null;
    }

    private static JsonSchemaObject enqueue(@NotNull Collection<Pair<JsonSchemaObject, JsonValueAdapter>> queue2, @NotNull JsonSchemaObject schemaObject, @NotNull JsonValueAdapter container) {
        if (queue2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(5);
        }
        if (schemaObject == null) {
            JsonSchemaReader.$$$reportNull$$$0(6);
        }
        if (container == null) {
            JsonSchemaReader.$$$reportNull$$$0(7);
        }
        queue2.add((Pair<JsonSchemaObject, JsonValueAdapter>)Pair.create((Object)schemaObject, (Object)container));
        return schemaObject;
    }

    @Nullable
    public JsonSchemaObject read(@NotNull PsiFile file2) {
        JsonLikePsiWalker walker;
        if (file2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(8);
        }
        if ((walker = JsonLikePsiWalker.getWalker((PsiElement)file2, JsonSchemaObject.NULL_OBJ)) == null) {
            return null;
        }
        PsiElement root2 = (PsiElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> (PsiElement)ContainerUtil.getFirstItem(walker.getRoots(file2)));
        return root2 == null ? null : this.read(root2, walker);
    }

    @Nullable
    private JsonSchemaObject read(@NotNull PsiElement object, @NotNull JsonLikePsiWalker walker) {
        if (object == null) {
            JsonSchemaReader.$$$reportNull$$$0(9);
        }
        if (walker == null) {
            JsonSchemaReader.$$$reportNull$$$0(10);
        }
        JsonSchemaObject root2 = new JsonSchemaObject(this.myFile, "/");
        JsonValueAdapter rootAdapter = walker.createValueAdapter(object);
        if (rootAdapter == null) {
            return null;
        }
        JsonSchemaReader.enqueue(this.myQueue, root2, rootAdapter);
        while (!this.myQueue.isEmpty()) {
            Pair<JsonSchemaObject, JsonValueAdapter> currentItem = this.myQueue.removeFirst();
            JsonSchemaObject currentSchema = (JsonSchemaObject)currentItem.first;
            String pointer = currentSchema.getPointer();
            JsonValueAdapter adapter = (JsonValueAdapter)currentItem.second;
            if (adapter instanceof JsonObjectValueAdapter) {
                List<JsonPropertyAdapter> list2 = ((JsonObjectValueAdapter)adapter).getPropertyList();
                for (JsonPropertyAdapter property2 : list2) {
                    String name2;
                    Collection<JsonValueAdapter> values2 = property2.getValues();
                    if (values2.size() != 1 || (name2 = property2.getName()) == null) continue;
                    MyReader reader = READERS_MAP.get(name2);
                    JsonValueAdapter value2 = values2.iterator().next();
                    if (reader != null) {
                        reader.read(value2, currentSchema, this.myQueue, this.myFile);
                        continue;
                    }
                    this.readSingleDefinition(name2, value2, currentSchema, pointer);
                }
            } else if (adapter instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> values3 = ((JsonArrayValueAdapter)adapter).getElements();
                for (int i2 = 0; i2 < values3.size(); ++i2) {
                    this.readSingleDefinition(String.valueOf(i2), values3.get(i2), currentSchema, pointer);
                }
            }
            if (currentSchema.getId() != null) {
                this.myIds.put(currentSchema.getId(), currentSchema);
            }
            currentSchema.completeInitialization(adapter);
        }
        return root2;
    }

    public Map<String, JsonSchemaObject> getIds() {
        return this.myIds;
    }

    private void readSingleDefinition(@NotNull String name2, @NotNull JsonValueAdapter value2, @NotNull JsonSchemaObject schema2, String pointer) {
        if (name2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(11);
        }
        if (value2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(12);
        }
        if (schema2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(13);
        }
        String nextPointer = JsonSchemaReader.getNewPointer(name2, pointer);
        JsonSchemaObject defined = JsonSchemaReader.enqueue(this.myQueue, new JsonSchemaObject(this.myFile, nextPointer), value2);
        Map<String, JsonSchemaObject> definitions = schema2.getDefinitionsMap();
        if (definitions == null) {
            definitions = new HashMap<String, JsonSchemaObject>();
            schema2.setDefinitionsMap(definitions);
        }
        definitions.put(name2, defined);
    }

    @NotNull
    private static String getNewPointer(@NotNull String name2, String oldPointer) {
        if (name2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(14);
        }
        String string = oldPointer.equals("/") ? oldPointer + name2 : oldPointer + "/" + name2;
        if (string == null) {
            JsonSchemaReader.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void fillMap() {
        READERS_MAP.put("$anchor", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setId((String)s))));
        READERS_MAP.put("$id", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setId((String)s))));
        READERS_MAP.put("id", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setId((String)s))));
        READERS_MAP.put("$schema", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setSchema((String)s))));
        READERS_MAP.put("description", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setDescription((String)s))));
        READERS_MAP.put("deprecationMessage", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setDeprecationMessage((String)s))));
        READERS_MAP.put("x-intellij-html-description", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setHtmlDescription((String)s))));
        READERS_MAP.put("x-intellij-language-injection", (element2, object, queue2, virtualFile2) -> JsonSchemaReader.readInjectionMetadata(element2, object));
        READERS_MAP.put("x-intellij-enum-metadata", (element2, object, queue2, virtualFile2) -> JsonSchemaReader.readEnumMetadata(element2, object));
        READERS_MAP.put("x-intellij-case-insensitive", (element2, object, queue2, virtualFile2) -> {
            if (element2.isBooleanLiteral()) {
                object.setForceCaseInsensitive(JsonSchemaReader.getBoolean(element2));
            }
        });
        READERS_MAP.put("title", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setTitle((String)s))));
        READERS_MAP.put("$ref", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setRef((String)s))));
        READERS_MAP.put("$recursiveRef", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> {
            object.setRef((String)s);
            object.setRefRecursive(true);
        })));
        READERS_MAP.put("$recursiveAnchor", (element2, object, queue2, virtualFile2) -> {
            if (element2.isBooleanLiteral()) {
                object.setRecursiveAnchor(true);
            }
        });
        READERS_MAP.put("default", JsonSchemaReader.createDefault());
        READERS_MAP.put("format", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setFormat((String)s))));
        READERS_MAP.put("definitions", JsonSchemaReader.createDefinitionsConsumer());
        READERS_MAP.put("$defs", JsonSchemaReader.createDefinitionsConsumer());
        READERS_MAP.put("properties", JsonSchemaReader.createPropertiesConsumer());
        READERS_MAP.put("multipleOf", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObject, Number>)((PairConsumer)(object, i2) -> object.setMultipleOf((Number)i2))));
        READERS_MAP.put("maximum", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObject, Number>)((PairConsumer)(object, i2) -> object.setMaximum((Number)i2))));
        READERS_MAP.put("minimum", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObject, Number>)((PairConsumer)(object, i2) -> object.setMinimum((Number)i2))));
        READERS_MAP.put("exclusiveMaximum", (element2, object, queue2, virtualFile2) -> {
            if (element2.isBooleanLiteral()) {
                object.setExclusiveMaximum(JsonSchemaReader.getBoolean(element2));
            } else if (element2.isNumberLiteral()) {
                object.setExclusiveMaximumNumber(JsonSchemaReader.getNumber(element2));
            }
        });
        READERS_MAP.put("exclusiveMinimum", (element2, object, queue2, virtualFile2) -> {
            if (element2.isBooleanLiteral()) {
                object.setExclusiveMinimum(JsonSchemaReader.getBoolean(element2));
            } else if (element2.isNumberLiteral()) {
                object.setExclusiveMinimumNumber(JsonSchemaReader.getNumber(element2));
            }
        });
        READERS_MAP.put("maxLength", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i2) -> object.setMaxLength((Integer)i2))));
        READERS_MAP.put("minLength", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i2) -> object.setMinLength((Integer)i2))));
        READERS_MAP.put("pattern", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setPattern((String)s))));
        READERS_MAP.put("additionalItems", JsonSchemaReader.createAdditionalItems());
        READERS_MAP.put("items", JsonSchemaReader.createItems());
        READERS_MAP.put("contains", JsonSchemaReader.createContains());
        READERS_MAP.put("maxItems", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i2) -> object.setMaxItems((Integer)i2))));
        READERS_MAP.put("minItems", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i2) -> object.setMinItems((Integer)i2))));
        READERS_MAP.put("uniqueItems", (element2, object, queue2, virtualFile2) -> {
            if (element2.isBooleanLiteral()) {
                object.setUniqueItems(JsonSchemaReader.getBoolean(element2));
            }
        });
        READERS_MAP.put("maxProperties", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i2) -> object.setMaxProperties((Integer)i2))));
        READERS_MAP.put("minProperties", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i2) -> object.setMinProperties((Integer)i2))));
        READERS_MAP.put("required", JsonSchemaReader.createRequired());
        READERS_MAP.put("additionalProperties", JsonSchemaReader.createAdditionalProperties());
        READERS_MAP.put("propertyNames", JsonSchemaReader.createFromObject("propertyNames", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema2) -> object.setPropertyNamesSchema((JsonSchemaObject)schema2))));
        READERS_MAP.put("patternProperties", JsonSchemaReader.createPatternProperties());
        READERS_MAP.put("dependencies", JsonSchemaReader.createDependencies());
        READERS_MAP.put("enum", JsonSchemaReader.createEnum());
        READERS_MAP.put("const", (element2, object, queue2, virtualFile2) -> object.setEnum(ContainerUtil.createMaybeSingletonList((Object)JsonSchemaReader.readEnumValue(element2))));
        READERS_MAP.put("type", JsonSchemaReader.createType());
        READERS_MAP.put("allOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAllOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("anyOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAnyOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("oneOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setOneOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("not", JsonSchemaReader.createFromObject("not", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema1) -> object.setNot((JsonSchemaObject)schema1))));
        READERS_MAP.put("if", JsonSchemaReader.createFromObject("if", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema2) -> object.setIf((JsonSchemaObject)schema2))));
        READERS_MAP.put("then", JsonSchemaReader.createFromObject("then", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema2) -> object.setThen((JsonSchemaObject)schema2))));
        READERS_MAP.put("else", JsonSchemaReader.createFromObject("else", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema2) -> object.setElse((JsonSchemaObject)schema2))));
        READERS_MAP.put("instanceof", (element2, object, queue2, virtualFile2) -> object.setShouldValidateAgainstJSType());
        READERS_MAP.put("typeof", (element2, object, queue2, virtualFile2) -> object.setShouldValidateAgainstJSType());
    }

    private static void readEnumMetadata(JsonValueAdapter element2, JsonSchemaObject object) {
        if (!(element2 instanceof JsonObjectValueAdapter)) {
            return;
        }
        HashMap<String, Map<String, String>> metadataMap = new HashMap<String, Map<String, String>>();
        for (JsonPropertyAdapter adapter : ((JsonObjectValueAdapter)element2).getPropertyList()) {
            Collection<JsonValueAdapter> values2;
            String name2 = adapter.getName();
            if (name2 == null || (values2 = adapter.getValues()).size() != 1) continue;
            JsonValueAdapter valueAdapter = values2.iterator().next();
            if (valueAdapter.isStringLiteral()) {
                metadataMap.put(name2, Collections.singletonMap("description", JsonSchemaReader.getString(valueAdapter)));
                continue;
            }
            if (!(valueAdapter instanceof JsonObjectValueAdapter)) continue;
            HashMap<String, String> valueMap = new HashMap<String, String>();
            for (JsonPropertyAdapter propertyAdapter : ((JsonObjectValueAdapter)valueAdapter).getPropertyList()) {
                JsonValueAdapter next;
                Collection<JsonValueAdapter> adapterValues;
                String adapterName = propertyAdapter.getName();
                if (adapterName == null || (adapterValues = propertyAdapter.getValues()).size() != 1 || !(next = adapterValues.iterator().next()).isStringLiteral()) continue;
                valueMap.put(adapterName, JsonSchemaReader.getString(next));
            }
            metadataMap.put(name2, valueMap);
        }
        object.setEnumMetadata(metadataMap);
    }

    private static void readInjectionMetadata(JsonValueAdapter element2, JsonSchemaObject object) {
        if (element2.isStringLiteral()) {
            object.setLanguageInjection(JsonSchemaReader.getString(element2));
        } else if (element2 instanceof JsonObjectValueAdapter) {
            for (JsonPropertyAdapter adapter : ((JsonObjectValueAdapter)element2).getPropertyList()) {
                String postfix;
                String prefix;
                String lang = JsonSchemaReader.readSingleProp(adapter, "language", JsonSchemaReader::getString);
                if (lang != null) {
                    object.setLanguageInjection(lang);
                }
                if ((prefix = JsonSchemaReader.readSingleProp(adapter, "prefix", JsonSchemaReader::getString)) != null) {
                    object.setLanguageInjectionPrefix(prefix);
                }
                if ((postfix = JsonSchemaReader.readSingleProp(adapter, "suffix", JsonSchemaReader::getString)) == null) continue;
                object.setLanguageInjectionPostfix(postfix);
            }
        }
    }

    @Nullable
    private static <T> T readSingleProp(JsonPropertyAdapter adapter, String propName, Function<JsonValueAdapter, T> getterFunc) {
        Collection<JsonValueAdapter> values2;
        if (propName.equals(adapter.getName()) && (values2 = adapter.getValues()).size() == 1) {
            return getterFunc.apply(values2.iterator().next());
        }
        return null;
    }

    private static MyReader createFromStringValue(PairConsumer<JsonSchemaObject, String> propertySetter) {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isStringLiteral()) {
                propertySetter.consume((Object)object, (Object)JsonSchemaReader.getString(element2));
            }
        };
    }

    private static MyReader createFromInteger(PairConsumer<JsonSchemaObject, Integer> propertySetter) {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isNumberLiteral()) {
                propertySetter.consume((Object)object, (Object)((Integer)JsonSchemaReader.getNumber(element2)));
            }
        };
    }

    private static MyReader createFromNumber(PairConsumer<JsonSchemaObject, Number> propertySetter) {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isNumberLiteral()) {
                propertySetter.consume((Object)object, (Object)JsonSchemaReader.getNumber(element2));
            }
        };
    }

    private static MyReader createFromObject(String prop, PairConsumer<JsonSchemaObject, JsonSchemaObject> propertySetter) {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isObject()) {
                propertySetter.consume((Object)object, (Object)JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer(prop, object.getPointer())), element2));
            }
        };
    }

    private static MyReader createContainer(@NotNull PairConsumer<JsonSchemaObject, List<JsonSchemaObject>> delegate2) {
        if (delegate2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(16);
        }
        return (element2, object, queue2, virtualFile2) -> {
            if (element2 instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> list2 = ((JsonArrayValueAdapter)element2).getElements();
                ArrayList<JsonSchemaObject> members = new ArrayList<JsonSchemaObject>(list2.size());
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    JsonValueAdapter value2 = list2.get(i2);
                    if (!value2.isObject()) continue;
                    members.add(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer(String.valueOf(i2), object.getPointer())), value2));
                }
                delegate2.consume((Object)object, members);
            }
        };
    }

    private static MyReader createType() {
        return (element2, object, queue2, virtualFile2) -> {
            Set<JsonSchemaType> typeList;
            if (element2.isStringLiteral()) {
                JsonSchemaType type = JsonSchemaReader.parseType(StringUtil.unquoteString((String)element2.getDelegate().getText()));
                if (type != null) {
                    object.setType(type);
                }
            } else if (element2 instanceof JsonArrayValueAdapter && !(typeList = ((JsonArrayValueAdapter)element2).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> JsonSchemaReader.parseType(StringUtil.unquoteString((String)el.getDelegate().getText()))).filter(el -> el != null).collect(Collectors.toSet())).isEmpty()) {
                object.setTypeVariants(typeList);
            }
        };
    }

    @Nullable
    private static JsonSchemaType parseType(@NotNull String typeString) {
        if (typeString == null) {
            JsonSchemaReader.$$$reportNull$$$0(17);
        }
        try {
            return JsonSchemaType.valueOf("_" + typeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static Object readEnumValue(JsonValueAdapter value2) {
        if (value2.isStringLiteral()) {
            return "\"" + StringUtil.unquoteString((String)value2.getDelegate().getText()) + "\"";
        }
        if (value2.isNumberLiteral()) {
            return JsonSchemaReader.getNumber(value2);
        }
        if (value2.isBooleanLiteral()) {
            return JsonSchemaReader.getBoolean(value2);
        }
        if (value2.isNull()) {
            return "null";
        }
        if (value2 instanceof JsonArrayValueAdapter) {
            return new EnumArrayValueWrapper(((JsonArrayValueAdapter)value2).getElements().stream().map(v -> JsonSchemaReader.readEnumValue(v)).filter(v -> v != null).toArray());
        }
        if (value2 instanceof JsonObjectValueAdapter) {
            return new EnumObjectValueWrapper(((JsonObjectValueAdapter)value2).getPropertyList().stream().filter(p -> p.getValues().size() == 1).map(p -> Pair.create((Object)p.getName(), (Object)JsonSchemaReader.readEnumValue(p.getValues().iterator().next()))).filter(p -> p.second != null).collect(Collectors.toMap(p -> (String)p.first, p -> p.second)));
        }
        return null;
    }

    private static MyReader createEnum() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2 instanceof JsonArrayValueAdapter) {
                ArrayList<Object> objects = new ArrayList<Object>();
                List<JsonValueAdapter> list2 = ((JsonArrayValueAdapter)element2).getElements();
                for (JsonValueAdapter value2 : list2) {
                    Object enumValue = JsonSchemaReader.readEnumValue(value2);
                    if (enumValue == null) {
                        return;
                    }
                    objects.add(enumValue);
                }
                object.setEnum(objects);
            }
        };
    }

    private static String getString(@NotNull JsonValueAdapter value2) {
        if (value2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(18);
        }
        return StringUtil.unquoteString((String)value2.getDelegate().getText());
    }

    private static boolean getBoolean(@NotNull JsonValueAdapter value2) {
        if (value2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(19);
        }
        return Boolean.parseBoolean(value2.getDelegate().getText());
    }

    @NotNull
    private static Number getNumber(@NotNull JsonValueAdapter value2) {
        Number numberValue;
        if (value2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(20);
        }
        try {
            numberValue = Integer.parseInt(value2.getDelegate().getText());
        }
        catch (NumberFormatException e) {
            try {
                numberValue = Double.parseDouble(value2.getDelegate().getText());
            }
            catch (NumberFormatException e2) {
                Integer n = -1;
                if (n == null) {
                    JsonSchemaReader.$$$reportNull$$$0(21);
                }
                return n;
            }
        }
        Integer n = numberValue;
        if (n == null) {
            JsonSchemaReader.$$$reportNull$$$0(22);
        }
        return n;
    }

    private static MyReader createDependencies() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2 instanceof JsonObjectValueAdapter) {
                HashMap<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();
                HashMap<String, JsonSchemaObject> schemaDependencies = new HashMap<String, JsonSchemaObject>();
                List<JsonPropertyAdapter> list2 = ((JsonObjectValueAdapter)element2).getPropertyList();
                for (JsonPropertyAdapter property2 : list2) {
                    JsonValueAdapter value2;
                    Collection<JsonValueAdapter> values2 = property2.getValues();
                    if (values2.size() != 1 || (value2 = values2.iterator().next()) == null) continue;
                    if (value2 instanceof JsonArrayValueAdapter) {
                        List dependencies2 = ((JsonArrayValueAdapter)value2).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getDelegate().getText())).collect(Collectors.toList());
                        if (dependencies2.isEmpty()) continue;
                        propertyDependencies.put(property2.getName(), dependencies2);
                        continue;
                    }
                    if (!value2.isObject()) continue;
                    String newPointer = JsonSchemaReader.getNewPointer("dependencies/" + property2.getName(), object.getPointer());
                    schemaDependencies.put(property2.getName(), JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, newPointer), value2));
                }
                object.setPropertyDependencies(propertyDependencies);
                object.setSchemaDependencies(schemaDependencies);
            }
        };
    }

    @NotNull
    private static Predicate<JsonValueAdapter> notEmptyString() {
        Predicate<JsonValueAdapter> predicate2 = el -> el.isStringLiteral() && !StringUtil.isEmptyOrSpaces((String)el.getDelegate().getText());
        if (predicate2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(23);
        }
        return predicate2;
    }

    private static MyReader createPatternProperties() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isObject()) {
                object.setPatternProperties(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer("patternProperties", object.getPointer()), element2, queue2, virtualFile2));
            }
        };
    }

    private static MyReader createAdditionalProperties() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isBooleanLiteral()) {
                object.setAdditionalPropertiesAllowed(JsonSchemaReader.getBoolean(element2));
            } else if (element2.isObject()) {
                object.setAdditionalPropertiesSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer("additionalProperties", object.getPointer())), element2));
            }
        };
    }

    private static MyReader createRequired() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2 instanceof JsonArrayValueAdapter) {
                object.setRequired(new LinkedHashSet<String>(((JsonArrayValueAdapter)element2).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getDelegate().getText())).collect(Collectors.toList())));
            }
        };
    }

    private static MyReader createItems() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isObject()) {
                object.setItemsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer("items", object.getPointer())), element2));
            } else if (element2 instanceof JsonArrayValueAdapter) {
                ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>();
                List<JsonValueAdapter> values2 = ((JsonArrayValueAdapter)element2).getElements();
                for (int i2 = 0; i2 < values2.size(); ++i2) {
                    JsonValueAdapter value2 = values2.get(i2);
                    if (!value2.isObject()) continue;
                    list2.add(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer("items/" + i2, object.getPointer())), value2));
                }
                object.setItemsSchemaList(list2);
            }
        };
    }

    private static MyReader createDefinitionsConsumer() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isObject()) {
                object.setDefinitionsMap(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer("definitions", object.getPointer()), element2, queue2, virtualFile2));
            }
        };
    }

    private static MyReader createContains() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isObject()) {
                object.setContainsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer("contains", object.getPointer())), element2));
            }
        };
    }

    private static MyReader createAdditionalItems() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isBooleanLiteral()) {
                object.setAdditionalItemsAllowed(JsonSchemaReader.getBoolean(element2));
            } else if (element2.isObject()) {
                object.setAdditionalItemsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer("additionalItems", object.getPointer())), element2));
            }
        };
    }

    private static MyReader createPropertiesConsumer() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isObject()) {
                object.setProperties(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer("properties", object.getPointer()), element2, queue2, virtualFile2));
            }
        };
    }

    @NotNull
    private static Map<String, JsonSchemaObject> readInnerObject(String parentPointer, @NotNull JsonValueAdapter element2, @NotNull Collection<Pair<JsonSchemaObject, JsonValueAdapter>> queue2, VirtualFile virtualFile2) {
        if (element2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(24);
        }
        if (queue2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(25);
        }
        HashMap<String, JsonSchemaObject> map2 = new HashMap<String, JsonSchemaObject>();
        if (!(element2 instanceof JsonObjectValueAdapter)) {
            HashMap<String, JsonSchemaObject> hashMap = map2;
            if (hashMap == null) {
                JsonSchemaReader.$$$reportNull$$$0(26);
            }
            return hashMap;
        }
        List<JsonPropertyAdapter> properties2 = ((JsonObjectValueAdapter)element2).getPropertyList();
        for (JsonPropertyAdapter property2 : properties2) {
            Collection<JsonValueAdapter> values2 = property2.getValues();
            if (values2.size() != 1) continue;
            JsonValueAdapter value2 = values2.iterator().next();
            String propertyName = property2.getName();
            if (propertyName == null) continue;
            if (value2.isBooleanLiteral()) {
                map2.put(propertyName, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer(propertyName, parentPointer)));
                continue;
            }
            if (!value2.isObject()) continue;
            map2.put(propertyName, JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer(propertyName, parentPointer)), value2));
        }
        HashMap<String, JsonSchemaObject> hashMap = map2;
        if (hashMap == null) {
            JsonSchemaReader.$$$reportNull$$$0(27);
        }
        return hashMap;
    }

    private static MyReader createDefault() {
        return (element2, object, queue2, virtualFile2) -> {
            if (element2.isObject()) {
                object.setDefault(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile2, JsonSchemaReader.getNewPointer("default", object.getPointer())), element2));
            } else if (element2.isStringLiteral()) {
                object.setDefault(StringUtil.unquoteString((String)element2.getDelegate().getText()));
            } else if (element2.isNumberLiteral()) {
                object.setDefault(JsonSchemaReader.getNumber(element2));
            } else if (element2.isBooleanLiteral()) {
                object.setDefault(JsonSchemaReader.getBoolean(element2));
            }
        };
    }

    static {
        JsonSchemaReader.fillMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaObject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewPointer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "notEmptyString";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "readInnerObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromFile";
                break;
            }
            case 2: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkIfValidJsonSchema";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enqueue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readSingleDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNewPointer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNumber";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readInnerObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface MyReader {
        public void read(@NotNull JsonValueAdapter var1, @NotNull JsonSchemaObject var2, @NotNull Collection<Pair<JsonSchemaObject, JsonValueAdapter>> var3, @Nullable VirtualFile var4);
    }
}

