/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaCatalogEntry;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.ContentAwareJsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaEnabler;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogExclusion;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService,
ModificationTracker,
Disposable {
    private static final Logger LOG = Logger.getInstance(JsonSchemaServiceImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MyState myState;
    @NotNull
    private final ClearableLazyValue<Set<String>> myBuiltInSchemaIds;
    @NotNull
    private final Set<String> myRefs;
    private final AtomicLong myAnyChangeCount;
    @NotNull
    private final JsonSchemaCatalogManager myCatalogManager;
    @NotNull
    private final JsonSchemaVfsListener.JsonSchemaUpdater mySchemaUpdater;
    private final JsonSchemaProviderFactories myFactories;
    private final List<Runnable> myResetActions;

    public JsonSchemaServiceImpl(@NotNull Project project) {
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(0);
        }
        this.myRefs = ContainerUtil.newConcurrentSet();
        this.myAnyChangeCount = new AtomicLong(0L);
        this.myResetActions = ContainerUtil.createConcurrentList();
        this.myProject = project;
        this.myFactories = new JsonSchemaProviderFactories();
        this.myState = new MyState(() -> this.myFactories.getProviders(), this.myProject);
        this.myBuiltInSchemaIds = new ClearableLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                Set set2 = ContainerUtil.map2SetNotNull(JsonSchemaServiceImpl.this.myState.getFiles(), f -> JsonCachedValues.getSchemaId(f, JsonSchemaServiceImpl.this.myProject));
                if (set2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$1", "compute"));
            }
        };
        JsonSchemaProviderFactory.EP_NAME.addChangeListener(this::reset, (Disposable)this);
        JsonSchemaEnabler.EXTENSION_POINT_NAME.addChangeListener(this::reset, (Disposable)this);
        JsonSchemaCatalogExclusion.EP_NAME.addChangeListener(this::reset, (Disposable)this);
        this.myCatalogManager = new JsonSchemaCatalogManager(this.myProject);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(JsonSchemaVfsListener.JSON_SCHEMA_CHANGED, this.myAnyChangeCount::incrementAndGet);
        connection.subscribe(JsonSchemaVfsListener.JSON_DEPS_CHANGED, () -> {
            this.myRefs.clear();
            this.myAnyChangeCount.incrementAndGet();
        });
        this.mySchemaUpdater = JsonSchemaVfsListener.startListening(project, this, connection);
        this.myCatalogManager.startUpdates();
    }

    public long getModificationCount() {
        return this.myAnyChangeCount.get();
    }

    public void dispose() {
    }

    @NotNull
    protected List<JsonSchemaProviderFactory> getProviderFactories() {
        List list2 = JsonSchemaProviderFactory.EP_NAME.getExtensionList();
        if (list2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(2);
        }
        return this.myState.getProvider(schemaFile);
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file2;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(3);
        }
        return (file2 = this.resolveSchemaFile(schemaObject)) == null ? null : this.getSchemaProvider(file2);
    }

    @Override
    public void reset() {
        this.myFactories.reset();
        this.resetWithCurrentFactories();
    }

    private void resetWithCurrentFactories() {
        this.myState.reset();
        this.myBuiltInSchemaIds.drop();
        this.myAnyChangeCount.incrementAndGet();
        for (Runnable action2 : this.myResetActions) {
            action2.run();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String reference2, @Nullable VirtualFile referent) {
        VirtualFile file2;
        if (reference2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(5);
        }
        if ((file2 = this.findBuiltInSchemaByReference(reference2)) != null) {
            return file2;
        }
        if (reference2.startsWith("#")) {
            return referent;
        }
        return JsonFileResolver.resolveSchemaByReference(referent, JsonPointerUtil.normalizeId(reference2));
    }

    @Nullable
    private VirtualFile findBuiltInSchemaByReference(@NotNull String reference2) {
        if (reference2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(6);
        }
        String id2 = JsonPointerUtil.normalizeId(reference2);
        if (!((Set)this.myBuiltInSchemaIds.getValue()).contains(id2)) {
            return null;
        }
        for (VirtualFile file2 : this.myState.getFiles()) {
            if (!id2.equals(JsonCachedValues.getSchemaId(file2, this.myProject))) continue;
            return file2;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(7);
        }
        Collection<VirtualFile> collection = this.getSchemasForFile(file2, false, false);
        if (collection == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Nullable
    public VirtualFile getDynamicSchemaForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(9);
        }
        return ContentAwareJsonSchemaFileProvider.EP_NAME.extensions().map(provider2 -> provider2.getSchemaFile(psiFile)).filter(schemaFile -> schemaFile != null).findFirst().orElse(null);
    }

    @NotNull
    public Collection<VirtualFile> getSchemasForFile(@NotNull VirtualFile file2, boolean single, boolean onlyUserSchemas) {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(10);
        }
        String schemaUrl = null;
        if (!onlyUserSchemas && JsonFileResolver.isSchemaUrl(schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject)) && (virtualFile3 = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
            List<VirtualFile> list2 = Collections.singletonList(virtualFile3);
            if (list2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List<JsonSchemaFileProvider> providers = this.getProvidersForFile(file2);
        boolean checkSchemaProperty = true;
        if (!onlyUserSchemas && providers.stream().noneMatch(p -> p.getSchemaType() == SchemaType.userSchema)) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject);
            }
            if ((virtualFile2 = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
                List<VirtualFile> list3 = Collections.singletonList(virtualFile2);
                if (list3 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(12);
                }
                return list3;
            }
            checkSchemaProperty = false;
        }
        if (!single) {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            for (JsonSchemaFileProvider provider3 : providers) {
                VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, provider3);
                if (schemaFile == null) continue;
                files2.add(schemaFile);
            }
            if (!files2.isEmpty()) {
                ArrayList<VirtualFile> arrayList = files2;
                if (arrayList == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(13);
                }
                return arrayList;
            }
        } else if (!providers.isEmpty()) {
            JsonSchemaFileProvider selected2;
            if (providers.size() > 2) {
                List list4 = ContainerUtil.emptyList();
                if (list4 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(14);
                }
                return list4;
            }
            if (providers.size() > 1) {
                Optional<JsonSchemaFileProvider> userSchema = providers.stream().filter(provider2 -> SchemaType.userSchema.equals((Object)provider2.getSchemaType())).findFirst();
                if (userSchema.isEmpty()) {
                    List list5 = ContainerUtil.emptyList();
                    if (list5 == null) {
                        JsonSchemaServiceImpl.$$$reportNull$$$0(15);
                    }
                    return list5;
                }
                selected2 = userSchema.get();
            } else {
                selected2 = providers.get(0);
            }
            VirtualFile schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(this.myProject, selected2);
            List list6 = ContainerUtil.createMaybeSingletonList((Object)schemaFile);
            if (list6 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(16);
            }
            return list6;
        }
        if (onlyUserSchemas) {
            List list7 = ContainerUtil.emptyList();
            if (list7 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(17);
            }
            return list7;
        }
        if (checkSchemaProperty) {
            if (schemaUrl == null) {
                schemaUrl = JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject);
            }
            if ((virtualFile2 = this.resolveFromSchemaProperty(schemaUrl, file2)) != null) {
                List<VirtualFile> list8 = Collections.singletonList(virtualFile2);
                if (list8 == null) {
                    JsonSchemaServiceImpl.$$$reportNull$$$0(18);
                }
                return list8;
            }
        }
        List list9 = ContainerUtil.createMaybeSingletonList((Object)this.resolveSchemaFromOtherSources(file2));
        if (list9 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(19);
        }
        return list9;
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProvidersForFile(@NotNull VirtualFile file2) {
        Map map2;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(20);
        }
        if ((map2 = (Map)this.myState.myData.getValue()).isEmpty()) {
            List<JsonSchemaFileProvider> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(21);
            }
            return list2;
        }
        List result2 = null;
        for (List providers : map2.values()) {
            for (JsonSchemaFileProvider provider2 : providers) {
                if (!JsonSchemaServiceImpl.isProviderAvailable(file2, provider2)) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(provider2);
            }
        }
        List<JsonSchemaFileProvider> list3 = result2 == null ? Collections.emptyList() : result2;
        if (list3 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(22);
        }
        return list3;
    }

    @Nullable
    private VirtualFile resolveFromSchemaProperty(@Nullable String schemaUrl, @NotNull VirtualFile file2) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(23);
        }
        if (schemaUrl != null && (virtualFile2 = this.findSchemaFileByReference(schemaUrl, file2)) != null) {
            return virtualFile2;
        }
        return null;
    }

    @Override
    public List<JsonSchemaInfo> getAllUserVisibleSchemas() {
        List<JsonSchemaCatalogEntry> schemas = this.myCatalogManager.getAllCatalogEntries();
        Map map2 = (Map)this.myState.myData.getValue();
        ArrayList<JsonSchemaInfo> results = new ArrayList<JsonSchemaInfo>(schemas.size() + map2.size());
        HashMap processedRemotes = new HashMap();
        this.myState.processProviders(provider2 -> {
            if (provider2.isUserVisible()) {
                String remoteSource = provider2.getRemoteSource();
                if (remoteSource != null) {
                    if (!processedRemotes.containsKey(remoteSource)) {
                        JsonSchemaInfo info2 = new JsonSchemaInfo((JsonSchemaFileProvider)provider2);
                        processedRemotes.put(remoteSource, info2);
                        results.add(info2);
                    }
                } else {
                    results.add(new JsonSchemaInfo((JsonSchemaFileProvider)provider2));
                }
            }
        });
        for (JsonSchemaCatalogEntry schema2 : schemas) {
            JsonSchemaInfo info2;
            String url = schema2.getUrl();
            if (!processedRemotes.containsKey(url)) {
                info2 = new JsonSchemaInfo(url);
                if (schema2.getDescription() != null) {
                    info2.setDocumentation(schema2.getDescription());
                }
                if (schema2.getName() != null) {
                    info2.setName(schema2.getName());
                }
                results.add(info2);
                continue;
            }
            info2 = (JsonSchemaInfo)processedRemotes.get(url);
            if (info2.getDocumentation() == null) {
                info2.setDocumentation(schema2.getDescription());
            }
            if (info2.getName() != null) continue;
            info2.setName(schema2.getName());
        }
        return results;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile file2) {
        Collection<VirtualFile> schemas;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(24);
        }
        if ((schemas = this.getSchemasForFile(file2, true, false)).size() == 0) {
            return null;
        }
        assert (schemas.size() == 1);
        VirtualFile schemaFile = schemas.iterator().next();
        return JsonCachedValues.getSchemaObject(this.replaceHttpFileWithBuiltinIfNeeded(schemaFile), this.myProject);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull PsiFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(25);
        }
        return JsonCachedValues.computeSchemaForFile(file2, this);
    }

    public VirtualFile replaceHttpFileWithBuiltinIfNeeded(VirtualFile schemaFile) {
        if (schemaFile instanceof HttpVirtualFile && (!JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).isPreferRemoteSchemas() || JsonFileResolver.isSchemaUrl(schemaFile.getUrl()))) {
            String url = schemaFile.getUrl();
            VirtualFile first1 = this.getLocalSchemaByUrl(url);
            return first1 != null ? first1 : schemaFile;
        }
        return schemaFile;
    }

    @Nullable
    public VirtualFile getLocalSchemaByUrl(String url) {
        return this.myState.getFiles().stream().filter(f -> {
            JsonSchemaFileProvider prov = this.getSchemaProvider((VirtualFile)f);
            return prov != null && !(prov.getSchemaFile() instanceof HttpVirtualFile) && (url.equals(prov.getRemoteSource()) || JsonFileResolver.replaceUnsafeSchemaStoreUrls(url).equals(prov.getRemoteSource()) || url.equals(JsonFileResolver.replaceUnsafeSchemaStoreUrls(prov.getRemoteSource())));
        }).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(26);
        }
        return JsonCachedValues.getSchemaObject(schemaFile, this.myProject);
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(27);
        }
        return this.isMappedSchema(file2) || this.isSchemaByProvider(file2) || this.hasSchemaSchema(file2);
    }

    @Override
    public boolean isSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile file2;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(28);
        }
        return (file2 = this.resolveSchemaFile(schemaObject)) != null && this.isSchemaFile(file2);
    }

    private boolean isMappedSchema(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(29);
        }
        return this.isMappedSchema(file2, true);
    }

    public boolean isMappedSchema(@NotNull VirtualFile file2, boolean canRecompute) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(30);
        }
        return (canRecompute || this.myState.isComputed()) && this.myState.getFiles().contains(file2);
    }

    private boolean isSchemaByProvider(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider provider2;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(31);
        }
        if ((provider2 = this.myState.getProvider(file2)) != null) {
            return JsonSchemaServiceImpl.isSchemaProvider(provider2);
        }
        Map map2 = (Map)this.myState.myData.getValue();
        for (List providers : map2.values()) {
            for (JsonSchemaFileProvider p : providers) {
                if (!JsonSchemaServiceImpl.isSchemaProvider(p) || !p.isAvailable(file2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSchemaProvider(JsonSchemaFileProvider provider2) {
        return JsonFileResolver.isSchemaUrl(provider2.getRemoteSource());
    }

    @Override
    public JsonSchemaVersion getSchemaVersion(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider provider2;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(32);
        }
        if (this.isMappedSchema(file2) && (provider2 = this.myState.getProvider(file2)) != null) {
            return provider2.getSchemaVersion();
        }
        return this.getSchemaVersionFromSchemaUrl(file2);
    }

    @Nullable
    private JsonSchemaVersion getSchemaVersionFromSchemaUrl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(33);
        }
        Ref res2 = Ref.create(null);
        ApplicationManager.getApplication().runReadAction(() -> res2.set((Object)JsonCachedValues.getSchemaUrlFromSchemaProperty(file2, this.myProject)));
        if (res2.isNull()) {
            return null;
        }
        return JsonSchemaVersion.byId((String)res2.get());
    }

    private boolean hasSchemaSchema(VirtualFile file2) {
        return this.getSchemaVersionFromSchemaUrl(file2) != null;
    }

    private static boolean isProviderAvailable(@NotNull VirtualFile file2, @NotNull JsonSchemaFileProvider provider2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(34);
        }
        if (provider2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(35);
        }
        return provider2.isAvailable(file2);
    }

    @Nullable
    private VirtualFile resolveSchemaFromOtherSources(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(36);
        }
        return this.myCatalogManager.getSchemaFileForFile(file2);
    }

    @Override
    public void registerRemoteUpdateCallback(Runnable callback2) {
        this.myCatalogManager.registerCatalogUpdateCallback(callback2);
    }

    @Override
    public void unregisterRemoteUpdateCallback(Runnable callback2) {
        this.myCatalogManager.unregisterCatalogUpdateCallback(callback2);
    }

    @Override
    public void registerResetAction(Runnable action2) {
        this.myResetActions.add(action2);
    }

    @Override
    public void unregisterResetAction(Runnable action2) {
        this.myResetActions.remove(action2);
    }

    @Override
    public void registerReference(String ref) {
        int index2 = StringUtil.lastIndexOfAny((CharSequence)ref, (String)"\\/");
        if (index2 >= 0) {
            ref = ref.substring(index2 + 1);
        }
        this.myRefs.add(ref);
    }

    @Override
    public boolean possiblyHasReference(String ref) {
        return this.myRefs.contains(ref);
    }

    @Override
    public void triggerUpdateRemote() {
        this.myCatalogManager.triggerUpdateCatalog(this.myProject);
    }

    @Override
    public boolean isApplicableToFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        for (JsonSchemaEnabler e : JsonSchemaEnabler.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!e.isEnabledForFile(file2, this.myProject)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JsonSchemaCatalogManager getCatalogManager() {
        JsonSchemaCatalogManager jsonSchemaCatalogManager = this.myCatalogManager;
        if (jsonSchemaCatalogManager == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(37);
        }
        return jsonSchemaCatalogManager;
    }

    @Nullable
    private static VirtualFile getSchemaForProvider(@NotNull Project project, @NotNull JsonSchemaFileProvider provider2) {
        String source;
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(38);
        }
        if (provider2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(39);
        }
        if (JsonSchemaCatalogProjectConfiguration.getInstance(project).isPreferRemoteSchemas() && (source = provider2.getRemoteSource()) != null && !source.endsWith("!") && !JsonFileResolver.isSchemaUrl(source)) {
            return VirtualFileManager.getInstance().findFileByUrl(source);
        }
        return provider2.getSchemaFile();
    }

    @Override
    @Nullable
    public VirtualFile resolveSchemaFile(@NotNull JsonSchemaObject schemaObject) {
        VirtualFile rawFile;
        if (schemaObject == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(40);
        }
        if ((rawFile = schemaObject.getRawFile()) != null) {
            return rawFile;
        }
        String fileUrl = schemaObject.getFileUrl();
        if (fileUrl == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(fileUrl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 3: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaObject";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 10: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFactories";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFilesForFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemasForFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersForFile";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCatalogManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSchemaFileByReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltInSchemaByReference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFilesForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicSchemaForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSchemasForFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersForFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromSchemaProperty";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObject";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObjectForSchemaFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isMappedSchema";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaByProvider";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersion";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaVersionFromSchemaUrl";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isProviderAvailable";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFromOtherSources";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaForProvider";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JsonSchemaProviderFactories {
        private volatile List<JsonSchemaFileProvider> myProviders;

        private JsonSchemaProviderFactories() {
        }

        @NotNull
        public List<JsonSchemaFileProvider> getProviders() {
            List<JsonSchemaFileProvider> providers = this.myProviders;
            if (providers == null) {
                this.myProviders = providers = this.getDumbAwareProvidersAndUpdateRestWhenSmart();
            }
            List<JsonSchemaFileProvider> list2 = providers;
            if (list2 == null) {
                JsonSchemaProviderFactories.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public void reset() {
            this.myProviders = null;
        }

        @NotNull
        private List<JsonSchemaFileProvider> getDumbAwareProvidersAndUpdateRestWhenSmart() {
            ArrayList<JsonSchemaProviderFactory> readyFactories = new ArrayList<JsonSchemaProviderFactory>();
            ArrayList<JsonSchemaProviderFactory> notReadyFactories = new ArrayList<JsonSchemaProviderFactory>();
            boolean dumb = DumbService.getInstance((Project)JsonSchemaServiceImpl.this.myProject).isDumb();
            for (JsonSchemaProviderFactory factory2 : JsonSchemaServiceImpl.this.getProviderFactories()) {
                if (!dumb || DumbService.isDumbAware((Object)factory2)) {
                    readyFactories.add(factory2);
                    continue;
                }
                notReadyFactories.add(factory2);
            }
            List<JsonSchemaFileProvider> providers = this.getProvidersFromFactories(readyFactories);
            this.myProviders = providers;
            if (!notReadyFactories.isEmpty() && !LightEdit.owns((Project)JsonSchemaServiceImpl.this.myProject)) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (JsonSchemaServiceImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    DumbService.getInstance((Project)JsonSchemaServiceImpl.this.myProject).runReadActionInSmartMode(() -> {
                        List<JsonSchemaFileProvider> newProviders;
                        if (this.myProviders == providers && !(newProviders = this.getProvidersFromFactories(notReadyFactories)).isEmpty()) {
                            List<JsonSchemaFileProvider> oldProviders = this.myProviders;
                            this.myProviders = ContainerUtil.concat(oldProviders, newProviders);
                            JsonSchemaServiceImpl.this.resetWithCurrentFactories();
                        }
                    });
                });
            }
            List<JsonSchemaFileProvider> list2 = providers;
            if (list2 == null) {
                JsonSchemaProviderFactories.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        private List<JsonSchemaFileProvider> getProvidersFromFactories(@NotNull List<JsonSchemaProviderFactory> factories2) {
            if (factories2 == null) {
                JsonSchemaProviderFactories.$$$reportNull$$$0(2);
            }
            ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
            for (JsonSchemaProviderFactory factory2 : factories2) {
                try {
                    providers.addAll(factory2.getProviders(JsonSchemaServiceImpl.this.myProject));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    PluginException.logPluginError((Logger)Logger.getInstance(JsonSchemaService.class), (String)e.toString(), (Throwable)e, factory2.getClass());
                }
            }
            ArrayList<JsonSchemaFileProvider> arrayList = providers;
            if (arrayList == null) {
                JsonSchemaProviderFactories.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$JsonSchemaProviderFactories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProviders";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDumbAwareProvidersAndUpdateRestWhenSmart";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$JsonSchemaProviderFactories";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProvidersFromFactories";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvidersFromFactories";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyState {
        @NotNull
        private final Supplier<List<JsonSchemaFileProvider>> myFactory;
        @NotNull
        private final Project myProject;
        @NotNull
        private final ClearableLazyValue<Map<VirtualFile, List<JsonSchemaFileProvider>>> myData;
        private final AtomicBoolean myIsComputed;

        private MyState(@NotNull Supplier<List<JsonSchemaFileProvider>> factory2, @NotNull Project project) {
            if (factory2 == null) {
                MyState.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyState.$$$reportNull$$$0(1);
            }
            this.myIsComputed = new AtomicBoolean(false);
            this.myFactory = factory2;
            this.myProject = project;
            this.myData = new ClearableLazyValue<Map<VirtualFile, List<JsonSchemaFileProvider>>>(){

                @NotNull
                public Map<VirtualFile, List<JsonSchemaFileProvider>> compute() {
                    Map<VirtualFile, List<JsonSchemaFileProvider>> map2 = MyState.createFileProviderMap(myFactory.get(), myProject);
                    myIsComputed.set(true);
                    Map<VirtualFile, List<JsonSchemaFileProvider>> map3 = map2;
                    if (map3 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map3;
                }

                @NotNull
                public synchronized Map<VirtualFile, List<JsonSchemaFileProvider>> getValue() {
                    Map map2 = (Map)super.getValue();
                    if (map2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map2;
                }

                public synchronized void drop() {
                    myIsComputed.set(false);
                    super.drop();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "compute";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getValue";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        public void reset() {
            this.myData.drop();
        }

        public void processProviders(@NotNull Consumer<JsonSchemaFileProvider> consumer2) {
            Map map2;
            if (consumer2 == null) {
                MyState.$$$reportNull$$$0(2);
            }
            if ((map2 = (Map)this.myData.getValue()).isEmpty()) {
                return;
            }
            for (List providers : map2.values()) {
                providers.forEach(consumer2);
            }
        }

        @NotNull
        public Set<VirtualFile> getFiles() {
            Set<VirtualFile> set2 = ((Map)this.myData.getValue()).keySet();
            if (set2 == null) {
                MyState.$$$reportNull$$$0(3);
            }
            return set2;
        }

        @Nullable
        public JsonSchemaFileProvider getProvider(@NotNull VirtualFile file2) {
            List providers;
            if (file2 == null) {
                MyState.$$$reportNull$$$0(4);
            }
            if ((providers = (List)((Map)this.myData.getValue()).get(file2)) == null || providers.isEmpty()) {
                return null;
            }
            for (JsonSchemaFileProvider p : providers) {
                if (p.getSchemaType() != SchemaType.userSchema) continue;
                return p;
            }
            return (JsonSchemaFileProvider)providers.get(0);
        }

        public boolean isComputed() {
            return this.myIsComputed.get();
        }

        @NotNull
        private static Map<VirtualFile, List<JsonSchemaFileProvider>> createFileProviderMap(@NotNull List<JsonSchemaFileProvider> list2, @NotNull Project project) {
            if (list2 == null) {
                MyState.$$$reportNull$$$0(5);
            }
            if (project == null) {
                MyState.$$$reportNull$$$0(6);
            }
            HashMap<VirtualFile, List<JsonSchemaFileProvider>> map2 = new HashMap<VirtualFile, List<JsonSchemaFileProvider>>();
            for (JsonSchemaFileProvider provider2 : list2) {
                VirtualFile schemaFile;
                try {
                    schemaFile = JsonSchemaServiceImpl.getSchemaForProvider(project, provider2);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (schemaFile == null) continue;
                map2.computeIfAbsent(schemaFile, __ -> new SmartList()).add(provider2);
            }
            HashMap<VirtualFile, List<JsonSchemaFileProvider>> hashMap = map2;
            if (hashMap == null) {
                MyState.$$$reportNull$$$0(7);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFileProviderMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processProviders";
                    break;
                }
                case 3: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvider";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileProviderMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

