/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonValidationError;

public class NumericValidation
implements JsonSchemaValidation {
    public static final NumericValidation INSTANCE = new NumericValidation();

    private static void checkNumber(PsiElement propValue, JsonSchemaObject schema2, JsonSchemaType schemaType, JsonValidationHost consumer2) {
        double leftOver;
        Number multipleOf;
        Number value2;
        String valueText = JsonSchemaAnnotatorChecker.getValue(propValue, schema2);
        if (valueText == null) {
            return;
        }
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            value2 = JsonSchemaType.getIntegerValue(valueText);
            if (value2 == null) {
                consumer2.error(JsonBundle.message("schema.validation.integer.expected", new Object[0]), propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                return;
            }
        } else {
            try {
                value2 = Double.valueOf(valueText);
            }
            catch (NumberFormatException e) {
                if (!JsonSchemaType._string_number.equals((Object)schemaType)) {
                    consumer2.error(JsonBundle.message("schema.validation.number.expected", new Object[0]), propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                }
                return;
            }
        }
        if ((multipleOf = schema2.getMultipleOf()) != null && (leftOver = value2.doubleValue() % multipleOf.doubleValue()) > 1.0E-6) {
            String multipleOfValue = String.valueOf(Math.abs(multipleOf.doubleValue() - (double)multipleOf.intValue()) < 1.0E-6 ? (Number)multipleOf.intValue() : (Number)multipleOf);
            consumer2.error(JsonBundle.message("schema.validation.not.multiple.of", multipleOfValue), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        NumericValidation.checkMinimum(schema2, value2, propValue, consumer2);
        NumericValidation.checkMaximum(schema2, value2, propValue, consumer2);
    }

    private static void checkMaximum(JsonSchemaObject schema2, Number value2, PsiElement propertyValue, JsonValidationHost consumer2) {
        Number maximum;
        Number exclusiveMaximumNumber = schema2.getExclusiveMaximumNumber();
        if (exclusiveMaximumNumber != null) {
            double doubleValue = exclusiveMaximumNumber.doubleValue();
            if (value2.doubleValue() >= doubleValue) {
                consumer2.error(JsonBundle.message("schema.validation.greater.than.exclusive.maximum", exclusiveMaximumNumber), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
        if ((maximum = schema2.getMaximum()) == null) {
            return;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema2.isExclusiveMaximum());
        double doubleValue = maximum.doubleValue();
        if (isExclusive) {
            if (value2.doubleValue() >= doubleValue) {
                consumer2.error(JsonBundle.message("schema.validation.greater.than.exclusive.maximum", maximum), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        } else if (value2.doubleValue() > doubleValue) {
            consumer2.error(JsonBundle.message("schema.validation.greater.than.maximum", maximum), propertyValue, JsonErrorPriority.LOW_PRIORITY);
        }
    }

    private static void checkMinimum(JsonSchemaObject schema2, Number value2, PsiElement propertyValue, JsonValidationHost consumer2) {
        Number minimum;
        Number exclusiveMinimumNumber = schema2.getExclusiveMinimumNumber();
        if (exclusiveMinimumNumber != null) {
            double doubleValue = exclusiveMinimumNumber.doubleValue();
            if (value2.doubleValue() <= doubleValue) {
                consumer2.error(JsonBundle.message("schema.validation.less.than.exclusive.minimum", exclusiveMinimumNumber), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
        if ((minimum = schema2.getMinimum()) == null) {
            return;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema2.isExclusiveMinimum());
        double doubleValue = minimum.doubleValue();
        if (isExclusive) {
            if (value2.doubleValue() <= doubleValue) {
                consumer2.error(JsonBundle.message("schema.validation.less.than.exclusive.minimum", minimum), propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        } else if (value2.doubleValue() < doubleValue) {
            consumer2.error(JsonBundle.message("schema.validation.less.than.minimum", minimum), propertyValue, JsonErrorPriority.LOW_PRIORITY);
        }
    }

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema2, JsonSchemaType schemaType, JsonValidationHost consumer2, JsonComplianceCheckerOptions options2) {
        NumericValidation.checkNumber(propValue.getDelegate(), schema2, schemaType, consumer2);
    }
}

