/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaConfigurable;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaPatternComparator;
import com.jetbrains.jsonSchema.settings.mappings.TreeUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaMappingsConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable {
    @NonNls
    public static final String SETTINGS_JSON_SCHEMA = "settings.json.schema";
    private Runnable myInitializer;
    private static final Comparator<UserDefinedJsonSchemaConfiguration> COMPARATOR = (o1, o2) -> {
        if (o1.isApplicationDefined() != o2.isApplicationDefined()) {
            return o1.isApplicationDefined() ? 1 : -1;
        }
        return o1.getName().compareToIgnoreCase(o2.getName());
    };
    static final String STUB_SCHEMA_NAME = "New Schema";
    @Nls
    private String myError;
    @NotNull
    private final Project myProject;
    private final TreeUpdater myTreeUpdater;
    private final Function<String, String> myNameCreator;

    public JsonSchemaMappingsConfigurable(@NotNull Project project) {
        if (project == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(0);
        }
        this.myInitializer = null;
        this.myTreeUpdater = showWarning -> {
            this.TREE_UPDATER.run();
            this.updateWarningText(showWarning);
        };
        this.myNameCreator = s -> this.createUniqueName((String)s);
        this.myProject = project;
        this.initTree();
    }

    @Nullable
    protected String getEmptySelectionString() {
        return this.myRoot.children().hasMoreElements() ? JsonBundle.message("schema.configuration.mapping.empty.area.string", new Object[0]) : JsonBundle.message("schema.configuration.mapping.empty.area.alt.string", new Object[0]);
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new DumbAwareAction(JsonBundle.messagePointer("action.DumbAware.JsonSchemaMappingsConfigurable.text.add", new Object[0]), JsonBundle.messagePointer("action.DumbAware.JsonSchemaMappingsConfigurable.description.add", new Object[0]), IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)JsonSchemaMappingsConfigurable.this.myTree);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JsonSchemaMappingsConfigurable.this.addProjectSchema();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaMappingsConfigurable$1", "actionPerformed"));
            }
        });
        result2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return result2;
    }

    public UserDefinedJsonSchemaConfiguration addProjectSchema() {
        UserDefinedJsonSchemaConfiguration configuration2 = new UserDefinedJsonSchemaConfiguration(this.createUniqueName(STUB_SCHEMA_NAME), JsonSchemaVersion.SCHEMA_4, "", false, null);
        configuration2.setGeneratedName(configuration2.getName());
        this.addCreatedMappings(configuration2);
        return configuration2;
    }

    @NotNull
    @Nls
    private String createUniqueName(@NotNull @NlsSafe String s) {
        if (s == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(1);
        }
        int max = -1;
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            String displayName;
            Object element2 = children2.nextElement();
            if (!(element2 instanceof MasterDetailsComponent.MyNode) || !(displayName = ((MasterDetailsComponent.MyNode)element2).getDisplayName()).startsWith(s)) continue;
            String lastPart = displayName.substring(s.length()).trim();
            if (lastPart.length() == 0 && max == -1) {
                max = 1;
                continue;
            }
            int i2 = JsonSchemaMappingsConfigurable.tryParseInt(lastPart);
            if (i2 == -1) continue;
            max = Math.max(i2, max);
        }
        Object object = max == -1 ? s : s + " " + (max + 1);
        if (object == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(2);
        }
        return object;
    }

    private static int tryParseInt(@NotNull String s) {
        if (s == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(3);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void addCreatedMappings(@NotNull UserDefinedJsonSchemaConfiguration info2) {
        if (info2 == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(4);
        }
        JsonSchemaConfigurable configurable2 = new JsonSchemaConfigurable(this.myProject, "", info2, this.myTreeUpdater, this.myNameCreator);
        configurable2.setError(this.myError, true);
        MasterDetailsComponent.MyNode node2 = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable2);
        this.addNode(node2, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node2, true);
    }

    private void fillTree() {
        this.myRoot.removeAllChildren();
        if (this.myProject.isDefault()) {
            return;
        }
        List<UserDefinedJsonSchemaConfiguration> list2 = this.getStoredList();
        for (UserDefinedJsonSchemaConfiguration info2 : list2) {
            String pathToSchema = info2.getRelativePathToSchema();
            JsonSchemaConfigurable configurable2 = new JsonSchemaConfigurable(this.myProject, JsonFileResolver.isAbsoluteUrl(pathToSchema) || new File(pathToSchema).isAbsolute() ? pathToSchema : new File(this.myProject.getBasePath(), pathToSchema).getPath(), info2, this.myTreeUpdater, this.myNameCreator);
            configurable2.setError(this.myError, true);
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)configurable2));
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        if (this.myRoot.children().hasMoreElements()) {
            this.myTree.addSelectionRow(0);
        }
    }

    @NotNull
    private List<UserDefinedJsonSchemaConfiguration> getStoredList() {
        ArrayList<UserDefinedJsonSchemaConfiguration> list2 = new ArrayList<UserDefinedJsonSchemaConfiguration>();
        Map<String, UserDefinedJsonSchemaConfiguration> projectState = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).getStateMap();
        if (projectState != null) {
            list2.addAll(projectState.values());
        }
        list2.sort(COMPARATOR);
        ArrayList<UserDefinedJsonSchemaConfiguration> arrayList = list2;
        if (arrayList == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void apply() throws ConfigurationException {
        Project[] projects;
        List<UserDefinedJsonSchemaConfiguration> uiList = this.getUiList(true);
        JsonSchemaMappingsConfigurable.validate(uiList);
        HashMap<String, UserDefinedJsonSchemaConfiguration> projectMap = new HashMap<String, UserDefinedJsonSchemaConfiguration>();
        for (UserDefinedJsonSchemaConfiguration info2 : uiList) {
            projectMap.put(info2.getName(), info2);
        }
        JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject).setState(projectMap);
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            JsonSchemaService service = JsonSchemaService.Impl.get(project);
            if (service == null) continue;
            service.reset();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    private static void validate(@NotNull List<UserDefinedJsonSchemaConfiguration> list2) throws ConfigurationException {
        if (list2 == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(6);
        }
        HashSet<String> set2 = new HashSet<String>();
        for (UserDefinedJsonSchemaConfiguration info2 : list2) {
            if (set2.contains(info2.getName())) {
                throw new ConfigurationException(JsonBundle.message("schema.configuration.error.duplicate.name", info2.getName()));
            }
            set2.add(info2.getName());
        }
    }

    public boolean isModified() {
        List<UserDefinedJsonSchemaConfiguration> uiList;
        List<UserDefinedJsonSchemaConfiguration> storedList = this.getStoredList();
        try {
            uiList = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return false;
        }
        return !storedList.equals(uiList);
    }

    private void updateWarningText(boolean showWarning) {
        List<UserDefinedJsonSchemaConfiguration> list2;
        MultiMap patternsMap = new MultiMap();
        StringBuilder sb = new StringBuilder();
        try {
            list2 = this.getUiList(false);
        }
        catch (ConfigurationException e) {
            return;
        }
        for (UserDefinedJsonSchemaConfiguration info2 : list2) {
            info2.refreshPatterns();
            JsonSchemaPatternComparator comparator2 = new JsonSchemaPatternComparator(this.myProject);
            List<UserDefinedJsonSchemaConfiguration.Item> patterns = info2.getPatterns();
            for (UserDefinedJsonSchemaConfiguration.Item pattern : patterns) {
                for (Map.Entry entry2 : patternsMap.entrySet()) {
                    for (UserDefinedJsonSchemaConfiguration.Item item : (Collection)entry2.getValue()) {
                        ThreeState similar = comparator2.isSimilar(pattern, item);
                        if (ThreeState.NO.equals((Object)similar)) continue;
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(JsonBundle.message("schema.configuration.error.conflicting.mappings.desc", pattern.getPresentation(), info2.getName(), item.getPresentation(), entry2.getKey()));
                    }
                }
            }
            patternsMap.put((Object)info2.getName(), patterns);
        }
        this.myError = sb.length() > 0 ? JsonBundle.message("schema.configuration.error.conflicting.mappings.title", sb.toString()) : null;
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode) || !(((MasterDetailsComponent.MyNode)o).getConfigurable() instanceof JsonSchemaConfigurable)) continue;
            ((JsonSchemaConfigurable)((MasterDetailsComponent.MyNode)o).getConfigurable()).setError(this.myError, showWarning);
        }
    }

    public void selectInTree(UserDefinedJsonSchemaConfiguration configuration2) {
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)children2.nextElement();
            JsonSchemaConfigurable configurable2 = (JsonSchemaConfigurable)node2.getConfigurable();
            if (!Objects.equals(configurable2.getUiSchema(), configuration2)) continue;
            this.selectNodeInTree((DefaultMutableTreeNode)node2);
        }
    }

    @NotNull
    private List<UserDefinedJsonSchemaConfiguration> getUiList(boolean applyChildren) throws ConfigurationException {
        ArrayList<UserDefinedJsonSchemaConfiguration> uiList = new ArrayList<UserDefinedJsonSchemaConfiguration>();
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)children2.nextElement();
            if (applyChildren) {
                node2.getConfigurable().apply();
                uiList.add(JsonSchemaMappingsConfigurable.getSchemaInfo(node2));
                continue;
            }
            uiList.add(((JsonSchemaConfigurable)node2.getConfigurable()).getUiSchema());
        }
        uiList.sort(COMPARATOR);
        ArrayList<UserDefinedJsonSchemaConfiguration> arrayList = uiList;
        if (arrayList == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public void setInitializer(@NotNull Runnable initializer) {
        if (initializer == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(8);
        }
        this.myInitializer = initializer;
    }

    public void reset() {
        this.fillTree();
        this.updateWarningText(true);
        if (this.myInitializer != null) {
            this.myInitializer.run();
            this.myInitializer = null;
        }
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        return (o1, o2) -> {
            if (o1.getConfigurable() instanceof JsonSchemaConfigurable && o2.getConfigurable() instanceof JsonSchemaConfigurable) {
                return COMPARATOR.compare(JsonSchemaMappingsConfigurable.getSchemaInfo(o1), JsonSchemaMappingsConfigurable.getSchemaInfo(o2));
            }
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        };
    }

    private static UserDefinedJsonSchemaConfiguration getSchemaInfo(@NotNull MasterDetailsComponent.MyNode node2) {
        if (node2 == null) {
            JsonSchemaMappingsConfigurable.$$$reportNull$$$0(9);
        }
        return ((JsonSchemaConfigurable)node2.getConfigurable()).getSchema();
    }

    @Nls
    public String getDisplayName() {
        return JsonBundle.message("configurable.JsonSchemaMappingsConfigurable.display.name", new Object[0]);
    }

    public void dispose() {
        Enumeration children2 = this.myRoot.children();
        while (children2.hasMoreElements()) {
            Object o = children2.nextElement();
            if (!(o instanceof MasterDetailsComponent.MyNode)) continue;
            ((MasterDetailsComponent.MyNode)o).getConfigurable().disposeUIResources();
        }
    }

    @NotNull
    public String getId() {
        return SETTINGS_JSON_SCHEMA;
    }

    public String getHelpTopic() {
        return SETTINGS_JSON_SCHEMA;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaMappingsConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/settings/mappings/JsonSchemaMappingsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueName";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryParseInt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCreatedMappings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

