/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantEscapeInspection
extends LocalInspectionTool {
    @NotNull
    public RegExpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantEscapeInspection.$$$reportNull$$$0(0);
        }
        return new RedundantEscapeVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/RedundantEscapeInspection", "buildVisitor"));
    }

    private static class RemoveRedundantEscapeFix
    implements LocalQuickFix {
        private RemoveRedundantEscapeFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("inspection.quick.fix.remove.redundant.escape", new Object[0]);
            if (string == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            if (project == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(2);
            }
            if (!((element2 = descriptor2.getPsiElement()) instanceof RegExpChar)) {
                return;
            }
            RegExpReplacementUtil.replaceInContext(element2, RemoveRedundantEscapeFix.replacement((RegExpChar)element2));
        }

        @NotNull
        private static String replacement(RegExpChar aChar) {
            int codePoint = aChar.getValue();
            Object object = Character.isSupplementaryCodePoint(codePoint) ? Character.toString(Character.highSurrogate(codePoint)) + Character.lowSurrogate(codePoint) : Character.toString((char)codePoint);
            if (object == null) {
                RemoveRedundantEscapeFix.$$$reportNull$$$0(3);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/RedundantEscapeInspection$RemoveRedundantEscapeFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/RedundantEscapeInspection$RemoveRedundantEscapeFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RedundantEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RedundantEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            String text2 = ch.getUnescapedText();
            if (!text2.startsWith("\\") || !RegExpLanguageHosts.getInstance().isRedundantEscape(ch, text2)) {
                return;
            }
            ASTNode astNode = ch.getNode().getFirstChildNode();
            if (astNode == null || astNode.getElementType() != RegExpTT.REDUNDANT_ESCAPE) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, RegExpBundle.message("inspection.warning.redundant.character.escape.0.in.regexp", ch.getText()), new LocalQuickFix[]{new RemoveRedundantEscapeFix()});
        }
    }
}

