/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpIntersection;
import org.jetbrains.annotations.NotNull;

public class RedundantNestedCharacterClassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantNestedCharacterClassInspection.$$$reportNull$$$0(0);
        }
        return new RedundantNestedCharacterClassVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/RedundantNestedCharacterClassInspection", "buildVisitor"));
    }

    private static class RedundantNestedCharacterClassVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RedundantNestedCharacterClassVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            RegExpClass grandparentClass;
            PsiElement grandParent;
            super.visitRegExpClass(regExpClass);
            PsiElement parent = regExpClass.getParent();
            if (parent instanceof RegExpClass) {
                RegExpClass parentClass = (RegExpClass)parent;
                if (!parentClass.isNegated() && !regExpClass.isNegated()) {
                    this.myHolder.registerProblem(regExpClass.getFirstChild(), RegExpBundle.message("inspection.warning.redundant.nested.character.class", new Object[0]), new LocalQuickFix[]{new RedundantNestedCharacterClassFix()});
                }
            } else if (parent instanceof RegExpIntersection && (grandParent = parent.getParent()) instanceof RegExpClass && !(grandparentClass = (RegExpClass)grandParent).isNegated() && !regExpClass.isNegated()) {
                this.myHolder.registerProblem(regExpClass.getFirstChild(), RegExpBundle.message("inspection.warning.redundant.nested.character.class", new Object[0]), new LocalQuickFix[]{new RedundantNestedCharacterClassFix()});
            }
        }

        private static class RedundantNestedCharacterClassFix
        implements LocalQuickFix {
            private RedundantNestedCharacterClassFix() {
            }

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = RegExpBundle.message("inspection.quick.fix.replace.redundant.character.class.with.contents", new Object[0]);
                if (string == null) {
                    RedundantNestedCharacterClassFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PsiElement element2;
                if (project == null) {
                    RedundantNestedCharacterClassFix.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    RedundantNestedCharacterClassFix.$$$reportNull$$$0(2);
                }
                if ((element2 = descriptor2.getPsiElement().getParent()) instanceof RegExpClass) {
                    RegExpClass regExpClass = (RegExpClass)element2;
                    RegExpClassElement[] elements = regExpClass.getElements();
                    PsiElement parent = regExpClass.getParent();
                    for (RegExpClassElement classElement : elements) {
                        parent.addBefore((PsiElement)classElement, (PsiElement)regExpClass);
                    }
                    regExpClass.delete();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/inspection/RedundantNestedCharacterClassInspection$RedundantNestedCharacterClassVisitor$RedundantNestedCharacterClassFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/inspection/RedundantNestedCharacterClassInspection$RedundantNestedCharacterClassVisitor$RedundantNestedCharacterClassFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

