/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpCharImpl
extends RegExpElementImpl
implements RegExpChar {
    private static final TokenSet OCT_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.OCT_CHAR, RegExpTT.BAD_OCT_VALUE});
    private static final TokenSet HEX_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.HEX_CHAR, RegExpTT.BAD_HEX_VALUE});
    private static final TokenSet UNICODE_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.UNICODE_CHAR, StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});

    public RegExpCharImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public RegExpChar.Type getType() {
        IElementType t = this.getNode().getFirstChildNode().getElementType();
        if (OCT_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.OCT;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(0);
            }
            return type;
        }
        if (HEX_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.HEX;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(1);
            }
            return type;
        }
        if (UNICODE_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.UNICODE;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(2);
            }
            return type;
        }
        if (t == RegExpTT.NAMED_CHARACTER) {
            RegExpChar.Type type = RegExpChar.Type.NAMED;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(3);
            }
            return type;
        }
        if (t == RegExpTT.CTRL) {
            RegExpChar.Type type = RegExpChar.Type.CONTROL;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(4);
            }
            return type;
        }
        RegExpChar.Type type = RegExpChar.Type.CHAR;
        if (type == null) {
            RegExpCharImpl.$$$reportNull$$$0(5);
        }
        return type;
    }

    @Override
    public int getValue() {
        int i2;
        ASTNode node2 = this.getNode();
        IElementType type = node2.getFirstChildNode().getElementType();
        if (type == RegExpTT.BAD_OCT_VALUE || type == RegExpTT.BAD_HEX_VALUE || type == RegExpTT.BAD_CHARACTER || type == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
            return -1;
        }
        String text2 = this.getUnescapedText();
        if (text2.length() == 1 && (type == RegExpTT.CHARACTER || type == RegExpTT.CTRL_CHARACTER)) {
            return text2.codePointAt(0);
        }
        if (type == RegExpTT.UNICODE_CHAR && (i2 = text2.indexOf(92, 1)) >= 0) {
            return Character.toCodePoint((char)RegExpCharImpl.unescapeChar(text2.substring(0, i2)), (char)RegExpCharImpl.unescapeChar(text2.substring(i2)));
        }
        return RegExpCharImpl.unescapeChar(text2);
    }

    public static int unescapeChar(String s) {
        int c = s.codePointAt(0);
        int length = s.length();
        if (length == 1 || c != 92) {
            return -1;
        }
        int codePoint = s.codePointAt(1);
        switch (codePoint) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 98: {
                return 8;
            }
            case 99: {
                if (length != 3) {
                    return -1;
                }
                return s.codePointAt(2) ^ 0x40;
            }
            case 78: {
                if (length < 4 || s.charAt(2) != '{' || s.charAt(length - 1) != '}') {
                    return -1;
                }
                return UnicodeCharacterNames.getCodePoint(s.substring(3, length - 1));
            }
            case 120: {
                if (length <= 2) {
                    return -1;
                }
                if (s.charAt(2) == '{') {
                    return s.charAt(length - 1) != '}' ? -1 : RegExpCharImpl.parseNumber(s, 3, 16);
                }
                if (length == 3) {
                    return RegExpCharImpl.parseNumber(s, 2, 16);
                }
                return length == 4 ? RegExpCharImpl.parseNumber(s, 2, 16) : -1;
            }
            case 117: {
                if (length <= 2) {
                    return 117;
                }
                if (s.charAt(2) == '{') {
                    return s.charAt(length - 1) != '}' ? -1 : RegExpCharImpl.parseNumber(s, 3, 16);
                }
                return length != 6 ? -1 : RegExpCharImpl.parseNumber(s, 2, 16);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return RegExpCharImpl.parseNumber(s, 1, 8);
            }
        }
        return codePoint;
    }

    private static int parseNumber(String s, int offset, int radix) {
        int digit;
        int i2;
        int sum = 0;
        for (i2 = offset; i2 < s.length() && (digit = Character.digit(s.charAt(i2), radix)) >= 0; ++i2) {
            if ((sum = sum * radix + digit) <= 0x10FFFF) continue;
            return -1;
        }
        if (i2 - offset <= 0) {
            return -1;
        }
        return sum;
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpChar(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpCharImpl", "getType"));
    }
}

