/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.util.XmlEnumeratedValueReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DAttributePattern;
import org.xml.sax.Locator;

public final class RngXmlAttributeDescriptor
extends BasicXmlAttributeDescriptor {
    @NonNls
    private static final QName UNKNOWN = new QName("", "#unknown");
    private static final HashingStrategy<Locator> HASHING_STRATEGY = new HashingStrategy<Locator>(){

        public int hashCode(@Nullable Locator o) {
            if (o == null) {
                return 0;
            }
            String s = o.getSystemId();
            return o.getLineNumber() * 31 + o.getColumnNumber() * 23 + (s != null ? s.hashCode() * 11 : 0);
        }

        public boolean equals(@Nullable Locator o, @Nullable Locator o1) {
            if (o == o1) {
                return true;
            }
            if (o == null || o1 == null) {
                return false;
            }
            return o.getLineNumber() == o1.getLineNumber() && o.getColumnNumber() == o1.getColumnNumber() && Objects.equals(o.getSystemId(), o1.getSystemId());
        }
    };
    private final Map<String, String> myValues;
    private final boolean myOptional;
    private final RngElementDescriptor myElementDescriptor;
    private final Set<Locator> myDeclarations = CollectionFactory.createCustomHashingStrategySet(HASHING_STRATEGY);
    private final QName myName;

    RngXmlAttributeDescriptor(RngElementDescriptor elementDescriptor, DAttributePattern pattern, Map<String, String> values2, boolean optional) {
        this(elementDescriptor, RngXmlAttributeDescriptor.getName(pattern), values2, optional, pattern.getLocation());
    }

    private static QName getName(DAttributePattern pattern) {
        Iterator iterator2 = pattern.getName().listNames().iterator();
        return iterator2.hasNext() ? (QName)iterator2.next() : UNKNOWN;
    }

    private RngXmlAttributeDescriptor(RngElementDescriptor elementDescriptor, QName name2, Map<String, String> values2, boolean optional, Locator ... locations) {
        this.myElementDescriptor = elementDescriptor;
        this.myValues = values2;
        this.myOptional = optional;
        this.myName = name2;
        this.myDeclarations.addAll(Arrays.asList(locations));
    }

    public RngXmlAttributeDescriptor mergeWith(RngXmlAttributeDescriptor d) {
        QName name2 = d.myName.equals(UNKNOWN) ? this.myName : d.myName;
        LinkedHashMap<String, String> values2 = new LinkedHashMap<String, String>(this.myValues);
        values2.putAll(d.myValues);
        Set locations = CollectionFactory.createCustomHashingStrategySet(HASHING_STRATEGY);
        locations.addAll(this.myDeclarations);
        locations.addAll(d.myDeclarations);
        return new RngXmlAttributeDescriptor(this.myElementDescriptor, name2, values2, this.myOptional || d.myOptional, locations.toArray(new Locator[0]));
    }

    public boolean isRequired() {
        return !this.myOptional;
    }

    @Override
    public boolean isFixed() {
        return this.isEnumerated() && this.myValues.size() == 1;
    }

    public boolean hasIdType() {
        return this.myValues.containsValue("ID");
    }

    public boolean hasIdRefType() {
        return this.myValues.containsValue("IDREF");
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.isEnumerated() ? this.myValues.keySet().iterator().next() : null;
    }

    public boolean isEnumerated() {
        return this.myValues.size() > 0 && this.myValues.get(null) == null;
    }

    @Override
    public String[] getEnumeratedValues() {
        if (this.myValues.size() > 0) {
            Map<String, String> copy2;
            if (this.myValues.get(null) != null) {
                copy2 = new HashMap<String, String>(this.myValues);
                copy2.remove(null);
            } else {
                copy2 = this.myValues;
            }
            return ArrayUtilRt.toStringArray(copy2.keySet());
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public PsiElement getDeclaration() {
        Iterator<Locator> it = this.myDeclarations.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return this.myElementDescriptor.getDeclaration(it.next());
    }

    @NotNull
    public Collection<PsiElement> getDeclarations() {
        List list2 = ContainerUtil.map2List(this.myDeclarations, locator -> this.myElementDescriptor.getDeclaration((Locator)locator));
        if (list2 == null) {
            RngXmlAttributeDescriptor.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    public String getName(PsiElement context2) {
        String prefix2;
        String uri;
        String prefix;
        XmlTag tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlTag.class, (boolean)false, (Class[])new Class[]{PsiFile.class});
        if (tag2 != null && (prefix = tag2.getPrefixByNamespace(uri = this.myName.getNamespaceURI())) != null) {
            if (prefix.length() == 0) {
                return this.myName.getLocalPart();
            }
            return prefix + ":" + this.myName.getLocalPart();
        }
        if (this.myName.getNamespaceURI().length() > 0 && (prefix2 = this.myName.getPrefix()) != null && prefix2.length() > 0) {
            return prefix2 + ":" + this.myName.getLocalPart();
        }
        return this.myName.getLocalPart();
    }

    @NonNls
    public String getName() {
        return this.myName.getLocalPart();
    }

    public void init(PsiElement element2) {
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = this.myElementDescriptor.getDependencies();
        if (objectArray == null) {
            RngXmlAttributeDescriptor.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @Override
    public String validateValue(XmlElement context2, String value2) {
        if (this.isTokenDatatype(value2)) {
            value2 = RngXmlAttributeDescriptor.normalizeSpace(value2);
        }
        return super.validateValue(context2, value2);
    }

    private boolean isTokenDatatype(String value2) {
        if (this.myValues.containsKey(value2)) {
            return "token".equals(this.myValues.get(value2));
        }
        return this.myValues.containsKey(value2 = RngXmlAttributeDescriptor.normalizeSpace(value2)) && "token".equals(this.myValues.get(value2));
    }

    private static String normalizeSpace(String value2) {
        return value2.replaceAll("\\s+", " ").trim();
    }

    public PsiReference[] getValueReferences(XmlElement element2, @NotNull String text2) {
        if (text2 == null) {
            RngXmlAttributeDescriptor.$$$reportNull$$$0(2);
        }
        return new PsiReference[]{new XmlEnumeratedValueReference(element2, this){

            @Override
            @Nullable
            public PsiElement resolve() {
                if (RngXmlAttributeDescriptor.this.isTokenDatatype(this.getValue())) {
                    return this.getElement();
                }
                return super.resolve();
            }
        }};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/model/descriptors/RngXmlAttributeDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/model/descriptors/RngXmlAttributeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValueReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

