/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.openapi.util.Key;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResolvingVisitor
extends XmlElementVisitor
implements PsiElementProcessor {
    static final Key<Set<XmlFile>> VISITED_KEY = Key.create((String)"visited");
    private final XmlAttributeValuePattern myPattern;
    private final ProcessingContext myProcessingContext;
    private XmlNamedElementPattern myIncludePattern;

    ResolvingVisitor(XmlAttributeValuePattern pattern, ProcessingContext context2) {
        this.myPattern = pattern;
        this.myProcessingContext = context2;
        this.myProcessingContext.put(VISITED_KEY, new HashSet());
    }

    public void visitXmlDocument(@Nullable XmlDocument document) {
        XmlTag rootTag;
        if (document != null && (rootTag = document.getRootTag()) != null) {
            this.visitXmlTag(rootTag);
        }
    }

    public void setIncludePattern(XmlNamedElementPattern includePattern) {
        this.myIncludePattern = includePattern;
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
        if (this.myIncludePattern != null && this.myIncludePattern.accepts((Object)attribute, this.myProcessingContext)) {
            String value2 = attribute.getValue();
            if (value2 == null) {
                return;
            }
            XmlFile xmlFile = XmlUtil.findXmlFile(attribute.getContainingFile(), value2);
            if (xmlFile != null) {
                this.processInclude(xmlFile, attribute);
            }
        } else {
            this.processAttribute(attribute);
        }
    }

    private void processAttribute(XmlAttribute attribute) {
        this.myPattern.accepts((Object)attribute.getValueElement(), this.myProcessingContext);
    }

    public void visitXmlTag(XmlTag tag2) {
        this.visitAttributes(tag2);
    }

    protected void visitAttributes(XmlTag tag2) {
        XmlAttribute[] xmlAttributes;
        for (XmlAttribute attribute : xmlAttributes = tag2.getAttributes()) {
            attribute.accept((PsiElementVisitor)this);
        }
    }

    protected void visitSubTags(XmlTag tag2) {
        XmlTag[] tags;
        for (XmlTag subTag : tags = tag2.getSubTags()) {
            if (!this.shouldContinue()) continue;
            subTag.accept((PsiElementVisitor)this);
        }
    }

    private void processInclude(XmlFile xmlFile, XmlAttribute attribute) {
        Set set2 = (Set)this.myProcessingContext.get(VISITED_KEY);
        if (set2.contains(xmlFile)) {
            return;
        }
        set2.add(xmlFile);
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        rootTag.processElements((PsiElementProcessor)this, (PsiElement)attribute);
    }

    public boolean execute(@NotNull PsiElement element2) {
        if (element2 == null) {
            ResolvingVisitor.$$$reportNull$$$0(0);
        }
        element2.accept((PsiElementVisitor)this);
        return this.shouldContinue();
    }

    protected boolean shouldContinue() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/references/ResolvingVisitor", "execute"));
    }
}

