/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.xml.dom.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.intellij.plugins.relaxNG.xml.dom.impl.DefinitionReference;
import org.jetbrains.annotations.NotNull;

class CreatePatternFix
implements IntentionAction,
LocalQuickFix {
    private final PsiReference myReference;

    CreatePatternFix(PsiReference reference2) {
        this.myReference = reference2;
    }

    @NotNull
    public String getText() {
        String string = RelaxngBundle.message("relaxng.quickfix.create-pattern.name", this.myReference.getCanonicalText());
        if (string == null) {
            CreatePatternFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RelaxngBundle.message("relaxng.quickfix.create-pattern.family", new Object[0]);
        if (string == null) {
            CreatePatternFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            CreatePatternFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            CreatePatternFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            CreatePatternFix.$$$reportNull$$$0(4);
        }
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.doFix();
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            CreatePatternFix.$$$reportNull$$$0(5);
        }
        return this.isAvailable();
    }

    private boolean isAvailable() {
        if (!(this.myReference instanceof DefinitionReference) || !this.myReference.getElement().isValid()) {
            return false;
        }
        RngGrammar grammar = ((DefinitionReference)this.myReference).getScope();
        if (grammar == null) {
            return false;
        }
        return grammar.getXmlTag() != null;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            CreatePatternFix.$$$reportNull$$$0(6);
        }
        this.doFix();
    }

    private void doFix() throws IncorrectOperationException {
        XmlTag[] tags;
        XmlTag tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myReference.getElement(), XmlTag.class);
        assert (tag2 != null);
        XmlTag defineTag = tag2.createChildTag("define", "http://relaxng.org/ns/structure/1.0", "\n \n", false);
        defineTag.setAttribute("name", this.myReference.getCanonicalText());
        RngGrammar grammar = ((DefinitionReference)this.myReference).getScope();
        if (grammar == null) {
            return;
        }
        XmlTag root2 = grammar.getXmlTag();
        if (root2 == null) {
            return;
        }
        for (XmlTag xmlTag : tags = root2.getSubTags()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)xmlTag, (PsiElement)tag2, (boolean)false)) continue;
            XmlElementFactory ef = XmlElementFactory.getInstance((Project)tag2.getProject());
            XmlText text2 = ef.createDisplayText(" ");
            PsiElement e = root2.addAfter((PsiElement)text2, (PsiElement)xmlTag);
            root2.addAfter((PsiElement)defineTag, e);
            return;
        }
        root2.add((PsiElement)defineTag);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static XmlTag getAncestorTag(XmlTag tag2, String name2, String namespace) {
        if (tag2 == null) {
            return null;
        }
        if (tag2.getLocalName().equals(name2) && tag2.getNamespace().equals(namespace)) {
            return tag2;
        }
        return CreatePatternFix.getAncestorTag(tag2.getParentTag(), name2, namespace);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/xml/dom/impl/CreatePatternFix";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/xml/dom/impl/CreatePatternFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

