/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.statistics.ShCounterUsagesCollector;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShShfmtFormatterUtil {
    private static final Logger LOG = Logger.getInstance(ShShfmtFormatterUtil.class);
    private static final Key<Boolean> UPDATE_NOTIFICATION_SHOWN = Key.create((String)"SHFMT_UPDATE");
    @NlsSafe
    private static final String SHFMT = "shfmt";
    @NlsSafe
    private static final String OLD_SHFMT = "old_shfmt";
    @NlsSafe
    private static final String SHFMT_VERSION = "v3.3.1";
    @NlsSafe
    private static final String DOWNLOAD_PATH = PathManager.getPluginsPath() + File.separator + ShLanguage.INSTANCE.getID();
    @NlsSafe
    private static final String ARCH_i386 = "_386";
    @NlsSafe
    private static final String ARCH_x86_64 = "_amd64";
    @NlsSafe
    private static final String ARCH_ARM64 = "_arm64";
    @NlsSafe
    private static final String WINDOWS = "_windows";
    @NlsSafe
    private static final String WINDOWS_EXTENSION = ".exe";
    @NlsSafe
    private static final String MAC = "_darwin";
    @NlsSafe
    private static final String LINUX = "_linux";
    @NlsSafe
    private static final String FREE_BSD = "_freebsd";

    public static void download(@Nullable Project project, @NotNull Runnable onSuccess, @NotNull Runnable onFailure) {
        if (onSuccess == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(0);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(1);
        }
        ShShfmtFormatterUtil.download(project, onSuccess, onFailure, false);
    }

    private static void download(@Nullable Project project, final @NotNull Runnable onSuccess, final @NotNull Runnable onFailure, final boolean withReplace) {
        File directory;
        if (onSuccess == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(2);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(3);
        }
        if (!(directory = new File(DOWNLOAD_PATH)).exists()) {
            directory.mkdirs();
        }
        final File formatter = new File(DOWNLOAD_PATH + File.separator + SHFMT + (SystemInfo.isWindows ? WINDOWS_EXTENSION : ""));
        final File oldFormatter = new File(DOWNLOAD_PATH + File.separator + OLD_SHFMT + (SystemInfo.isWindows ? WINDOWS_EXTENSION : ""));
        if (formatter.exists()) {
            if (withReplace) {
                boolean successful = ShShfmtFormatterUtil.renameOldFormatter(formatter, oldFormatter, onFailure);
                if (!successful) {
                    return;
                }
            } else {
                ShShfmtFormatterUtil.setupFormatterPath(formatter, onSuccess, onFailure);
                return;
            }
        }
        String downloadName = SHFMT + (SystemInfo.isWindows ? WINDOWS_EXTENSION : "");
        DownloadableFileService service = DownloadableFileService.getInstance();
        DownloadableFileDescription description = service.createFileDescription(ShShfmtFormatterUtil.getShfmtDistributionLink(), downloadName);
        final FileDownloader downloader = service.createDownloader(Collections.singletonList(description), downloadName);
        Task.Backgroundable task = new Task.Backgroundable(project, ShBundle.message("sh.label.download.shfmt.formatter", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    File file;
                    List pairs = downloader.download(new File(DOWNLOAD_PATH));
                    Pair first = (Pair)ContainerUtil.getFirstItem((List)pairs);
                    File file2 = file = first != null ? (File)first.first : null;
                    if (file != null) {
                        FileUtil.setExecutable((File)file);
                        ShSettings.setShfmtPath(file.getCanonicalPath());
                        if (withReplace) {
                            LOG.info("Remove old formatter");
                            FileUtil.delete((File)oldFormatter);
                        }
                        ApplicationManager.getApplication().invokeLater(onSuccess);
                        ShCounterUsagesCollector.EXTERNAL_FORMATTER_DOWNLOADED_EVENT_ID.log();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Can't download shfmt formatter", (Throwable)e);
                    if (withReplace) {
                        ShShfmtFormatterUtil.rollbackToOldFormatter(formatter, oldFormatter);
                    }
                    ApplicationManager.getApplication().invokeLater(onFailure);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/sh/formatter/ShShfmtFormatterUtil$1", "run"));
            }
        };
        BackgroundableProcessIndicator processIndicator = new BackgroundableProcessIndicator(task);
        processIndicator.setIndeterminate(false);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)processIndicator);
    }

    private static void setupFormatterPath(@NotNull File formatter, @NotNull Runnable onSuccess, @NotNull Runnable onFailure) {
        if (formatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(4);
        }
        if (onSuccess == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(5);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(6);
        }
        try {
            String formatterPath = formatter.getCanonicalPath();
            if (ShSettings.getShfmtPath().equals(formatterPath)) {
                LOG.info("Shfmt formatter already downloaded");
            } else {
                ShSettings.setShfmtPath(formatterPath);
            }
            if (!formatter.canExecute()) {
                FileUtil.setExecutable((File)formatter);
            }
            ApplicationManager.getApplication().invokeLater(onSuccess);
        }
        catch (IOException e) {
            LOG.warn("Can't evaluate formatter path or make it executable", (Throwable)e);
            ApplicationManager.getApplication().invokeLater(onFailure);
        }
    }

    private static boolean renameOldFormatter(@NotNull File formatter, @NotNull File oldFormatter, @NotNull Runnable onFailure) {
        if (formatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(7);
        }
        if (oldFormatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(8);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(9);
        }
        LOG.info("Rename formatter to the temporary filename");
        try {
            FileUtil.rename((File)formatter, (File)oldFormatter);
        }
        catch (IOException e) {
            LOG.info("Can't rename formatter to the temporary filename", (Throwable)e);
            ApplicationManager.getApplication().invokeLater(onFailure);
            return false;
        }
        return true;
    }

    private static void rollbackToOldFormatter(@NotNull File formatter, @NotNull File oldFormatter) {
        if (formatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(10);
        }
        if (oldFormatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(11);
        }
        LOG.info("Update failed, rollback");
        try {
            FileUtil.rename((File)oldFormatter, (File)formatter);
        }
        catch (IOException e) {
            LOG.info("Can't rollback formatter after failed update", (Throwable)e);
        }
        FileUtil.delete((File)oldFormatter);
    }

    public static boolean isValidPath(@Nullable String path) {
        if (path == null) {
            return false;
        }
        if (ShSettings.I_DO_MIND_SUPPLIER.get().equals(path)) {
            return true;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            return false;
        }
        return file.getName().contains(SHFMT);
    }

    static void checkShfmtForUpdate(@NotNull Project project) {
        Application application;
        if (project == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(12);
        }
        if ((application = ApplicationManager.getApplication()).getUserData(UPDATE_NOTIFICATION_SHOWN) != null) {
            return;
        }
        application.putUserData(UPDATE_NOTIFICATION_SHOWN, (Object)true);
        if (application.isDispatchThread()) {
            application.executeOnPooledThread(() -> ShShfmtFormatterUtil.checkForUpdateInBackgroundThread(project));
        } else {
            ShShfmtFormatterUtil.checkForUpdateInBackgroundThread(project);
        }
    }

    private static void checkForUpdateInBackgroundThread(@NotNull Project project) {
        if (project == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(13);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("Must not be in event-dispatch thread");
        }
        if (!ShShfmtFormatterUtil.isNewVersionAvailable()) {
            return;
        }
        Notification notification = new Notification(ShLanguage.NOTIFICATION_GROUP_ID, ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.update.question", new Object[0]), NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.update", new Object[0]), () -> {
            notification.expire();
            ShShfmtFormatterUtil.download(project, () -> Notifications.Bus.notify((Notification)new Notification(ShLanguage.NOTIFICATION_GROUP_ID, ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.success.update", new Object[0]), NotificationType.INFORMATION)), () -> Notifications.Bus.notify((Notification)new Notification(ShLanguage.NOTIFICATION_GROUP_ID, ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.cannot.update", new Object[0]), NotificationType.ERROR)), true);
        }));
        notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.skip.version", new Object[0]), () -> {
            notification.expire();
            ShSettings.setSkippedShfmtVersion(SHFMT_VERSION);
        }));
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static boolean isNewVersionAvailable() {
        String path = ShSettings.getShfmtPath();
        if (ShSettings.I_DO_MIND_SUPPLIER.get().equals(path)) {
            return false;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            return false;
        }
        if (!file.getName().contains(SHFMT)) {
            return false;
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(path).withParameters(new String[]{"--version"});
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)3000);
            String stdout = processOutput.getStdout();
            return !stdout.contains(SHFMT_VERSION) && !ShSettings.getSkippedShfmtVersion().equals(SHFMT_VERSION);
        }
        catch (ExecutionException e) {
            LOG.debug("Exception in process execution", (Throwable)e);
            return false;
        }
    }

    @NotNull
    private static String getShfmtDistributionLink() {
        StringBuilder baseUrl = new StringBuilder("https://github.com/mvdan/sh/releases/download/").append(SHFMT_VERSION).append('/').append(SHFMT).append('_').append(SHFMT_VERSION);
        if (SystemInfo.isMac) {
            baseUrl.append(MAC);
        } else if (SystemInfo.isLinux) {
            baseUrl.append(LINUX);
        } else if (SystemInfo.isWindows) {
            baseUrl.append(WINDOWS);
        } else if (SystemInfo.isFreeBSD) {
            baseUrl.append(FREE_BSD);
        }
        if (CpuArch.isIntel64()) {
            baseUrl.append(ARCH_x86_64);
        }
        if (CpuArch.isIntel32()) {
            baseUrl.append(ARCH_i386);
        } else if (CpuArch.isArm64()) {
            baseUrl.append(ARCH_ARM64);
        }
        if (SystemInfo.isWindows) {
            baseUrl.append(WINDOWS_EXTENSION);
        }
        String string = baseUrl.toString();
        if (string == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailure";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFormatter";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/formatter/ShShfmtFormatterUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/formatter/ShShfmtFormatterUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getShfmtDistributionLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupFormatterPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renameOldFormatter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rollbackToOldFormatter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkShfmtForUpdate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkForUpdateInBackgroundThread";
                break;
            }
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

