/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitSetIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BitSet
implements Cloneable {
    private static final long DEFAULT_NUM_BITS = 64L;
    public long[] bits;
    public int wlen;

    public BitSet() {
        this(64L);
    }

    public BitSet(long numBits) {
        this.bits = new long[BitSet.bits2words(numBits)];
        this.wlen = this.bits.length;
    }

    public BitSet(long[] bits, int numWords) {
        this.bits = bits;
        this.wlen = numWords;
    }

    public static BitSet newInstance() {
        return new BitSet();
    }

    public BitSetIterator iterator() {
        return new BitSetIterator(this.bits, this.wlen);
    }

    public long capacity() {
        return this.bits.length << 6;
    }

    public long size() {
        return this.capacity();
    }

    public long length() {
        this.trimTrailingZeros();
        if (this.wlen == 0) {
            return 0L;
        }
        return ((long)this.wlen - 1L << 6) + (long)(64 - Long.numberOfLeadingZeros(this.bits[this.wlen - 1]));
    }

    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public boolean get(int index) {
        int i2 = index >> 6;
        if (i2 >= this.bits.length) {
            return false;
        }
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i2] & bitmask) != 0L;
    }

    public boolean get(long index) {
        int i2 = (int)(index >> 6);
        if (i2 >= this.bits.length) {
            return false;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i2] & bitmask) != 0L;
    }

    public void set(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void set(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] | startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] | endmask;
    }

    protected int expandingWordNum(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.wlen) {
            this.ensureCapacity(index + 1L);
            this.wlen = wordNum + 1;
        }
        return wordNum;
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
        this.wlen = 0;
    }

    public void clear(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.wlen) {
            return;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int startIndex, int endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        Arrays.fill(this.bits, startWord + 1, middle, 0L);
        if (endWord < this.wlen) {
            int n2 = endWord;
            this.bits[n2] = this.bits[n2] & endmask;
        }
    }

    public void clear(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        Arrays.fill(this.bits, startWord + 1, middle, 0L);
        if (endWord < this.wlen) {
            int n2 = endWord;
            this.bits[n2] = this.bits[n2] & endmask;
        }
    }

    public boolean getAndSet(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public boolean getAndSet(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public void flip(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public boolean flipAndGet(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
        return (this.bits[wordNum] & bitmask) != 0L;
    }

    public boolean flipAndGet(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
        return (this.bits[wordNum] & bitmask) != 0L;
    }

    public void flip(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] ^ startmask;
        for (int i2 = startWord + 1; i2 < endWord; ++i2) {
            this.bits[i2] = this.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] ^ endmask;
    }

    public long cardinality() {
        return BitUtil.pop_array(this.bits, 0, this.wlen);
    }

    public static long intersectionCount(BitSet a2, BitSet b2) {
        return BitUtil.pop_intersect(a2.bits, b2.bits, 0, Math.min(a2.wlen, b2.wlen));
    }

    public static long unionCount(BitSet a2, BitSet b2) {
        long tot = BitUtil.pop_union(a2.bits, b2.bits, 0, Math.min(a2.wlen, b2.wlen));
        if (a2.wlen < b2.wlen) {
            tot += BitUtil.pop_array(b2.bits, a2.wlen, b2.wlen - a2.wlen);
        } else if (a2.wlen > b2.wlen) {
            tot += BitUtil.pop_array(a2.bits, b2.wlen, a2.wlen - b2.wlen);
        }
        return tot;
    }

    public static long andNotCount(BitSet a2, BitSet b2) {
        long tot = BitUtil.pop_andnot(a2.bits, b2.bits, 0, Math.min(a2.wlen, b2.wlen));
        if (a2.wlen > b2.wlen) {
            tot += BitUtil.pop_array(a2.bits, b2.wlen, a2.wlen - b2.wlen);
        }
        return tot;
    }

    public static long xorCount(BitSet a2, BitSet b2) {
        long tot = BitUtil.pop_xor(a2.bits, b2.bits, 0, Math.min(a2.wlen, b2.wlen));
        if (a2.wlen < b2.wlen) {
            tot += BitUtil.pop_array(b2.bits, a2.wlen, b2.wlen - a2.wlen);
        } else if (a2.wlen > b2.wlen) {
            tot += BitUtil.pop_array(a2.bits, b2.wlen, a2.wlen - b2.wlen);
        }
        return tot;
    }

    public int nextSetBit(int index) {
        int i2 = index >> 6;
        if (i2 >= this.wlen) {
            return -1;
        }
        int subIndex = index & 0x3F;
        long word = this.bits[i2] >> subIndex;
        if (word != 0L) {
            return (i2 << 6) + subIndex + Long.numberOfTrailingZeros(word);
        }
        while (++i2 < this.wlen) {
            word = this.bits[i2];
            if (word == 0L) continue;
            return (i2 << 6) + Long.numberOfTrailingZeros(word);
        }
        return -1;
    }

    public long nextSetBit(long index) {
        int i2 = (int)(index >>> 6);
        if (i2 >= this.wlen) {
            return -1L;
        }
        int subIndex = (int)index & 0x3F;
        long word = this.bits[i2] >>> subIndex;
        if (word != 0L) {
            return ((long)i2 << 6) + (long)(subIndex + Long.numberOfTrailingZeros(word));
        }
        while (++i2 < this.wlen) {
            word = this.bits[i2];
            if (word == 0L) continue;
            return ((long)i2 << 6) + (long)Long.numberOfTrailingZeros(word);
        }
        return -1L;
    }

    public Object clone() {
        try {
            BitSet obs = (BitSet)super.clone();
            obs.bits = (long[])obs.bits.clone();
            return obs;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void intersect(BitSet other) {
        int newLen = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = newLen;
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & otherArr[pos];
        }
        if (this.wlen > newLen) {
            Arrays.fill(this.bits, newLen, this.wlen, 0L);
        }
        this.wlen = newLen;
    }

    public void union(BitSet other) {
        int newLen = Math.max(this.wlen, other.wlen);
        this.ensureCapacityWords(newLen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = Math.min(this.wlen, other.wlen);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] | otherArr[pos];
        }
        if (this.wlen < newLen) {
            System.arraycopy(otherArr, this.wlen, thisArr, this.wlen, newLen - this.wlen);
        }
        this.wlen = newLen;
    }

    public void remove(BitSet other) {
        int idx = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        while (--idx >= 0) {
            int n = idx;
            thisArr[n] = thisArr[n] & (otherArr[idx] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void xor(BitSet other) {
        int newLen = Math.max(this.wlen, other.wlen);
        this.ensureCapacityWords(newLen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = Math.min(this.wlen, other.wlen);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] ^ otherArr[pos];
        }
        if (this.wlen < newLen) {
            System.arraycopy(otherArr, this.wlen, thisArr, this.wlen, newLen - this.wlen);
        }
        this.wlen = newLen;
    }

    public void and(BitSet other) {
        this.intersect(other);
    }

    public void or(BitSet other) {
        this.union(other);
    }

    public void andNot(BitSet other) {
        this.remove(other);
    }

    public boolean intersects(BitSet other) {
        int pos = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        while (--pos >= 0) {
            if ((thisArr[pos] & otherArr[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacityWords(int numWords) {
        if (this.bits.length < numWords) {
            this.bits = BitSet.grow(this.bits, numWords);
        }
    }

    public static long[] grow(long[] array, int minSize) {
        if (array.length < minSize) {
            long[] newArray = new long[BitSet.getNextSize(minSize)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static int getNextSize(int targetSize) {
        return (targetSize >> 3) + (targetSize < 9 ? 3 : 6) + targetSize;
    }

    public void ensureCapacity(long numBits) {
        this.ensureCapacityWords(BitSet.bits2words(numBits));
    }

    public void trimTrailingZeros() {
        int idx;
        for (idx = this.wlen - 1; idx >= 0 && this.bits[idx] == 0L; --idx) {
        }
        this.wlen = idx + 1;
    }

    public static int bits2words(long numBits) {
        return (int)((numBits - 1L >>> 6) + 1L);
    }

    public boolean equals(Object o) {
        int i2;
        BitSet a2;
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitSet)) {
            return false;
        }
        BitSet b2 = (BitSet)o;
        if (b2.wlen > this.wlen) {
            a2 = b2;
            b2 = this;
        } else {
            a2 = this;
        }
        for (i2 = a2.wlen - 1; i2 >= b2.wlen; --i2) {
            if (a2.bits[i2] == 0L) continue;
            return false;
        }
        for (i2 = b2.wlen - 1; i2 >= 0; --i2) {
            if (a2.bits[i2] == b2.bits[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long h = 0L;
        int i2 = this.bits.length;
        while (--i2 >= 0) {
            h ^= this.bits[i2];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    public String toString() {
        long bit = this.nextSetBit(0);
        if (bit < 0L) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(Long.toString(bit));
        while ((bit = this.nextSetBit(bit + 1L)) >= 0L) {
            builder.append(", ");
            builder.append(Long.toString(bit));
        }
        builder.append("}");
        return builder.toString();
    }

    public IntLookupContainer asIntLookupContainer() {
        return new IntLookupContainer(){

            @Override
            public int size() {
                return this.getCurrentCardinality();
            }

            @Override
            public boolean isEmpty() {
                return BitSet.this.isEmpty();
            }

            @Override
            public Iterator<IntCursor> iterator() {
                return new Iterator<IntCursor>(){
                    private long nextBitSet;
                    private final IntCursor cursor;
                    {
                        this.nextBitSet = BitSet.this.nextSetBit(0);
                        this.cursor = new IntCursor();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextBitSet >= 0L;
                    }

                    @Override
                    public IntCursor next() {
                        long value = this.nextBitSet;
                        if (value < 0L) {
                            throw new NoSuchElementException();
                        }
                        if (value > Integer.MAX_VALUE) {
                            throw new RuntimeException("BitSet range larger than maximum positive integer.");
                        }
                        this.nextBitSet = BitSet.this.nextSetBit(value + 1L);
                        this.cursor.index = this.cursor.value = (int)value;
                        return this.cursor;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int[] toArray() {
                int[] data = new int[this.getCurrentCardinality()];
                BitSetIterator i2 = BitSet.this.iterator();
                int j = 0;
                int bit = i2.nextSetBit();
                while (bit >= 0) {
                    data[j++] = bit;
                    bit = i2.nextSetBit();
                }
                return data;
            }

            @Override
            public <T extends IntPredicate> T forEach(T predicate) {
                BitSetIterator i2 = BitSet.this.iterator();
                int bit = i2.nextSetBit();
                while (bit >= 0 && predicate.apply(bit)) {
                    bit = i2.nextSetBit();
                }
                return predicate;
            }

            @Override
            public <T extends IntProcedure> T forEach(T procedure) {
                BitSetIterator i2 = BitSet.this.iterator();
                int bit = i2.nextSetBit();
                while (bit >= 0) {
                    procedure.apply(bit);
                    bit = i2.nextSetBit();
                }
                return procedure;
            }

            @Override
            public boolean contains(int index) {
                return index < 0 || BitSet.this.get(index);
            }

            private int getCurrentCardinality() {
                long cardinality = BitSet.this.cardinality();
                if (cardinality > Integer.MAX_VALUE) {
                    throw new RuntimeException("Bitset is larger than maximum positive integer: " + cardinality);
                }
                return (int)cardinality;
            }
        };
    }

    public LongLookupContainer asLongLookupContainer() {
        return new LongLookupContainer(){

            @Override
            public int size() {
                return this.getCurrentCardinality();
            }

            @Override
            public boolean isEmpty() {
                return BitSet.this.isEmpty();
            }

            @Override
            public Iterator<LongCursor> iterator() {
                return new Iterator<LongCursor>(){
                    private long nextBitSet;
                    private final LongCursor cursor;
                    {
                        this.nextBitSet = BitSet.this.nextSetBit(0);
                        this.cursor = new LongCursor();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextBitSet >= 0L;
                    }

                    @Override
                    public LongCursor next() {
                        long value = this.nextBitSet;
                        if (value < 0L) {
                            throw new NoSuchElementException();
                        }
                        this.nextBitSet = BitSet.this.nextSetBit(value + 1L);
                        this.cursor.index = (int)value;
                        this.cursor.value = value;
                        return this.cursor;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public long[] toArray() {
                long[] data = new long[this.getCurrentCardinality()];
                BitSet bset = BitSet.this;
                int j = 0;
                long bit = bset.nextSetBit(0L);
                while (bit >= 0L) {
                    data[j++] = bit;
                    bit = bset.nextSetBit(bit + 1L);
                }
                return data;
            }

            @Override
            public <T extends LongPredicate> T forEach(T predicate) {
                BitSet bset = BitSet.this;
                long bit = bset.nextSetBit(0L);
                while (bit >= 0L && predicate.apply(bit)) {
                    bit = bset.nextSetBit(bit + 1L);
                }
                return predicate;
            }

            @Override
            public <T extends LongProcedure> T forEach(T procedure) {
                BitSet bset = BitSet.this;
                long bit = bset.nextSetBit(0L);
                while (bit >= 0L) {
                    procedure.apply(bit);
                    bit = bset.nextSetBit(bit + 1L);
                }
                return procedure;
            }

            @Override
            public boolean contains(long index) {
                return index < 0L || BitSet.this.get(index);
            }

            private int getCurrentCardinality() {
                long cardinality = BitSet.this.cardinality();
                if (cardinality > Integer.MAX_VALUE) {
                    throw new RuntimeException("Bitset is larger than maximum positive integer: " + cardinality);
                }
                return (int)cardinality;
            }
        };
    }
}

