/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.builders;

import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntStack;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.FSAHeader;
import morfologik.fsa.StateVisitor;
import morfologik.fsa.builders.FSASerializer;
import morfologik.fsa.builders.FSAUtils;

public final class CFSA2Serializer
implements FSASerializer {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final EnumSet<FSAFlags> flags = EnumSet.of(FSAFlags.NUMBERS, FSAFlags.FLEXIBLE, FSAFlags.STOPBIT, FSAFlags.NEXTBIT);
    private static final int NO_STATE = -1;
    private boolean withNumbers;
    private IntIntHashMap offsets = new IntIntHashMap();
    private IntIntHashMap numbers = new IntIntHashMap();
    private final byte[] scratch = new byte[5];
    private byte[] labelsIndex;
    private int[] labelsInvIndex;

    @Override
    public CFSA2Serializer withNumbers() {
        this.withNumbers = true;
        return this;
    }

    @Override
    public <T extends OutputStream> T serialize(FSA fsa, T os) throws IOException {
        this.computeLabelsIndex(fsa);
        if (this.withNumbers) {
            this.numbers = FSAUtils.rightLanguageForAllStates(fsa);
        }
        IntArrayList linearized = this.linearize(fsa);
        FSAHeader.write(os, (byte)-58);
        EnumSet<FSAFlags> fsaFlags = EnumSet.of(FSAFlags.FLEXIBLE, FSAFlags.STOPBIT, FSAFlags.NEXTBIT);
        if (this.withNumbers) {
            fsaFlags.add(FSAFlags.NUMBERS);
        }
        short sflags = FSAFlags.asShort(fsaFlags);
        os.write(sflags >> 8 & 0xFF);
        os.write(sflags & 0xFF);
        os.write(this.labelsIndex.length);
        os.write(this.labelsIndex);
        int size = this.emitNodes(fsa, os, linearized);
        assert (size == 0) : "Size changed in the final pass?";
        return os;
    }

    private void computeLabelsIndex(final FSA fsa) {
        final int[] countByValue = new int[256];
        fsa.visitAllStates(new StateVisitor(){

            @Override
            public boolean accept(int state) {
                int arc = fsa.getFirstArc(state);
                while (arc != 0) {
                    int n = fsa.getArcLabel(arc) & 0xFF;
                    countByValue[n] = countByValue[n] + 1;
                    arc = fsa.getNextArc(arc);
                }
                return true;
            }
        });
        Comparator<FSAUtils.IntIntHolder> comparator = new Comparator<FSAUtils.IntIntHolder>(){

            @Override
            public int compare(FSAUtils.IntIntHolder o1, FSAUtils.IntIntHolder o2) {
                int countDiff = o2.b - o1.b;
                if (countDiff == 0) {
                    countDiff = o1.a - o2.a;
                }
                return countDiff;
            }
        };
        TreeSet<FSAUtils.IntIntHolder> labelAndCount = new TreeSet<FSAUtils.IntIntHolder>(comparator);
        for (int label2 = 0; label2 < countByValue.length; ++label2) {
            if (countByValue[label2] <= 0) continue;
            labelAndCount.add(new FSAUtils.IntIntHolder(label2, countByValue[label2]));
        }
        this.labelsIndex = new byte[1 + Math.min(labelAndCount.size(), 31)];
        this.labelsInvIndex = new int[256];
        for (int i2 = this.labelsIndex.length - 1; i2 > 0 && !labelAndCount.isEmpty(); --i2) {
            FSAUtils.IntIntHolder p2 = labelAndCount.first();
            labelAndCount.remove(p2);
            this.labelsInvIndex[p2.a] = i2;
            this.labelsIndex[i2] = (byte)p2.a;
        }
    }

    @Override
    public Set<FSAFlags> getFlags() {
        return flags;
    }

    private IntArrayList linearize(FSA fsa) throws IOException {
        IntIntHashMap inlinkCount = this.computeInlinkCount(fsa);
        IntArrayList linearized = new IntArrayList(0, new BoundedProportionalArraySizingStrategy(1000, 10000, 1.5f));
        int maxStates = Integer.MAX_VALUE;
        int minInlinkCount = 2;
        int[] states = this.computeFirstStates(inlinkCount, maxStates, minInlinkCount);
        int serializedSize = this.linearizeAndCalculateOffsets(fsa, new IntArrayList(), linearized, this.offsets);
        IntArrayList sublist = new IntArrayList();
        sublist.buffer = states;
        sublist.elementsCount = states.length;
        this.log(Level.FINE, "Compacting, initial output size: %,d", serializedSize);
        int cutAt = 0;
        for (int cut = Math.min(25, states.length); cut <= Math.min(150, states.length); cut += 25) {
            sublist.elementsCount = cut;
            int newSize = this.linearizeAndCalculateOffsets(fsa, sublist, linearized, this.offsets);
            this.log(Level.FINE, "Moved %,d states, output size: %,d", sublist.size(), newSize);
            if (newSize >= serializedSize) break;
            cutAt = cut;
        }
        sublist.elementsCount = cutAt;
        int size = this.linearizeAndCalculateOffsets(fsa, sublist, linearized, this.offsets);
        this.log(Level.FINE, "%,d states moved, final size: %,d", sublist.size(), size);
        return linearized;
    }

    private void log(Level level, String msg, Object ... args) {
        this.logger.log(level, String.format(Locale.ROOT, msg, args));
    }

    private int linearizeAndCalculateOffsets(FSA fsa, IntArrayList states, IntArrayList linearized, IntIntHashMap offsets) throws IOException {
        int i2;
        BitSet visited = new BitSet();
        IntStack nodes = new IntStack();
        linearized.clear();
        for (int i3 = 0; i3 < states.size(); ++i3) {
            this.linearizeState(fsa, nodes, linearized, visited, states.get(i3));
        }
        nodes.push(fsa.getRootNode());
        while (!nodes.isEmpty()) {
            int node = nodes.pop();
            if (visited.get(node)) continue;
            this.linearizeState(fsa, nodes, linearized, visited, node);
        }
        int MAX_OFFSET = Integer.MAX_VALUE;
        for (IntCursor c : linearized) {
            offsets.put(c.value, MAX_OFFSET);
        }
        int j = 0;
        while ((i2 = this.emitNodes(fsa, null, linearized)) > 0) {
            j = i2;
        }
        return j;
    }

    private void linearizeState(FSA fsa, IntStack nodes, IntArrayList linearized, BitSet visited, int node) {
        linearized.add(node);
        visited.set(node);
        int arc = fsa.getFirstArc(node);
        while (arc != 0) {
            int target;
            if (!fsa.isArcTerminal(arc) && !visited.get(target = fsa.getEndNode(arc))) {
                nodes.push(target);
            }
            arc = fsa.getNextArc(arc);
        }
    }

    private int[] computeFirstStates(IntIntHashMap inlinkCount, int maxStates, int minInlinkCount) {
        Comparator<FSAUtils.IntIntHolder> comparator = new Comparator<FSAUtils.IntIntHolder>(){

            @Override
            public int compare(FSAUtils.IntIntHolder o1, FSAUtils.IntIntHolder o2) {
                int v = o1.a - o2.a;
                return v == 0 ? o1.b - o2.b : v;
            }
        };
        PriorityQueue<FSAUtils.IntIntHolder> stateInlink = new PriorityQueue<FSAUtils.IntIntHolder>(1, comparator);
        FSAUtils.IntIntHolder scratch = new FSAUtils.IntIntHolder();
        for (IntIntCursor c : inlinkCount) {
            if (c.value <= minInlinkCount) continue;
            scratch.a = c.value;
            scratch.b = c.key;
            if (stateInlink.size() >= maxStates && comparator.compare(scratch, stateInlink.peek()) <= 0) continue;
            stateInlink.add(new FSAUtils.IntIntHolder(c.value, c.key));
            if (stateInlink.size() <= maxStates) continue;
            stateInlink.remove();
        }
        int[] states = new int[stateInlink.size()];
        int position = states.length;
        while (!stateInlink.isEmpty()) {
            FSAUtils.IntIntHolder i2 = (FSAUtils.IntIntHolder)stateInlink.remove();
            states[--position] = i2.b;
        }
        return states;
    }

    private IntIntHashMap computeInlinkCount(FSA fsa) {
        IntIntHashMap inlinkCount = new IntIntHashMap();
        BitSet visited = new BitSet();
        IntStack nodes = new IntStack();
        nodes.push(fsa.getRootNode());
        while (!nodes.isEmpty()) {
            int node = nodes.pop();
            if (visited.get(node)) continue;
            visited.set(node);
            int arc = fsa.getFirstArc(node);
            while (arc != 0) {
                if (!fsa.isArcTerminal(arc)) {
                    int target = fsa.getEndNode(arc);
                    inlinkCount.putOrAdd(target, 1, 1);
                    if (!visited.get(target)) {
                        nodes.push(target);
                    }
                }
                arc = fsa.getNextArc(arc);
            }
        }
        return inlinkCount;
    }

    private int emitNodes(FSA fsa, OutputStream os, IntArrayList linearized) throws IOException {
        int offset = 0;
        offset += this.emitNodeData(os, 0);
        offset = fsa.getRootNode() != 0 ? (offset += this.emitArc(os, 64, (byte)94, this.offsets.get(fsa.getRootNode()))) : (offset += this.emitArc(os, 64, (byte)94, 0));
        boolean offsetsChanged = false;
        int max = linearized.size();
        for (IntCursor c : linearized) {
            int nextState;
            int state = c.value;
            int n = nextState = c.index + 1 < max ? linearized.get(c.index + 1) : -1;
            if (os == null) {
                offsetsChanged |= this.offsets.get(state) != offset;
                this.offsets.put(state, offset);
            } else assert (this.offsets.get(state) == offset) : state + " " + this.offsets.get(state) + " " + offset;
            offset += this.emitNodeData(os, this.withNumbers ? this.numbers.get(state) : 0);
            offset += this.emitNodeArcs(fsa, os, state, nextState);
        }
        return offsetsChanged ? offset : 0;
    }

    private int emitNodeArcs(FSA fsa, OutputStream os, int state, int nextState) throws IOException {
        int offset = 0;
        int arc = fsa.getFirstArc(state);
        while (arc != 0) {
            int targetOffset;
            int target;
            if (fsa.isArcTerminal(arc)) {
                target = 0;
                targetOffset = 0;
            } else {
                target = fsa.getEndNode(arc);
                targetOffset = this.offsets.get(target);
            }
            int flags = 0;
            if (fsa.isArcFinal(arc)) {
                flags |= 0x20;
            }
            if (fsa.getNextArc(arc) == 0) {
                flags |= 0x40;
            }
            if (targetOffset != 0 && target == nextState) {
                flags |= 0x80;
                targetOffset = 0;
            }
            offset += this.emitArc(os, flags, fsa.getArcLabel(arc), targetOffset);
            arc = fsa.getNextArc(arc);
        }
        return offset;
    }

    private int emitArc(OutputStream os, int flags, byte label2, int targetOffset) throws IOException {
        int length = 0;
        int labelIndex = this.labelsInvIndex[label2 & 0xFF];
        if (labelIndex > 0) {
            if (os != null) {
                os.write(flags | labelIndex);
            }
            ++length;
        } else {
            if (os != null) {
                os.write(flags);
                os.write(label2);
            }
            length += 2;
        }
        if ((flags & 0x80) == 0) {
            int len = CFSA2Serializer.writeVInt(this.scratch, 0, targetOffset);
            if (os != null) {
                os.write(this.scratch, 0, len);
            }
            length += len;
        }
        return length;
    }

    private int emitNodeData(OutputStream os, int number) throws IOException {
        int size = 0;
        if (this.withNumbers) {
            size = CFSA2Serializer.writeVInt(this.scratch, 0, number);
            if (os != null) {
                os.write(this.scratch, 0, size);
            }
        }
        return size;
    }

    @Override
    public CFSA2Serializer withFiller(byte filler) {
        throw new UnsupportedOperationException("CFSA2 does not support filler. Use .info file.");
    }

    @Override
    public CFSA2Serializer withAnnotationSeparator(byte annotationSeparator) {
        throw new UnsupportedOperationException("CFSA2 does not support separator. Use .info file.");
    }

    static int writeVInt(byte[] array, int offset, int value) {
        assert (value >= 0) : "Can't v-code negative ints.";
        while (value > 127) {
            array[offset++] = (byte)(0x80 | value & 0x7F);
            value >>= 7;
        }
        array[offset++] = (byte)value;
        return offset;
    }
}

