/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tools.MostlySingularMultiMap;
import org.languagetool.tools.StringTools;

public class ManualTagger
implements WordTagger {
    private final MostlySingularMultiMap<String, TaggedWord> mapping;

    public ManualTagger(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public ManualTagger(InputStream inputStream, boolean internTags) throws IOException {
        this.mapping = new MostlySingularMultiMap<String, TaggedWord>(ManualTagger.loadMapping(inputStream, internTags));
    }

    private static Map<String, List<TaggedWord>> loadMapping(InputStream inputStream, boolean internTags) throws IOException {
        HashMap<String, List<TaggedWord>> map2 = new HashMap<String, List<TaggedWord>>();
        HashMap interned = new HashMap();
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader br2 = new BufferedReader(reader);){
            String line;
            while ((line = br2.readLine()) != null) {
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                if (line.contains("\u00a0")) {
                    throw new RuntimeException("Non-breaking space found in line '" + line + "', please remove it");
                }
                String[] parts = (line = StringUtils.substringBefore((String)line, (String)"#").trim()).split("\t");
                if (parts.length != 3) {
                    throw new IOException("Unknown line format when loading manual tagger dictionary, expected three tab-separated fields: '" + line + "'");
                }
                String lemma = parts[1];
                String form2 = parts[0];
                if (lemma.equals(form2)) {
                    lemma = form2;
                }
                lemma = (String)interned.computeIfAbsent(lemma, Function.identity());
                String tag = parts[2].trim();
                String internedTag = internTags ? tag.intern() : (String)interned.computeIfAbsent(tag, Function.identity());
                map2.computeIfAbsent(form2, __ -> new ArrayList()).add(new TaggedWord(lemma, internedTag));
            }
        }
        return map2;
    }

    @Override
    public List<TaggedWord> tag(String word) {
        List<TaggedWord> lookedUpTerms = this.mapping.getList(word);
        if (lookedUpTerms != null) {
            return Collections.unmodifiableList(lookedUpTerms);
        }
        return Collections.emptyList();
    }
}

