/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.NumberQuantity;

final class FloatQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = 5992028803791009345L;
    final float value;

    public FloatQuantity(float value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? (double)this.value : super.getUnit().getConverterTo(unit).convert(this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result2 = this.doubleValue(unit);
        if (result2 < -9.223372036854776E18 || result2 > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result2 + ")");
        }
        return (long)result2;
    }

    private ComparableQuantity<Q> addRaw(Number a2, Number b2, Unit<Q> unit) {
        return NumberQuantity.of(a2.floatValue() + b2.floatValue(), unit);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        Quantity<Q> thatConverted = that.to(this.getUnit());
        Quantity thisConverted = this.to((Unit)that.getUnit());
        float resultValueInThisUnit = this.getValue().floatValue() + thatConverted.getValue().floatValue();
        float resultValueInThatUnit = thisConverted.getValue().floatValue() + that.getValue().floatValue();
        ComparableQuantity resultInThisUnit = this.addRaw(this.getValue(), thatConverted.getValue(), this.getUnit());
        ComparableQuantity<Q> resultInThatUnit = this.addRaw(thisConverted.getValue(), that.getValue(), that.getUnit());
        if (Float.isInfinite(resultValueInThisUnit) && Float.isInfinite(resultValueInThatUnit)) {
            throw new ArithmeticException();
        }
        if (Float.isInfinite(resultValueInThisUnit)) {
            return resultInThatUnit;
        }
        return resultInThisUnit;
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        AbstractQuantity<Q> thatNegated = NumberQuantity.of(-that.getValue().floatValue(), that.getUnit());
        return this.add((Quantity)thatNegated);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new FloatQuantity(this.value * that.getValue().floatValue(), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * that.floatValue(), this.getUnit().multiply(that.doubleValue()));
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return new FloatQuantity(this.value / that.getValue().floatValue(), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return NumberQuantity.of(1.0f / this.value, this.getUnit().inverse());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return NumberQuantity.of(this.value / that.floatValue(), this.getUnit());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(Float.valueOf(this.value), that.getValue());
        }
        return false;
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit) throws ArithmeticException {
        return BigDecimal.valueOf(this.value);
    }
}

