/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.expression;

import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.ExpressionVisitor;
import java.util.StringTokenizer;

public class FieldRef
implements AnnotationValue {
    private final int[] parts;
    private final String name;
    private JavaClass declaringClass;
    private ClassLibrary classLibrary;
    private JavaField field;
    private int fieldIndex = -1;

    public FieldRef(String name) {
        this.name = name;
        int length = new StringTokenizer(name, ".").countTokens();
        this.parts = new int[length + 1];
        this.parts[0] = -1;
        for (int i = 1; i < length; ++i) {
            this.parts[i] = name.indexOf(46, this.parts[i - 1] + 1);
        }
        this.parts[length] = name.length();
    }

    public String getName() {
        return this.name;
    }

    public String getNamePrefix(int end) {
        return this.name.substring(0, this.parts[end + 1]);
    }

    public String getNamePart(int index) {
        return this.name.substring(this.parts[index] + 1, this.parts[index + 1]);
    }

    public int getPartCount() {
        return this.parts.length - 1;
    }

    @Override
    public Object accept(ExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getParameterValue() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public void setDeclaringClass(JavaClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public String getClassPart() {
        String result = null;
        if (this.getField() != null) {
            result = this.name.substring(0, this.parts[this.fieldIndex]);
        }
        return result;
    }

    public String getFieldPart() {
        String result = null;
        if (this.getField() != null) {
            result = this.name.substring(this.parts[this.fieldIndex] + 1);
        }
        return result;
    }

    protected JavaField resolveField(JavaClass javaClass, int start, int end) {
        JavaField field = null;
        for (int i = start; i < end && (field = javaClass.getFieldByName(this.getNamePart(i))) != null; ++i) {
        }
        return field;
    }

    public JavaField getField() {
        if (this.fieldIndex < 0) {
            ClassLibrary classLibrary;
            JavaClass declaringClass = this.getDeclaringClass();
            if (declaringClass != null) {
                this.field = this.resolveField(declaringClass, 0, this.parts.length - 1);
                this.fieldIndex = 0;
            }
            if (this.field == null && (classLibrary = this.getClassLibrary()) != null) {
                for (int i = 0; i < this.parts.length - 1; ++i) {
                    String className = this.getNamePrefix(i);
                    if (!classLibrary.hasClassReference(className)) continue;
                    JavaClass javaClass = classLibrary.getJavaClass(className);
                    this.fieldIndex = i + 1;
                    this.field = this.resolveField(javaClass, i + 1, this.parts.length - 1);
                    break;
                }
            }
        }
        return this.field;
    }

    private JavaClass getDeclaringClass() {
        return this.declaringClass;
    }

    private ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }
}

