/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.lang.properties.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleWrapperImplicitPropertyUsageProvider;", "Lcom/intellij/lang/properties/codeInspection/unused/ImplicitPropertyUsageProvider;", "()V", "isUsed", "", "property", "Lcom/intellij/lang/properties/psi/Property;", "nameEqual", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "name", "", "intellij.gradle.common"})
public final class GradleWrapperImplicitPropertyUsageProvider
implements ImplicitPropertyUsageProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUsed(@NotNull Property property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        GradleSettings gradleSettings = GradleSettings.getInstance(property.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(property.project)");
        if (gradleSettings.getLinkedProjectsSettings().isEmpty()) {
            return false;
        }
        PsiFile psiFile = property.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"property.containingFile");
        VirtualFile file = psiFile.getVirtualFile();
        if (!this.nameEqual(file, "gradle-wrapper.properties")) return false;
        VirtualFile virtualFile = file;
        if (!this.nameEqual((VirtualFile)(virtualFile != null ? virtualFile.getParent() : null), "wrapper")) return false;
        VirtualFile virtualFile2 = file;
        if (!this.nameEqual(virtualFile2 != null && (virtualFile2 = virtualFile2.getParent()) != null ? virtualFile2.getParent() : null, "gradle")) return false;
        return true;
    }

    private final boolean nameEqual(VirtualFile file, String name) {
        if (file == null) {
            return false;
        }
        return Comparing.equal((String)file.getName(), (String)name, (boolean)file.isCaseSensitive());
    }
}

