/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J0\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\bH$J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J)\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findColumnIndex", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "findTable", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;", "findTableAndIndex", "Lkotlin/Pair;", "performAction", "table", "columnIndex", "update", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;Ljava/lang/Integer;)V", "Companion", "intellij.markdown"})
public abstract class ColumnBasedTableAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        void table;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getRequiredData(CommonDataKeys.EDITOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.getRequiredData(CommonDataKeys.EDITOR)");
        Editor editor2 = (Editor)object;
        Object object2 = event.getRequiredData(CommonDataKeys.PSI_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"event.getRequiredData(CommonDataKeys.PSI_FILE)");
        PsiFile file = (PsiFile)object2;
        Pair<MarkdownTableImpl, Integer> pair = this.findTableAndIndex(event, file, editor2);
        MarkdownTableImpl markdownTableImpl = (MarkdownTableImpl)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (table == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (columnIndex == null) {
            boolean bl5 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.performAction(editor2, (MarkdownTableImpl)table, columnIndex);
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent event) {
        void table;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (project == null || editor2 == null || file == null) {
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Pair<MarkdownTableImpl, Integer> pair = this.findTableAndIndex(event, file, editor2);
        MarkdownTableImpl markdownTableImpl = (MarkdownTableImpl)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        presentation.setEnabledAndVisible(table != null && columnIndex != null);
        this.update(event, (MarkdownTableImpl)table, columnIndex);
    }

    protected abstract void performAction(@NotNull Editor var1, @NotNull MarkdownTableImpl var2, int var3);

    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTableImpl table, @Nullable Integer columnIndex) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    private final Pair<MarkdownTableImpl, Integer> findTableAndIndex(AnActionEvent event, PsiFile file, Editor editor2) {
        return Companion.findTableAndIndex(event, file, editor2, (Function2<? super PsiFile, ? super Editor, ? extends MarkdownTableImpl>)((Function2)new Function2<PsiFile, Editor, MarkdownTableImpl>(this){

            @Nullable
            public final MarkdownTableImpl invoke(@NotNull PsiFile p1, @NotNull Editor p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((ColumnBasedTableAction)((Object)this.receiver)).findTable(p1, p2);
            }
        }), (Function2<? super PsiFile, ? super Editor, Integer>)((Function2)new Function2<PsiFile, Editor, Integer>(this){

            @Nullable
            public final Integer invoke(@NotNull PsiFile p1, @NotNull Editor p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((ColumnBasedTableAction)((Object)this.receiver)).findColumnIndex(p1, p2);
            }
        }));
    }

    @Nullable
    protected MarkdownTableImpl findTable(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        return TableUtils.findTable(file, caret.getOffset());
    }

    @Nullable
    protected Integer findColumnIndex(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        return TableUtils.findCellIndex(file, caret.getOffset());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJf\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000e2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000e\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction$Companion;", "", "()V", "findTableAndIndex", "Lkotlin/Pair;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tableGetter", "Lkotlin/Function2;", "columnIndexGetter", "intellij.markdown"})
    public static final class Companion {
        @NotNull
        public final Pair<MarkdownTableImpl, Integer> findTableAndIndex(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Editor editor2, @NotNull Function2<? super PsiFile, ? super Editor, ? extends MarkdownTableImpl> tableGetter, @NotNull Function2<? super PsiFile, ? super Editor, Integer> columnIndexGetter) {
            MarkdownTableImpl markdownTableImpl;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(tableGetter, (String)"tableGetter");
            Intrinsics.checkNotNullParameter(columnIndexGetter, (String)"columnIndexGetter");
            WeakReference weakReference = (WeakReference)event.getData(TableActionKeys.INSTANCE.getELEMENT());
            Object object = weakReference != null ? (PsiElement)weakReference.get() : null;
            if (!(object instanceof MarkdownTableImpl)) {
                object = null;
            }
            MarkdownTableImpl tableFromEvent = (MarkdownTableImpl)object;
            Integer indexFromEvent = (Integer)event.getData(TableActionKeys.INSTANCE.getCOLUMN_INDEX());
            if (tableFromEvent != null && indexFromEvent != null) {
                return TuplesKt.to((Object)tableFromEvent, (Object)indexFromEvent);
            }
            MarkdownTableImpl markdownTableImpl2 = (MarkdownTableImpl)tableGetter.invoke((Object)file, (Object)editor2);
            if (markdownTableImpl2 != null) {
                MarkdownTableImpl markdownTableImpl3 = markdownTableImpl2;
                boolean bl = false;
                boolean bl2 = false;
                MarkdownTableImpl it = markdownTableImpl3;
                boolean bl3 = false;
                markdownTableImpl = it.isValid() ? markdownTableImpl3 : null;
            } else {
                markdownTableImpl = null;
            }
            MarkdownTableImpl table = markdownTableImpl;
            Integer index = (Integer)columnIndexGetter.invoke((Object)file, (Object)editor2);
            return TuplesKt.to(table, (Object)index);
        }

        @NotNull
        public final Pair<MarkdownTableImpl, Integer> findTableAndIndex(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.findTableAndIndex(event, file, editor2, (Function2<? super PsiFile, ? super Editor, ? extends MarkdownTableImpl>)((Function2)findTableAndIndex.1.INSTANCE), (Function2<? super PsiFile, ? super Editor, Integer>)((Function2)findTableAndIndex.2.INSTANCE));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

