/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.editor.tables.actions.column.InsertTableColumnAction$performAction$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0014J)\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0014\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction;", "insertAfter", "", "(Z)V", "findColumnIndex", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "performAction", "", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;", "columnIndex", "update", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableImpl;Ljava/lang/Integer;)V", "InsertAfter", "InsertBefore", "intellij.markdown"})
public abstract class InsertTableColumnAction
extends ColumnBasedTableAction {
    private final boolean insertAfter;

    @Override
    protected void performAction(@NotNull Editor editor2, @NotNull MarkdownTableImpl table, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(this, table, editor2, columnIndex){
            final /* synthetic */ InsertTableColumnAction this$0;
            final /* synthetic */ MarkdownTableImpl $table$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ int $columnIndex$inlined;
            {
                this.this$0 = insertTableColumnAction;
                this.$table$inlined = markdownTableImpl;
                this.$editor$inlined = editor2;
                this.$columnIndex$inlined = n;
            }

            public final T compute() {
                boolean bl = false;
                Project project$iv = this.$table$inlined.getProject();
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
                    final /* synthetic */ performAction$$inlined$runWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        boolean bl = false;
                        MarkdownTableImpl markdownTableImpl = this.this$0.$table$inlined;
                        Document document = this.this$0.$editor$inlined.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                        TableModificationUtils.insertColumn$default(TableModificationUtils.INSTANCE, markdownTableImpl, document, this.this$0.$columnIndex$inlined, InsertTableColumnAction.access$getInsertAfter$p(this.this$0.this$0), null, 0, 24, null);
                    }
                }, name$iv, (Object)groupId$iv);
                return (T)Unit.INSTANCE;
            }
        });
    }

    @Override
    @Nullable
    protected Integer findColumnIndex(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        int caretOffset = caret.getOffset();
        Integer cellIndex = TableUtils.findCellIndex(file, caretOffset);
        if (cellIndex != null) {
            return cellIndex;
        }
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.findSeparatorRow(file, caretOffset);
        return markdownTableSeparatorRow != null ? markdownTableSeparatorRow.getColumnIndexFromOffset(caretOffset) : null;
    }

    @Override
    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTableImpl table, @Nullable Integer columnIndex) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event, table, columnIndex);
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        MarkdownTableImpl markdownTableImpl = table;
        presentation.setEnabledAndVisible(markdownTableImpl != null && TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTableImpl));
    }

    public InsertTableColumnAction(boolean insertAfter) {
        this.insertAfter = insertAfter;
    }

    public /* synthetic */ InsertTableColumnAction(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public InsertTableColumnAction() {
        this(false, 1, null);
    }

    public static final /* synthetic */ boolean access$getInsertAfter$p(InsertTableColumnAction $this) {
        return $this.insertAfter;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction$InsertBefore;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction;", "()V", "intellij.markdown"})
    public static final class InsertBefore
    extends InsertTableColumnAction {
        public InsertBefore() {
            super(false);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction$InsertAfter;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/InsertTableColumnAction;", "()V", "intellij.markdown"})
    public static final class InsertAfter
    extends InsertTableColumnAction {
        public InsertAfter() {
            super(true);
        }
    }
}

