/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.authorization;

import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.PkceUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.DigestUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthCredentialsAcquirer;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.intellij.plugins.markdown.google.utils.GoogleCredentialUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "googleAppCred", "Lorg/intellij/plugins/markdown/google/utils/GoogleCredentialUtils$GoogleAppCredentials;", "(Lorg/intellij/plugins/markdown/google/utils/GoogleCredentialUtils$GoogleAppCredentials;)V", "authUrlWithParameters", "Lcom/intellij/util/Url;", "getAuthUrlWithParameters", "()Lcom/intellij/util/Url;", "authorizationCodeUrl", "getAuthorizationCodeUrl", "codeChallenge", "", "codeVerifier", "credentialsAcquirer", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "port", "", "getPort", "()I", "Companion", "intellij.markdown"})
public final class GoogleOAuthRequest
implements OAuthRequest<GoogleCredentials> {
    private final String codeVerifier;
    private final String codeChallenge;
    @NotNull
    private final OAuthCredentialsAcquirer<GoogleCredentials> credentialsAcquirer;
    @NotNull
    private final Url authUrlWithParameters;
    private static final String responseType = "code";
    private static final String codeChallengeMethod = "S256";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final int getPort() {
        return BuiltInServerManager.Companion.getInstance().getPort();
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        boolean $i$f$service = false;
        Class<GoogleOAuthService> serviceClass$iv = GoogleOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return Urls.newFromEncoded((String)("http://localhost:" + this.getPort() + "/api/" + ((GoogleOAuthService)((Object)object)).getName() + "/authorization_code"));
    }

    @NotNull
    public OAuthCredentialsAcquirer<GoogleCredentials> getCredentialsAcquirer() {
        return this.credentialsAcquirer;
    }

    @NotNull
    public Url getAuthUrlWithParameters() {
        return this.authUrlWithParameters;
    }

    public GoogleOAuthRequest(@NotNull GoogleCredentialUtils.GoogleAppCredentials googleAppCred) {
        Intrinsics.checkNotNullParameter((Object)googleAppCred, (String)"googleAppCred");
        this.codeVerifier = PkceUtils.INSTANCE.generateCodeVerifier();
        this.codeChallenge = PkceUtils.INSTANCE.generateShaCodeChallenge(this.codeVerifier, true);
        this.credentialsAcquirer = new GoogleOAuthCredentialsAcquirer(googleAppCred, this.getAuthorizationCodeUrl(), this.codeVerifier);
        Url url = GoogleOAuthRequest.Companion.getAUTHORIZE_URI().addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"scope", (Object)GoogleOAuthRequest.Companion.getScope()), TuplesKt.to((Object)"response_type", (Object)responseType), TuplesKt.to((Object)"code_challenge", (Object)this.codeChallenge), TuplesKt.to((Object)"code_challenge_method", (Object)codeChallengeMethod), TuplesKt.to((Object)"state", (Object)GoogleOAuthRequest.Companion.getState()), TuplesKt.to((Object)"client_id", (Object)googleAppCred.getClientId()), TuplesKt.to((Object)"redirect_uri", (Object)this.getAuthorizationCodeUrl().toExternalForm())}));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"AUTHORIZE_URI.addParamet\u2026Url.toExternalForm()\n  ))");
        this.authUrlWithParameters = url;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthRequest$Companion;", "", "()V", "AUTHORIZE_URI", "Lcom/intellij/util/Url;", "getAUTHORIZE_URI", "()Lcom/intellij/util/Url;", "codeChallengeMethod", "", "responseType", "scope", "getScope", "()Ljava/lang/String;", "state", "getState", "intellij.markdown"})
    public static final class Companion {
        private final String getScope() {
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{"https://www.googleapis.com/auth/drive.readonly", "https://www.googleapis.com/auth/userinfo.profile"}), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        private final Url getAUTHORIZE_URI() {
            return Urls.newFromEncoded((String)"https://accounts.google.com/o/oauth2/v2/auth");
        }

        private final String getState() {
            return DigestUtil.randomToken();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

