/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownNotifier;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/google/utils/GoogleCredentialUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createCredentialsForGoogleApi", "Lcom/google/api/client/auth/oauth2/Credential;", "credentials", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "getGoogleAppCredentials", "Lorg/intellij/plugins/markdown/google/utils/GoogleCredentialUtils$GoogleAppCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "getTokenResponse", "Lcom/google/api/client/auth/oauth2/TokenResponse;", "GoogleAppCredentials", "intellij.markdown"})
public final class GoogleCredentialUtils {
    private static final Logger LOG;
    @NotNull
    public static final GoogleCredentialUtils INSTANCE;

    @Nullable
    public final GoogleAppCredentials getGoogleAppCredentials(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String googleAppCredUrl = "https://www.jetbrains.com/config/markdown.json";
        try {
            JsonNode credentials = new ObjectMapper().readTree(new URL(googleAppCredUrl)).get("google").get("auth");
            String clientId = credentials.get("secret-id").asText();
            String clientSecret = credentials.get("client-secret").asText();
            String string = clientId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clientId");
            String string2 = clientSecret;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clientSecret");
            return new GoogleAppCredentials(string, string2);
        }
        catch (IOException e) {
            MarkdownNotifier.INSTANCE.notifyNetworkProblems(project);
            LOG.error("Can't get google app credentials from https://www.jetbrains.com/config/markdown.json", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final Credential createCredentialsForGoogleApi(@NotNull GoogleCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        TokenResponse tokenResponse = this.getTokenResponse(credentials);
        GoogleCredential googleCredential = new GoogleCredential().setFromTokenResponse(tokenResponse);
        Intrinsics.checkNotNullExpressionValue((Object)googleCredential, (String)"GoogleCredential().setFr\u2026enResponse(tokenResponse)");
        return googleCredential;
    }

    private final TokenResponse getTokenResponse(GoogleCredentials credentials) {
        TokenResponse tokenResponse = new TokenResponse();
        boolean bl = false;
        boolean bl2 = false;
        TokenResponse $this$apply = tokenResponse;
        boolean bl3 = false;
        $this$apply.setAccessToken(credentials.getAccessToken());
        $this$apply.setTokenType(credentials.getTokenType());
        $this$apply.setScope(credentials.getScope());
        $this$apply.setExpiresInSeconds(credentials.getExpiresIn());
        return tokenResponse;
    }

    private GoogleCredentialUtils() {
    }

    static {
        GoogleCredentialUtils googleCredentialUtils;
        INSTANCE = googleCredentialUtils = new GoogleCredentialUtils();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleOAuthService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/google/utils/GoogleCredentialUtils$GoogleAppCredentials;", "", "clientId", "", "clientSecret", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "getClientSecret", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown"})
    public static final class GoogleAppCredentials {
        @NotNull
        private final String clientId;
        @NotNull
        private final String clientSecret;

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        public GoogleAppCredentials(@NotNull String clientId, @NotNull String clientSecret) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final String component2() {
            return this.clientSecret;
        }

        @NotNull
        public final GoogleAppCredentials copy(@NotNull String clientId, @NotNull String clientSecret) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            return new GoogleAppCredentials(clientId, clientSecret);
        }

        public static /* synthetic */ GoogleAppCredentials copy$default(GoogleAppCredentials googleAppCredentials, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = googleAppCredentials.clientId;
            }
            if ((n & 2) != 0) {
                string2 = googleAppCredentials.clientSecret;
            }
            return googleAppCredentials.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "GoogleAppCredentials(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ")";
        }

        public int hashCode() {
            String string = this.clientId;
            String string2 = this.clientSecret;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GoogleAppCredentials)) break block3;
                    GoogleAppCredentials googleAppCredentials = (GoogleAppCredentials)object;
                    if (!Intrinsics.areEqual((Object)this.clientId, (Object)googleAppCredentials.clientId) || !Intrinsics.areEqual((Object)this.clientSecret, (Object)googleAppCredentials.clientSecret)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

