/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.SettingsAwareBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceUtils;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownBlocks;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownEditingAligner;
import org.intellij.plugins.markdown.util.ASTUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock;", "Lcom/intellij/psi/formatter/common/AbstractBlock;", "Lcom/intellij/psi/formatter/common/SettingsAwareBlock;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "alignment", "Lcom/intellij/formatting/Alignment;", "wrap", "Lcom/intellij/formatting/Wrap;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/formatting/SpacingBuilder;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Wrap;)V", "getSpacing", "()Lcom/intellij/formatting/SpacingBuilder;", "buildChildren", "", "Lcom/intellij/formatting/Block;", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getIndent", "Lcom/intellij/formatting/Indent;", "getSettings", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getSubBlocks", "isLeaf", "", "Companion", "intellij.markdown"})
public class MarkdownFormattingBlock
extends AbstractBlock
implements SettingsAwareBlock {
    private final CodeStyleSettings settings;
    @NotNull
    private final SpacingBuilder spacing;
    private static final TokenSet NON_ALIGNABLE_LIST_ELEMENTS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public CodeStyleSettings getSettings() {
        return this.settings;
    }

    public boolean isLeaf() {
        return this.getSubBlocks().isEmpty();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        return this.spacing.getSpacing((Block)this, child1, child2);
    }

    @Nullable
    public Indent getIndent() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        if (MarkdownTokenTypeSets.LISTS.contains(aSTNode.getElementType())) {
            boolean bl;
            block3: {
                ASTNode aSTNode2 = this.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node");
                Sequence<ASTNode> $this$any$iv = ASTUtilsKt.parents(aSTNode2);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)MarkdownElementTypes.LIST_ITEM)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return Indent.getNormalIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return MarkdownEditingAligner.INSTANCE.calculateChildAttributes((Block)CollectionsKt.getOrNull(this.getSubBlocks(), (int)(newChildIndex - 1)));
    }

    @NotNull
    public List<Block> getSubBlocks() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        if (MarkdownCodeFenceUtils.INSTANCE.isCodeFence(aSTNode)) {
            ASTNode aSTNode2 = this.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node");
            if (!MarkdownPsiUtil.INSTANCE.isTopLevel(aSTNode2)) {
                List list = AbstractBlock.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EMPTY");
                return list;
            }
        }
        List list = super.getSubBlocks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"super.getSubBlocks()");
        return list;
    }

    @NotNull
    protected List<Block> buildChildren() {
        List list;
        Alignment newAlignment = Alignment.createAlignment();
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
            list = CollectionsKt.emptyList();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
            ASTNode aSTNode2 = this.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node");
            list = SequencesKt.toList(MarkdownBlocks.INSTANCE.create(ASTUtilsKt.children(aSTNode2), this.settings, this.spacing, (Function1<? super ASTNode, ? extends Alignment>)((Function1)new Function1<ASTNode, Alignment>(this, newAlignment){
                final /* synthetic */ MarkdownFormattingBlock this$0;
                final /* synthetic */ Alignment $newAlignment;

                @Nullable
                public final Alignment invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return MarkdownFormattingBlock.access$getNON_ALIGNABLE_LIST_ELEMENTS$cp().contains(it.getElementType()) ? this.this$0.getAlignment() : this.$newAlignment;
                }
                {
                    this.this$0 = markdownFormattingBlock;
                    this.$newAlignment = alignment;
                    super(1);
                }
            })));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) {
            ASTNode aSTNode3 = this.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node");
            list = SequencesKt.toList(MarkdownBlocks.INSTANCE.create(ASTUtilsKt.children(aSTNode3), this.settings, this.spacing, (Function1<? super ASTNode, ? extends Alignment>)((Function1)new Function1<ASTNode, Alignment>(this, newAlignment){
                final /* synthetic */ MarkdownFormattingBlock this$0;
                final /* synthetic */ Alignment $newAlignment;

                @Nullable
                public final Alignment invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Alignment alignment = this.this$0.getAlignment();
                    if (alignment == null) {
                        alignment = this.$newAlignment;
                    }
                    return alignment;
                }
                {
                    this.this$0 = markdownFormattingBlock;
                    this.$newAlignment = alignment;
                    super(1);
                }
            })));
        } else {
            ASTNode aSTNode4 = this.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"node");
            list = SequencesKt.toList(MarkdownBlocks.INSTANCE.create(ASTUtilsKt.children(aSTNode4), this.settings, this.spacing, (Function1<? super ASTNode, ? extends Alignment>)((Function1)new Function1<ASTNode, Alignment>(this){
                final /* synthetic */ MarkdownFormattingBlock this$0;

                @Nullable
                public final Alignment invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getAlignment();
                }
                {
                    this.this$0 = markdownFormattingBlock;
                    super(1);
                }
            })));
        }
        return list;
    }

    @NotNull
    protected final SpacingBuilder getSpacing() {
        return this.spacing;
    }

    public MarkdownFormattingBlock(@NotNull ASTNode node, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        super(node, wrap, alignment);
        this.settings = settings;
        this.spacing = spacing;
    }

    public /* synthetic */ MarkdownFormattingBlock(ASTNode aSTNode, CodeStyleSettings codeStyleSettings, SpacingBuilder spacingBuilder, Alignment alignment, Wrap wrap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            alignment = null;
        }
        if ((n & 0x10) != 0) {
            wrap = null;
        }
        this(aSTNode, codeStyleSettings, spacingBuilder, alignment, wrap);
    }

    static {
        Companion = new Companion(null);
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{MarkdownTokenTypeSets.LIST_MARKERS, MarkdownTokenTypeSets.LISTS});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.orSet(MarkdownT\u2026kdownTokenTypeSets.LISTS)");
        NON_ALIGNABLE_LIST_ELEMENTS = tokenSet;
    }

    public static final /* synthetic */ TokenSet access$getNON_ALIGNABLE_LIST_ELEMENTS$cp() {
        return NON_ALIGNABLE_LIST_ELEMENTS;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock$Companion;", "", "()V", "NON_ALIGNABLE_LIST_ELEMENTS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

