/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.io.IOException;
import javax.annotation.Nullable;
import org.owasp.html.HtmlEntities;
import org.owasp.html.TCB;

public final class Encoding {
    private static final char[] HEX_NUMERAL;
    private static final String[] REPLACEMENTS;
    private static boolean[] IS_BANNED_ASCII;

    public static String decodeHtml(String s) {
        int safeLimit;
        int firstAmp = s.indexOf(38);
        if ((firstAmp & (safeLimit = Encoding.longestPrefixOfGoodCodeunits(s))) < 0) {
            return s;
        }
        int n = s.length();
        StringBuilder sb = new StringBuilder(n);
        int pos = 0;
        int amp = firstAmp;
        while (amp >= 0) {
            int end;
            sb.append(s, pos, amp);
            pos = end = HtmlEntities.appendDecodedEntity(s, amp, n, sb);
            amp = s.indexOf(38, end);
        }
        sb.append(s, pos, n);
        Encoding.stripBannedCodeunits(sb, firstAmp < 0 ? safeLimit : (safeLimit < 0 ? firstAmp : Math.min(firstAmp, safeLimit)));
        return sb.toString();
    }

    @TCB
    static String stripBannedCodeunits(String s) {
        int safeLimit = Encoding.longestPrefixOfGoodCodeunits(s);
        if (safeLimit < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        Encoding.stripBannedCodeunits(sb, safeLimit);
        return sb.toString();
    }

    @TCB
    static void stripBannedCodeunits(StringBuilder sb) {
        Encoding.stripBannedCodeunits(sb, 0);
    }

    @TCB
    private static void stripBannedCodeunits(StringBuilder sb, int start) {
        int k = start;
        int n = sb.length();
        for (int i2 = start; i2 < n; ++i2) {
            char ch = sb.charAt(i2);
            if (ch < ' ') {
                if (IS_BANNED_ASCII[ch]) {
                    continue;
                }
            } else if ('\ud800' <= ch) {
                if (ch <= '\udfff') {
                    char next;
                    if (i2 + 1 >= n || !Character.isSurrogatePair(ch, next = sb.charAt(i2 + 1))) continue;
                    sb.setCharAt(k++, ch);
                    sb.setCharAt(k++, next);
                    ++i2;
                    continue;
                }
                if ((ch & 0xFFFE) == 65534) continue;
            }
            sb.setCharAt(k++, ch);
        }
        sb.setLength(k);
    }

    @TCB
    private static int longestPrefixOfGoodCodeunits(String s) {
        int n = s.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char ch = s.charAt(i2);
            if (ch < ' ') {
                if (!IS_BANNED_ASCII[ch]) continue;
                return i2;
            }
            if ('\ud800' > ch) continue;
            if (ch <= '\udfff') {
                if (i2 + 1 < n && Character.isSurrogatePair(ch, s.charAt(i2 + 1))) {
                    ++i2;
                    continue;
                }
                return i2;
            }
            if ((ch & 0xFFFE) != 65534) continue;
            return i2;
        }
        return -1;
    }

    static void encodeHtmlAttribOnto(String plainText, Appendable output) throws IOException {
        Encoding.encodeHtmlOnto(plainText, output, "{\u200b");
    }

    static void encodePcdataOnto(String plainText, Appendable output) throws IOException {
        Encoding.encodeHtmlOnto(plainText, output, "{<!-- -->");
    }

    public static void encodeRcdataOnto(String plainText, Appendable output) throws IOException {
        Encoding.encodeHtmlOnto(plainText, output, "{\u200b");
    }

    @TCB
    private static void encodeHtmlOnto(String plainText, Appendable output, @Nullable String braceReplacement) throws IOException {
        int n = plainText.length();
        int pos = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            char ch = plainText.charAt(i2);
            if (ch < REPLACEMENTS.length) {
                String repl = REPLACEMENTS[ch];
                if (ch == '{' && repl == null && (i2 + 1 == n || plainText.charAt(i2 + 1) == '{')) {
                    repl = braceReplacement;
                }
                if (repl == null) continue;
                output.append(plainText, pos, i2).append(repl);
                pos = i2 + 1;
                continue;
            }
            if ('\u093a' <= ch && ch <= '\u0c4c' && (ch <= '\u094f' || '\u0985' <= ch && ch <= '\u0994' || '\u09be' <= ch && ch < '\u09cc' || '\u09e0' <= ch && ch <= '\u09e3' || '\u0c05' <= ch && ch <= '\u0c14' || '\u0c3e' <= ch && ch != '\u0c48')) {
                StringBuilder sb;
                int len;
                if (pos < i2) {
                    if (plainText.charAt(i2 - 1) != '\u200c') continue;
                    output.append(plainText, pos, i2 - 1);
                    pos = i2;
                    continue;
                }
                if (!(output instanceof StringBuilder) || (len = (sb = (StringBuilder)output).length()) == 0 || sb.charAt(len - 1) != '\u200c') continue;
                sb.setLength(len - 1);
                continue;
            }
            if ('\ud800' <= ch) {
                if (ch <= '\udfff') {
                    char next;
                    if (i2 + 1 < n && Character.isSurrogatePair(ch, next = plainText.charAt(i2 + 1))) {
                        int codepoint = Character.toCodePoint(ch, next);
                        output.append(plainText, pos, i2);
                        Encoding.appendNumericEntity(codepoint, output);
                        pos = ++i2 + 1;
                        continue;
                    }
                    output.append(plainText, pos, i2);
                    pos = i2 + 1;
                    continue;
                }
                if ('\ufe60' > ch) continue;
                output.append(plainText, pos, i2);
                pos = i2 + 1;
                if ((ch & 0xFFFE) == 65534) continue;
                Encoding.appendNumericEntity(ch, output);
                continue;
            }
            if (ch != '\u1fef') continue;
            output.append(plainText, pos, i2).append("&#8175;");
            pos = i2 + 1;
        }
        output.append(plainText, pos, n);
    }

    @TCB
    static void appendNumericEntity(int codepoint, Appendable output) throws IOException {
        output.append("&#");
        if (codepoint < 100) {
            if (codepoint < 10) {
                output.append((char)(48 + codepoint));
            } else {
                output.append((char)(48 + codepoint / 10));
                output.append((char)(48 + codepoint % 10));
            }
        } else {
            int nDigits = codepoint < 4096 ? (codepoint < 256 ? 2 : 3) : (codepoint < 65536 ? 4 : (codepoint < 0x100000 ? 5 : 6));
            output.append('x');
            int digit = nDigits;
            while (--digit >= 0) {
                int hexDigit = codepoint >>> (digit << 2) & 0xF;
                output.append(HEX_NUMERAL[hexDigit]);
            }
        }
        output.append(";");
    }

    static {
        int i2;
        HEX_NUMERAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        REPLACEMENTS = new String[128];
        for (i2 = 0; i2 < 32; ++i2) {
            if (i2 == 9 || i2 == 10 || i2 == 13) continue;
            Encoding.REPLACEMENTS[i2] = "";
        }
        Encoding.REPLACEMENTS[34] = "&#34;";
        Encoding.REPLACEMENTS[38] = "&amp;";
        Encoding.REPLACEMENTS[39] = "&#39;";
        Encoding.REPLACEMENTS[43] = "&#43;";
        Encoding.REPLACEMENTS[60] = "&lt;";
        Encoding.REPLACEMENTS[61] = "&#61;";
        Encoding.REPLACEMENTS[62] = "&gt;";
        Encoding.REPLACEMENTS[64] = "&#64;";
        Encoding.REPLACEMENTS[96] = "&#96;";
        IS_BANNED_ASCII = new boolean[32];
        for (i2 = 0; i2 < IS_BANNED_ASCII.length; ++i2) {
            Encoding.IS_BANNED_ASCII[i2] = i2 != 9 && i2 != 10 && i2 != 13;
        }
    }
}

