/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.tree.tiny.GraftedElement;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class TinyParentNodeImpl
extends TinyNodeImpl {
    @Override
    public boolean hasChildNodes() {
        return this.nodeNr + 1 < this.tree.numberOfNodes && this.tree.depth[this.nodeNr + 1] > this.tree.depth[this.nodeNr];
    }

    @Override
    public String getStringValue() {
        return TinyParentNodeImpl.getStringValueCS(this.tree, this.nodeNr).toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return TinyParentNodeImpl.getStringValueCS(this.tree, this.nodeNr);
    }

    public static CharSequence getStringValueCS(TinyTree tree, int nodeNr) {
        int next;
        short level = tree.depth[nodeNr];
        if (tree.nodeKind[nodeNr] == 17) {
            return TinyTextImpl.getStringValue(tree, nodeNr);
        }
        if (tree.nodeKind[nodeNr] == 33) {
            GraftedElement graft = tree.externalNodes.get(tree.alpha[nodeNr]);
            return graft.getStringValueCS();
        }
        if (tree.depth[next] <= level) {
            return "";
        }
        if (tree.nodeKind[next] == 3 && (next + 1 >= tree.numberOfNodes || tree.depth[next + 1] <= level)) {
            return TinyTextImpl.getStringValue(tree, next);
        }
        FastStringBuffer sb = null;
        for (next = nodeNr + 1; next < tree.numberOfNodes && tree.depth[next] > level; ++next) {
            byte kind = tree.nodeKind[next];
            if (kind == 3 || kind == 17) {
                if (sb == null) {
                    sb = new FastStringBuffer(256);
                }
                sb.append(TinyTextImpl.getStringValue(tree, next));
                continue;
            }
            if (kind == 4) {
                if (sb == null) {
                    sb = new FastStringBuffer(256);
                }
                WhitespaceTextImpl.appendStringValue(tree, next, sb);
                continue;
            }
            if (kind != 33) continue;
            GraftedElement graft = (GraftedElement)tree.getNode(next);
            if (sb == null) {
                sb = new FastStringBuffer(256);
            }
            sb.append(graft.getStringValueCS());
        }
        if (sb == null) {
            return "";
        }
        return sb.condense();
    }
}

