/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.actions.ActivateAntToolWindowAction;
import com.intellij.lang.ant.config.impl.AntUnlinkedProjectAware;
import com.intellij.lang.ant.config.impl.AntUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/ant/config/impl/AntUnlinkedProjectAware;", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getNotificationText", "", "isBuildFile", "", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLinkedProject", "externalProjectPath", "linkAndLoadProject", "", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.ant"})
public final class AntUnlinkedProjectAware
implements ExternalSystemUnlinkedProjectAware {
    @NotNull
    private final ProjectSystemId systemId = AntUtil.getSYSTEM_ID();

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    public boolean isBuildFile(@NotNull Project project, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return AntUtil.getKNOWN_ANT_FILES().contains(buildFile.getName());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLinkedProject(@NotNull Project project, @NotNull String externalProjectPath) {
        boolean bl;
        block1: {
            void $this$any$iv;
            AntConfigurationBase antConfiguration;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            AntConfigurationBase antConfigurationBase = antConfiguration = AntConfigurationBase.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)antConfigurationBase), (String)"antConfiguration");
            Object[] objectArray = antConfigurationBase.getBuildFiles();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"antConfiguration.buildFiles");
            Sequence sequence = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)isLinkedProject.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!FileUtil.pathsEqual((String)PathUtil.getParentPath((String)it), (String)externalProjectPath)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void linkAndLoadProject(@NotNull Project project, @NotNull String externalProjectPath) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile externalProjectDir = localFileSystem.findFileByPath(externalProjectPath);
        if (externalProjectDir == null) {
            String shortPath = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)externalProjectPath), (boolean)false);
            throw (Throwable)new IllegalArgumentException(ExternalSystemBundle.message((String)"error.project.does.not.exist", (Object[])new Object[]{this.getSystemId().getReadableName(), shortPath}));
        }
        AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(project);
        VirtualFile[] virtualFileArray = externalProjectDir.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"externalProjectDir.children");
        VirtualFile[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var12_13 = $this$filterTo$iv$iv;
        int n = ((void)var12_13).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var12_13[i];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!this.isBuildFile(project, (VirtualFile)v1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List antBuildFiles = (List)destination$iv$iv;
        Iterable $this$forEach$iv = antBuildFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            antConfiguration.addBuildFile(it);
        }
        $this$forEach$iv = antBuildFiles;
        boolean bl = false;
        if (!$this$forEach$iv.isEmpty()) {
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Ant");
            if (toolWindow == null) {
                toolWindow = ActivateAntToolWindowAction.Companion.createToolWindow(project);
            }
            ToolWindow window = toolWindow;
            window.activate(null);
        }
    }

    public void subscribe(@NotNull Project project, @NotNull ExternalSystemProjectLinkListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(project);
        antConfiguration.addAntConfigurationListener(new AntConfigurationListener(listener){
            final /* synthetic */ ExternalSystemProjectLinkListener $listener;

            public void buildFileAdded(@NotNull AntBuildFile buildFile) {
                Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
                VirtualFile virtualFile = buildFile.getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"buildFile.virtualFile ?: return");
                VirtualFile virtualFile2 = virtualFile;
                String string = PathUtil.getParentPath((String)virtualFile2.getPath());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getParentPath(virtualFile.path)");
                this.$listener.onProjectLinked(string);
            }

            public void buildFileRemoved(@NotNull AntBuildFile buildFile) {
                Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public String getNotificationText() {
        String string = AntBundle.message("add.ant.build.file", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AntBundle.message(\"add.ant.build.file\")");
        return string;
    }
}

