/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.daemon.quickFix.CreateClassOrPackageFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiPackageConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ContentDescriptor;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public class ModuleDescriptorPackageConverter
extends PsiPackageConverter {
    public PsiPackage fromString(@Nullable String s, ConvertContext context) {
        GlobalSearchScope scope = this.getResolveScope(context.getInvocationElement());
        if (scope == null) {
            return null;
        }
        return super.fromString(s, context);
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<PsiPackage> genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ModuleDescriptorPackageConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GlobalSearchScope searchScope = this.getResolveScope((DomElement)genericDomValue);
        if (searchScope == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ModuleDescriptorPackageConverter.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PackageReferenceSet(s, element, ElementManipulators.getOffsetInElement((PsiElement)element), searchScope){

            @NotNull
            protected PsiPackageReference createReference(TextRange range, int index) {
                return new MyCreatePackageFixPsiPackageReference(this, range, index, this.getResolveScope());
            }
        }.getPsiReferences();
        if (psiReferenceArray == null) {
            ModuleDescriptorPackageConverter.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @Nullable
    protected GlobalSearchScope getResolveScope(DomElement domElement) {
        ContentDescriptor.ModuleDescriptor moduleDescriptor = (ContentDescriptor.ModuleDescriptor)domElement.getParentOfType(ContentDescriptor.ModuleDescriptor.class, true);
        assert (moduleDescriptor != null);
        IdeaPlugin ideaPlugin = (IdeaPlugin)moduleDescriptor.getName().getValue();
        if (ideaPlugin == null) {
            return null;
        }
        return ModuleDescriptorPackageConverter.getScope(ideaPlugin, false);
    }

    @Nullable
    private static GlobalSearchScope getScope(IdeaPlugin ideaPlugin, boolean withDependencies) {
        Module module = ideaPlugin.getModule();
        if (module == null) {
            return null;
        }
        return withDependencies ? module.getModuleWithDependenciesScope() : module.getModuleScope(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/ModuleDescriptorPackageConverter", "createReferences"));
    }

    public static class ForIdeaPlugin
    extends ModuleDescriptorPackageConverter {
        @Override
        protected GlobalSearchScope getResolveScope(DomElement genericDomValue) {
            IdeaPlugin ideaPlugin = (IdeaPlugin)genericDomValue.getParentOfType(IdeaPlugin.class, true);
            assert (ideaPlugin != null);
            return ModuleDescriptorPackageConverter.getScope(ideaPlugin, ideaPlugin.hasRealPluginId() || DomUtil.hasXml(ideaPlugin.getName()));
        }
    }

    private static class MyCreatePackageFixPsiPackageReference
    extends PsiPackageReference
    implements LocalQuickFixProvider {
        private final GlobalSearchScope myScope;

        MyCreatePackageFixPsiPackageReference(PackageReferenceSet set, TextRange range, int index, GlobalSearchScope searchScope) {
            super(set, range, index);
            this.myScope = searchScope;
        }

        public LocalQuickFix @Nullable [] getQuickFixes() {
            LocalQuickFix[] localQuickFixArray;
            String qualifiedName;
            CreateClassOrPackageFix fix;
            ResolveResult resolveResult;
            PsiPackage basePackage = null;
            if (this.myIndex != 0 && (resolveResult = (ResolveResult)ArrayUtil.getFirstElement((Object[])((PsiPackageReference)this.getReferenceSet().getReference(this.myIndex - 1)).multiResolve(false))) != null) {
                basePackage = (PsiPackage)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiPackage.class);
            }
            if ((fix = CreateClassOrPackageFix.createFix((String)(qualifiedName = ElementManipulators.getValueText((PsiElement)this.getElement())), (GlobalSearchScope)this.myScope, (PsiElement)this.getElement(), basePackage, null, null, null)) != null) {
                CreateClassOrPackageFix[] createClassOrPackageFixArray = new CreateClassOrPackageFix[1];
                localQuickFixArray = createClassOrPackageFixArray;
                createClassOrPackageFixArray[0] = fix;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            return localQuickFixArray;
        }
    }
}

