/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;
import org.jetbrains.idea.devkit.dom.index.RegistrationEntry;
import org.jetbrains.idea.devkit.dom.index.RegistrationIndexer;

public class IdeaPluginRegistrationIndex
extends PluginXmlIndexBase<String, List<RegistrationEntry>> {
    private static final int INDEX_VERSION = 3;
    private static final ID<String, List<RegistrationEntry>> NAME = ID.create((String)"IdeaPluginRegistrationIndex");
    private final DataExternalizer<List<RegistrationEntry>> myValueExternalizer = new DataExternalizer<List<RegistrationEntry>>(){

        public void save(@NotNull DataOutput out, List<RegistrationEntry> values) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtilRt.writeSeq((DataOutput)out, values, entry -> {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getRegistrationType().ordinal());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getOffset());
            });
        }

        public List<RegistrationEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return DataInputOutputUtilRt.readSeq((DataInput)in, () -> {
                RegistrationEntry.RegistrationType type = RegistrationEntry.RegistrationType.values()[DataInputOutputUtil.readINT((DataInput)in)];
                int offset = DataInputOutputUtil.readINT((DataInput)in);
                return new RegistrationEntry(type, offset);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, List<RegistrationEntry>> getName() {
        ID<String, List<RegistrationEntry>> iD = NAME;
        if (iD == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    protected Map<String, List<RegistrationEntry>> performIndexing(IdeaPlugin plugin) {
        return new RegistrationIndexer(plugin).indexFile();
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<RegistrationEntry>> getValueExternalizer() {
        DataExternalizer<List<RegistrationEntry>> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 3;
    }

    public static boolean isRegisteredApplicationComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegistered(psiClass, scope, RegistrationEntry.RegistrationType.APPLICATION_COMPONENT);
    }

    public static boolean isRegisteredProjectComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegistered(psiClass, scope, RegistrationEntry.RegistrationType.PROJECT_COMPONENT);
    }

    public static boolean isRegisteredModuleComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegistered(psiClass, scope, RegistrationEntry.RegistrationType.MODULE_COMPONENT);
    }

    public static boolean isRegisteredAction(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegistered(psiClass, scope, RegistrationEntry.RegistrationType.ACTION);
    }

    private static boolean isRegistered(PsiClass psiClass, GlobalSearchScope scope, RegistrationEntry.RegistrationType type) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        return !FileBasedIndex.getInstance().processValues(NAME, (Object)qualifiedName, null, (file, value) -> ContainerUtil.process((List)value, entry -> entry.getRegistrationType() != type), scope);
    }

    public static boolean processAllActionOrGroup(@NotNull Project project, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(3);
        }
        HashSet keys = new HashSet();
        FileBasedIndex.getInstance().processAllKeys(NAME, s -> keys.add(s), scope, null);
        return ContainerUtil.process(keys, s -> IdeaPluginRegistrationIndex.processActionOrGroup(project, s, scope, processor));
    }

    public static boolean processActionOrGroup(@NotNull Project project, @NotNull String actionOrGroupId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(4);
        }
        if (actionOrGroupId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(5);
        }
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionOrGroupId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_ID, RegistrationEntry.RegistrationType.ACTION_GROUP_ID), processor);
    }

    public static boolean processAction(@NotNull Project project, @NotNull String actionId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(6);
        }
        if (actionId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(7);
        }
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_ID), processor);
    }

    public static boolean processGroup(@NotNull Project project, @NotNull String actionGroupId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(8);
        }
        if (actionGroupId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(9);
        }
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionGroupId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_GROUP_ID), processor);
    }

    private static boolean doProcessActionOrGroup(@NotNull Project project, @NotNull String actionOrGroupId, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Processor<? super ActionOrGroup> processor) {
        if (project == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(10);
        }
        if (actionOrGroupId == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(11);
        }
        SmartList tags = new SmartList();
        FileBasedIndex.getInstance().processValues(NAME, (Object)actionOrGroupId, null, (arg_0, arg_1) -> IdeaPluginRegistrationIndex.lambda$doProcessActionOrGroup$4(types, project, (List)tags, arg_0, arg_1), scope);
        return ContainerUtil.process((List)tags, tag -> {
            DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
            if (!(domElement instanceof ActionOrGroup)) {
                return true;
            }
            return processor.process((Object)((ActionOrGroup)domElement));
        });
    }

    private static /* synthetic */ boolean lambda$doProcessActionOrGroup$4(EnumSet types, Project project, List tags, VirtualFile file, List value) {
        for (RegistrationEntry entry : value) {
            PsiFile psiFile;
            if (!types.contains((Object)entry.getRegistrationType()) || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile)) continue;
            PsiElement psiElement = psiFile.findElementAt(entry.getOffset());
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
            tags.add(xmlTag);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionOrGroupId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAllActionOrGroup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processActionOrGroup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processGroup";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doProcessActionOrGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

