/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

final class JUnitDevKitPatcher
extends JUnitPatcher {
    private static final Logger LOG = Logger.getInstance(JUnitDevKitPatcher.class);
    private static final String SYSTEM_CL_PROPERTY = "java.system.class.loader";
    private static final Key<Boolean> LOADER_VALID_9 = Key.create((String)"LOADER_VALID_9");

    JUnitDevKitPatcher() {
    }

    public void patchJavaParameters(@NotNull Project project, @Nullable Module module, JavaParameters javaParameters) {
        File sandboxHome;
        List<String> ids;
        Sdk jdk;
        if (project == null) {
            JUnitDevKitPatcher.$$$reportNull$$$0(0);
        }
        if ((jdk = javaParameters.getJdk()) == null) {
            return;
        }
        ParametersList vm = javaParameters.getVMParametersList();
        if (PsiUtil.isIdeaProject(project)) {
            String qualifiedName;
            if (!vm.hasProperty(SYSTEM_CL_PROPERTY) && JUnitDevKitPatcher.loaderValid(project, module, qualifiedName = UrlClassLoader.class.getName())) {
                vm.addProperty(SYSTEM_CL_PROPERTY, qualifiedName);
            }
            String basePath = project.getBasePath();
            if (!vm.hasProperty("idea.system.path")) {
                vm.addProperty("idea.system.path", new File(basePath, "system/test").getAbsolutePath());
            }
            if (!vm.hasProperty("idea.config.path")) {
                vm.addProperty("idea.config.path", new File(basePath, "config/test").getAbsolutePath());
            }
        }
        if (Registry.is((String)"idea.lazy.classloading.caches") && vm.hasProperty(SYSTEM_CL_PROPERTY) && "com.intellij.util.lang.UrlClassLoader".equals(vm.getPropertyValue(SYSTEM_CL_PROPERTY))) {
            vm.addProperty("idea.lazy.classloading.caches", "true");
        }
        if ((jdk = IdeaJdk.findIdeaJdk(jdk)) == null) {
            return;
        }
        @NonNls String libPath = jdk.getHomePath() + File.separator + "lib";
        @NonNls String bootJarPath = libPath + File.separator + "boot.jar";
        if (new File(bootJarPath).exists()) {
            vm.add("-Xbootclasspath/a:" + bootJarPath);
        }
        if (!vm.hasProperty("idea.load.plugins.id") && module != null && PluginModuleType.isOfType(module) && !(ids = DescriptorUtil.getPluginAndOptionalDependenciesIds(module)).isEmpty()) {
            vm.defineProperty("idea.load.plugins.id", StringUtil.join(ids, (String)","));
        }
        if ((sandboxHome = JUnitDevKitPatcher.getSandboxPath(jdk)) != null) {
            if (!vm.hasProperty("idea.home.path")) {
                File homeDir = new File(sandboxHome, "test");
                FileUtil.createDirectory((File)homeDir);
                String buildNumber = IdeaJdk.getBuildNumber(jdk.getHomePath());
                if (buildNumber != null) {
                    try {
                        FileUtil.writeToFile((File)new File(homeDir, "build.txt"), (String)buildNumber);
                    }
                    catch (IOException e) {
                        LOG.warn("failed to create build.txt in " + homeDir + ": " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    LOG.warn("Cannot determine build number for " + jdk.getHomePath());
                }
                vm.defineProperty("idea.home.path", homeDir.getAbsolutePath());
            }
            if (!vm.hasProperty("idea.plugins.path")) {
                vm.defineProperty("idea.plugins.path", new File(sandboxHome, "plugins").getAbsolutePath());
            }
        }
        javaParameters.getClassPath().addFirst(libPath + File.separator + "idea.jar");
        javaParameters.getClassPath().addFirst(libPath + File.separator + "resources.jar");
        javaParameters.getClassPath().addFirst(((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk));
    }

    private static boolean loaderValid(Project project, Module module, String qualifiedName) {
        Key<Boolean> cacheKey;
        if (!Registry.is((String)"idea.use.loader.for.jdk9")) {
            return false;
        }
        Object holder = module != null ? module : project;
        Boolean res = (Boolean)holder.getUserData(cacheKey = LOADER_VALID_9);
        if (res == null) {
            res = (Boolean)ReadAction.compute(() -> (Boolean)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> {
                GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)project);
                return JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, scope) != null;
            }));
            holder.putUserData(cacheKey, (Object)res);
        }
        return res;
    }

    @Nullable
    private static File getSandboxPath(Sdk jdk) {
        String sandboxHome;
        SdkAdditionalData additionalData = jdk.getSdkAdditionalData();
        if (additionalData instanceof Sandbox && (sandboxHome = ((Sandbox)additionalData).getSandboxHome()) != null) {
            return new File(FileUtil.toCanonicalPath((String)sandboxHome));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/run/JUnitDevKitPatcher", "patchJavaParameters"));
    }
}

