/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public final class ClassReference14Processor {
    private static final ExitExprent BODY_EXPR;
    private static final ExitExprent HANDLER_EXPR;

    public static void processClassReferences(ClassesProcessor.ClassNode node) {
        HashMap<ClassWrapper, MethodWrapper> mapClassMeths = new HashMap<ClassWrapper, MethodWrapper>();
        ClassReference14Processor.mapClassMethods(node, mapClassMeths);
        if (mapClassMeths.isEmpty()) {
            return;
        }
        HashSet setFound = new HashSet();
        ClassReference14Processor.processClassRec(node, mapClassMeths, setFound);
        if (!setFound.isEmpty()) {
            for (ClassWrapper wrp : setFound) {
                StructMethod mt = ((MethodWrapper)mapClassMeths.get((Object)wrp)).methodStruct;
                wrp.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
            }
        }
    }

    private static void processClassRec(ClassesProcessor.ClassNode node, Map<ClassWrapper, MethodWrapper> mapClassMeths, Set<? super ClassWrapper> setFound) {
        ClassWrapper wrapper = node.getWrapper();
        for (MethodWrapper meth : wrapper.getMethods()) {
            RootStatement root = meth.root;
            if (root == null) continue;
            DirectGraph graph = meth.getOrBuildGraph();
            graph.iterateExprents(exprent -> {
                for (Map.Entry ent : mapClassMeths.entrySet()) {
                    if (!ClassReference14Processor.replaceInvocations(exprent, (ClassWrapper)ent.getKey(), (MethodWrapper)ent.getValue())) continue;
                    setFound.add((ClassWrapper)ent.getKey());
                }
                return 0;
            });
        }
        for (int j = 0; j < 2; ++j) {
            VBStyleCollection<Exprent, String> initializers = j == 0 ? wrapper.getStaticFieldInitializers() : wrapper.getDynamicFieldInitializers();
            for (int i = 0; i < initializers.size(); ++i) {
                for (Map.Entry<ClassWrapper, MethodWrapper> ent : mapClassMeths.entrySet()) {
                    String cl;
                    Exprent exprent2 = (Exprent)initializers.get(i);
                    if (ClassReference14Processor.replaceInvocations(exprent2, ent.getKey(), ent.getValue())) {
                        setFound.add(ent.getKey());
                    }
                    if ((cl = ClassReference14Processor.isClass14Invocation(exprent2, ent.getKey(), ent.getValue())) == null) continue;
                    initializers.set(i, new ConstExprent(VarType.VARTYPE_CLASS, cl.replace('.', '/'), exprent2.bytecode));
                    setFound.add(ent.getKey());
                }
            }
        }
        for (ClassesProcessor.ClassNode nd : node.nested) {
            ClassReference14Processor.processClassRec(nd, mapClassMeths, setFound);
        }
    }

    private static void mapClassMethods(ClassesProcessor.ClassNode node, Map<ClassWrapper, MethodWrapper> map) {
        boolean noSynthFlag = DecompilerContext.getOption("nns");
        ClassWrapper wrapper = node.getWrapper();
        for (MethodWrapper method : wrapper.getMethods()) {
            CatchStatement cst;
            RootStatement root;
            StructMethod mt = method.methodStruct;
            if (!noSynthFlag && !mt.isSynthetic() || !mt.getDescriptor().equals("(Ljava/lang/String;)Ljava/lang/Class;") || !mt.hasModifier(8) || (root = method.root) == null || root.getFirst().type != 7 || (cst = (CatchStatement)root.getFirst()).getStats().size() != 2 || cst.getFirst().type != 8 || ((Statement)cst.getStats().get((int)1)).type != 8 || !cst.getVars().get(0).getVarType().equals(new VarType(8, 0, "java/lang/ClassNotFoundException"))) continue;
            BasicBlockStatement body = (BasicBlockStatement)cst.getFirst();
            BasicBlockStatement handler = (BasicBlockStatement)cst.getStats().get(1);
            if (body.getExprents().size() != 1 || handler.getExprents().size() != 1 || !BODY_EXPR.equals(body.getExprents().get(0)) || !HANDLER_EXPR.equals(handler.getExprents().get(0))) continue;
            map.put(wrapper, method);
            break;
        }
        for (ClassesProcessor.ClassNode nd : node.nested) {
            ClassReference14Processor.mapClassMethods(nd, map);
        }
    }

    private static boolean replaceInvocations(Exprent exprent, ClassWrapper wrapper, MethodWrapper meth) {
        boolean found;
        boolean res = false;
        block0: do {
            found = false;
            for (Exprent expr : exprent.getAllExprents()) {
                String cl = ClassReference14Processor.isClass14Invocation(expr, wrapper, meth);
                if (cl != null) {
                    exprent.replaceExprent(expr, new ConstExprent(VarType.VARTYPE_CLASS, cl.replace('.', '/'), expr.bytecode));
                    found = true;
                    res = true;
                    continue block0;
                }
                res |= ClassReference14Processor.replaceInvocations(expr, wrapper, meth);
            }
        } while (found);
        return res;
    }

    private static String isClass14Invocation(Exprent exprent, ClassWrapper wrapper, MethodWrapper meth) {
        FunctionExprent headexpr;
        FunctionExprent fexpr;
        if (exprent.type == 6 && (fexpr = (FunctionExprent)exprent).getFuncType() == 36 && fexpr.getLstOperands().get((int)0).type == 6 && (headexpr = (FunctionExprent)fexpr.getLstOperands().get(0)).getFuncType() == 42 && headexpr.getLstOperands().get((int)0).type == 5 && headexpr.getLstOperands().get((int)1).type == 3 && ((ConstExprent)headexpr.getLstOperands().get(1)).getConstType().equals(VarType.VARTYPE_NULL)) {
            InvocationExprent invexpr;
            AssignmentExprent asexpr;
            StructField fd;
            FieldExprent field = (FieldExprent)headexpr.getLstOperands().get(0);
            ClassesProcessor.ClassNode fieldnode = DecompilerContext.getClassProcessor().getMapRootClasses().get(field.getClassname());
            if (fieldnode != null && fieldnode.classStruct.qualifiedName.equals(wrapper.getClassStruct().qualifiedName) && (fd = wrapper.getClassStruct().getField(field.getName(), field.getDescriptor().descriptorString)) != null && fd.hasModifier(8) && (fd.isSynthetic() || DecompilerContext.getOption("nns")) && fexpr.getLstOperands().get((int)1).type == 2 && fexpr.getLstOperands().get(2).equals(field) && (asexpr = (AssignmentExprent)fexpr.getLstOperands().get(1)).getLeft().equals(field) && asexpr.getRight().type == 8 && (invexpr = (InvocationExprent)asexpr.getRight()).getClassname().equals(wrapper.getClassStruct().qualifiedName) && invexpr.getName().equals(meth.methodStruct.getName()) && invexpr.getStringDescriptor().equals(meth.methodStruct.getDescriptor()) && invexpr.getLstParameters().get((int)0).type == 3) {
                wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
                return ((ConstExprent)invexpr.getLstParameters().get(0)).getValue().toString();
            }
        }
        return null;
    }

    static {
        InvocationExprent invFor = new InvocationExprent();
        invFor.setName("forName");
        invFor.setClassname("java/lang/Class");
        invFor.setStringDescriptor("(Ljava/lang/String;)Ljava/lang/Class;");
        invFor.setDescriptor(MethodDescriptor.parseDescriptor("(Ljava/lang/String;)Ljava/lang/Class;"));
        invFor.setStatic(true);
        invFor.setLstParameters(Collections.singletonList(new VarExprent(0, VarType.VARTYPE_STRING, null)));
        BODY_EXPR = new ExitExprent(0, invFor, VarType.VARTYPE_CLASS, null);
        InvocationExprent ctor = new InvocationExprent();
        ctor.setName("<init>");
        ctor.setClassname("java/lang/NoClassDefFoundError");
        ctor.setStringDescriptor("()V");
        ctor.setFunctype(2);
        ctor.setDescriptor(MethodDescriptor.parseDescriptor("()V"));
        NewExprent newExpr = new NewExprent(new VarType(8, 0, "java/lang/NoClassDefFoundError"), new ArrayList<Exprent>(), null);
        newExpr.setConstructor(ctor);
        InvocationExprent invCause = new InvocationExprent();
        invCause.setName("initCause");
        invCause.setClassname("java/lang/NoClassDefFoundError");
        invCause.setStringDescriptor("(Ljava/lang/Throwable;)Ljava/lang/Throwable;");
        invCause.setDescriptor(MethodDescriptor.parseDescriptor("(Ljava/lang/Throwable;)Ljava/lang/Throwable;"));
        invCause.setInstance(newExpr);
        invCause.setLstParameters(Collections.singletonList(new VarExprent(2, new VarType(8, 0, "java/lang/ClassNotFoundException"), null)));
        HANDLER_EXPR = new ExitExprent(1, invCause, null, null);
    }
}

