/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitLocalBranch;
import git4idea.actions.GitLogSingleCommitAction;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u0010"}, d2={"Lgit4idea/actions/GitPushUpToCommitAction;", "Lgit4idea/actions/GitLogSingleCommitAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/Hash;", "getSourceReference", "", "hash", "isEnabled", "", "intellij.vcs.git"})
public final class GitPushUpToCommitAction
extends GitLogSingleCommitAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        GitLocalBranch branch;
        GitRepository repository;
        CommitId commit;
        VcsLogUi logUI;
        VcsLogData logData;
        VcsLog log;
        Project project;
        block10: {
            GitLocalBranch gitLocalBranch;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getRequiredData(CommonDataKeys.PROJECT);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
            project = (Project)object;
            Object object2 = e.getRequiredData(VcsLogDataKeys.VCS_LOG);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getRequiredData(VcsLogDataKeys.VCS_LOG)");
            log = (VcsLog)object2;
            Object object3 = e.getRequiredData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.vcs.log.data.VcsLogData");
            }
            logData = (VcsLogData)object3;
            Object object4 = e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI)");
            logUI = (VcsLogUi)object4;
            Object object5 = ContainerUtil.getFirstItem((List)log.getSelectedCommits());
            Intrinsics.checkNotNull((Object)object5);
            commit = (CommitId)object5;
            GitRepository gitRepository = this.getRepositoryForRoot(project, commit.getRoot());
            Intrinsics.checkNotNull((Object)gitRepository);
            repository = gitRepository;
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
            Hash hash = commit.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commit.hash");
            List<String> branches2 = GitCommitEditingActionBase.Companion.findContainingBranches(logData, virtualFile, hash);
            if (branches2.contains("HEAD")) {
                GitLocalBranch gitLocalBranch2 = repository.getCurrentBranch();
                gitLocalBranch = gitLocalBranch2;
                Intrinsics.checkNotNull((Object)gitLocalBranch2);
            } else {
                Iterable iterable = branches2;
                boolean bl = false;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl2 = false;
                    GitLocalBranch gitLocalBranch3 = repository.getBranches().findLocalBranch(it);
                    if (gitLocalBranch3 == null) continue;
                    gitLocalBranch = gitLocalBranch3;
                    break block10;
                }
                gitLocalBranch = branch = null;
            }
        }
        if (branch != null) {
            String string;
            if (Intrinsics.areEqual((Object)branch, (Object)repository.getCurrentBranch()) && Registry.is((String)"git.push.upto.commit.with.head.reference")) {
                GitCommitEditingActionBase.MultipleCommitEditingData multipleCommitEditingData = new GitCommitEditingActionBase.MultipleCommitEditingData(repository, log, logData, logUI);
                String string2 = GitBundle.message("push.up.to.commit.allowed.progress.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"push.\u2026.allowed.progress.title\")");
                String description = GitCommitEditingActionBase.Companion.checkHeadLinearHistory(multipleCommitEditingData, string2);
                if (description != null) {
                    Messages.showErrorDialog((Project)project, (String)description, (String)GitBundle.message("push.upto.here.failed.dialog.title", new Object[0]));
                    return;
                }
                Hash hash = commit.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commit.hash");
                string = this.getSourceReference(repository, hash);
            } else {
                string = commit.getHash().asString();
            }
            String referenceToPush = string;
            Project project2 = repository.getProject();
            Collection collection = CollectionsKt.listOf((Object)repository);
            List list2 = CollectionsKt.listOf((Object)repository);
            Repository repository2 = repository;
            String string3 = referenceToPush;
            if (string3 == null) {
                String string4 = commit.getHash().asString();
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commit.hash.asString()");
            }
            new VcsPushDialog(project2, collection, list2, repository2, (PushSource)GitPushSource.create(branch, string3)).show();
        }
        if (branch == null) {
            VcsNotifier.getInstance((Project)project).notifyError("git.push.not.supported", GitBundle.message("push.upto.here.not.supported.notification.title", new Object[0]), GitBundle.message("push.upto.here.not.supported.notification.message", new Object[0]));
        }
    }

    protected void actionPerformed(@NotNull GitRepository repository, @NotNull Hash commit) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
    }

    protected boolean isEnabled(@NotNull GitRepository repository, @NotNull Hash commit) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return repository.isOnBranch();
    }

    /*
     * WARNING - void declaration
     */
    private final String getSourceReference(GitRepository repository, Hash hash) {
        void reference;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(repository, hash, (Ref.ObjectRef)reference){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ Hash $hash;
            final /* synthetic */ Ref.ObjectRef $reference;

            public final void run() {
                block2: {
                    Integer count;
                    Integer n;
                    boolean bl;
                    Object object;
                    String string = GitHistoryUtils.getNumberOfCommitsBetween(this.$repository, this.$hash.asString(), "HEAD");
                    if (string != null) {
                        object = string;
                        bl = false;
                        n = Integer.parseInt((String)object);
                    } else {
                        n = null;
                    }
                    Integer n2 = count = n;
                    if (n2 == null) break block2;
                    object = n2;
                    bl = false;
                    boolean bl2 = false;
                    int it = ((Number)object).intValue();
                    boolean bl3 = false;
                    this.$reference.element = count > 0 ? "HEAD^" + count : "HEAD";
                }
            }
            {
                this.$repository = gitRepository;
                this.$hash = hash;
                this.$reference = objectRef;
            }
        }, GitBundle.message("push.up.to.commit.getting.reference.progress.title", new Object[0]), true, repository.getProject());
        return (String)reference.element;
    }
}

