/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.CompareWithLocalDialog;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.diff.GitSubmoduleContentRevision;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitSubmodule;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogDiffHandler
implements VcsLogDiffHandler {
    private static final Logger LOG = Logger.getInstance(GitLogDiffHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiffContentFactoryEx myDiffContentFactory;

    public GitLogDiffHandler(@NotNull Project project) {
        if (project == null) {
            GitLogDiffHandler.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDiffContentFactory = DiffContentFactoryEx.getInstanceEx();
    }

    public void showDiff(@NotNull VirtualFile root, @Nullable FilePath leftPath, @NotNull Hash leftHash, @Nullable FilePath rightPath, @NotNull Hash rightHash) {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(1);
        }
        if (leftHash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(2);
        }
        if (rightHash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(3);
        }
        if (leftPath == null && rightPath == null) {
            return;
        }
        FilePath filePath = (FilePath)ObjectUtils.chooseNotNull((Object)leftPath, (Object)rightPath);
        if (filePath.isDirectory()) {
            this.showDiffForPaths(root, Collections.singleton(filePath), leftHash, rightHash);
        } else {
            DiffRequestProducer requestProducer = SimpleDiffRequestProducer.create((FilePath)filePath, () -> {
                DiffContent leftDiffContent = this.createDiffContent(root, leftPath, leftHash);
                DiffContent rightDiffContent = this.createDiffContent(root, rightPath, rightHash);
                return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)leftPath, (FilePath)rightPath, (String)" -> "), leftDiffContent, rightDiffContent, leftHash.asString(), rightHash.asString());
            });
            SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)requestProducer);
            UIUtil.invokeLaterIfNeeded(() -> DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT));
        }
    }

    public void showDiffWithLocal(@NotNull VirtualFile root, @Nullable FilePath revisionPath, @NotNull Hash revisionHash, @NotNull FilePath localPath) {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(4);
        }
        if (revisionHash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(5);
        }
        if (localPath == null) {
            GitLogDiffHandler.$$$reportNull$$$0(6);
        }
        if (localPath.isDirectory()) {
            this.showDiffForPaths(root, Collections.singleton(localPath), revisionHash, null);
        } else {
            DiffRequestProducer requestProducer = SimpleDiffRequestProducer.create((FilePath)localPath, () -> {
                DiffContent leftDiffContent = this.createDiffContent(root, revisionPath, revisionHash);
                DiffContent rightDiffContent = this.createCurrentDiffContent(localPath);
                return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)revisionPath, (FilePath)localPath, (String)" -> "), leftDiffContent, rightDiffContent, revisionHash.asString(), GitBundle.message("git.log.diff.handler.local.version.content.title", new Object[0]));
            });
            SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)requestProducer);
            UIUtil.invokeLaterIfNeeded(() -> DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT));
        }
    }

    public void showDiffForPaths(@NotNull VirtualFile root, @Nullable Collection<FilePath> affectedPaths, @NotNull Hash leftRevision, @Nullable Hash rightRevision) {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(7);
        }
        if (leftRevision == null) {
            GitLogDiffHandler.$$$reportNull$$$0(8);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            boolean isWithLocal = rightRevision == null;
            Set<FilePath> filePaths = affectedPaths != null ? affectedPaths : Collections.singleton(VcsUtil.getFilePath((VirtualFile)root));
            String leftRevisionTitle = leftRevision.toShortString();
            String rightRevisionTitle = isWithLocal ? GitBundle.message("git.log.diff.handler.local.version.name", new Object[0]) : rightRevision.toShortString();
            String dialogTitle = affectedPaths != null ? GitBundle.message("git.log.diff.handler.changes.between.revisions.in.paths.title", leftRevisionTitle, rightRevisionTitle, GitLogDiffHandler.getTitleForPaths(root, affectedPaths)) : GitBundle.message("git.log.diff.handler.changes.between.revisions.title", leftRevisionTitle, rightRevisionTitle);
            CompareWithLocalDialog.LocalContent localContentSide = isWithLocal ? CompareWithLocalDialog.LocalContent.AFTER : CompareWithLocalDialog.LocalContent.NONE;
            CompareWithLocalDialog.showChanges((Project)this.myProject, (String)dialogTitle, (CompareWithLocalDialog.LocalContent)localContentSide, () -> {
                if (isWithLocal) {
                    return GitChangeUtils.getDiffWithWorkingDir(this.myProject, root, leftRevision.asString(), filePaths, false);
                }
                return GitChangeUtils.getDiff(this.myProject, root, leftRevision.asString(), rightRevision.asString(), filePaths);
            });
        });
    }

    @NotNull
    private static String getTitleForPaths(@NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths) {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(9);
        }
        if (filePaths == null) {
            GitLogDiffHandler.$$$reportNull$$$0(10);
        }
        String joinedPaths = StringUtil.join(filePaths, path -> VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path), (String)", ");
        String string = StringUtil.shortenTextWithEllipsis((String)joinedPaths, (int)100, (int)0);
        if (string == null) {
            GitLogDiffHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private DiffContent createCurrentDiffContent(@NotNull FilePath localPath) throws VcsException {
        GitSubmodule submodule;
        if (localPath == null) {
            GitLogDiffHandler.$$$reportNull$$$0(12);
        }
        if ((submodule = GitContentRevision.getRepositoryIfSubmodule(this.myProject, localPath)) != null) {
            ContentRevision revision = GitSubmoduleContentRevision.createCurrentRevision(submodule.getRepository());
            String content2 = revision.getContent();
            Object object = content2 != null ? this.myDiffContentFactory.create(this.myProject, content2) : this.myDiffContentFactory.createEmpty();
            if (object == null) {
                GitLogDiffHandler.$$$reportNull$$$0(13);
            }
            return object;
        }
        VirtualFile file = localPath.getVirtualFile();
        LOG.assertTrue(file != null);
        DiffContent diffContent = this.myDiffContentFactory.create(this.myProject, file);
        if (diffContent == null) {
            GitLogDiffHandler.$$$reportNull$$$0(14);
        }
        return diffContent;
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull VirtualFile root, @Nullable FilePath path, @NotNull Hash hash) throws VcsException {
        EmptyContent diffContent;
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(15);
        }
        if (hash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(16);
        }
        GitRevisionNumber revisionNumber = new GitRevisionNumber(hash.asString());
        if (path == null) {
            diffContent = new EmptyContent();
        } else {
            GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(this.myProject, path);
            if (submodule != null) {
                ContentRevision revision = GitSubmoduleContentRevision.createRevision(submodule, (VcsRevisionNumber)revisionNumber);
                String content2 = revision.getContent();
                diffContent = content2 != null ? this.myDiffContentFactory.create(this.myProject, content2) : this.myDiffContentFactory.createEmpty();
            } else {
                try {
                    byte[] content3 = GitFileUtils.getFileContent(this.myProject, root, hash.asString(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path));
                    diffContent = this.myDiffContentFactory.createFromBytes(this.myProject, content3, path);
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
        }
        diffContent.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)new Pair((Object)path, (Object)revisionNumber));
        EmptyContent emptyContent = diffContent;
        if (emptyContent == null) {
            GitLogDiffHandler.$$$reportNull$$$0(17);
        }
        return emptyContent;
    }

    @NotNull
    public ContentRevision createContentRevision(@NotNull FilePath filePath, @NotNull Hash hash) {
        if (filePath == null) {
            GitLogDiffHandler.$$$reportNull$$$0(18);
        }
        if (hash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(19);
        }
        GitRevisionNumber revisionNumber = new GitRevisionNumber(hash.asString());
        ContentRevision contentRevision = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)revisionNumber, this.myProject);
        if (contentRevision == null) {
            GitLogDiffHandler.$$$reportNull$$$0(20);
        }
        return contentRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftHash";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightHash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionHash";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftRevision";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitLogDiffHandler";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitLogDiffHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForPaths";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCurrentDiffContent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showDiffWithLocal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDiffForPaths";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTitleForPaths";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCurrentDiffContent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createContentRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

