/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitSingleCommitEditingAction;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUncommitAction
extends GitSingleCommitEditingAction {
    private static final Logger LOG = Logger.getInstance(GitUncommitAction.class);

    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        if (e == null) {
            GitUncommitAction.$$$reportNull$$$0(0);
        }
        if (commitEditingData == null) {
            GitUncommitAction.$$$reportNull$$$0(1);
        }
        if (e.getPresentation().isEnabledAndVisible()) {
            VcsLogUi logUi2 = commitEditingData.getLogUi();
            DataPackBase dataPackBase = ((VisiblePack)logUi2.getDataPack()).getDataPack();
            if (!(dataPackBase instanceof DataPack)) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(false);
                return;
            }
            if (commitEditingData.isHeadCommit()) {
                e.getPresentation().setEnabled(true);
            } else {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message("git.undo.action.description", new Object[0]));
            }
        }
    }

    @Override
    public void actionPerformedAfterChecks(@NotNull GitSingleCommitEditingAction.SingleCommitEditingData commitEditingData) {
        LocalChangeList targetList;
        if (commitEditingData == null) {
            GitUncommitAction.$$$reportNull$$$0(2);
        }
        Project project = commitEditingData.getProject();
        VcsShortCommitDetails commit = commitEditingData.getSelectedCommit();
        if (ChangeListManager.getInstance((Project)project).areChangeListsEnabled()) {
            ChangeListChooser chooser = new ChangeListChooser(project, GitBundle.message("git.undo.action.select.target.changelist.title", new Object[0]));
            chooser.setSuggestedName(commit.getSubject());
            if (!chooser.showAndGet()) {
                return;
            }
            targetList = chooser.getSelectedList();
        } else {
            targetList = null;
        }
        GitUncommitAction.resetInBackground(commitEditingData.getLogData(), commitEditingData.getRepository(), commit, targetList);
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.message("git.undo.action.cant.undo.commit.failure", new Object[0]);
        if (string == null) {
            GitUncommitAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void resetInBackground(final @NotNull VcsLogData data, final @NotNull GitRepository repository, final @NotNull VcsShortCommitDetails commit, final @Nullable LocalChangeList targetChangeList) {
        if (data == null) {
            GitUncommitAction.$$$reportNull$$$0(4);
        }
        if (repository == null) {
            GitUncommitAction.$$$reportNull$$$0(5);
        }
        if (commit == null) {
            GitUncommitAction.$$$reportNull$$$0(6);
        }
        final Project project = repository.getProject();
        new Task.Backgroundable(project, GitBundle.message("git.undo.action.undoing.last.commit.process", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection<Change> changesInCommit;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    changesInCommit = GitUncommitAction.getChangesInCommit(data, commit);
                }
                catch (VcsException e) {
                    String message = GitBundle.message("git.undo.action.could.not.load.changes.of.commit", ((Hash)commit.getId()).asString());
                    LOG.warn(message, (Throwable)e);
                    VcsNotifier.getInstance((Project)project).notifyError("git.could.not.load.changes.of.commit", "", message);
                    return;
                }
                new GitResetOperation(project, Collections.singletonMap(repository, (Hash)commit.getParents().get(0)), GitResetMode.SOFT, indicator).execute();
                if (targetChangeList != null) {
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    changeListManager.invokeAfterUpdateWithModal(true, GitBundle.message("git.undo.action.refreshing.changes.process", new Object[0]), () -> {
                        Collection<Change> changes = GitUtil.findCorrespondentLocalChanges(changeListManager, changesInCommit);
                        changeListManager.moveChangesTo(targetChangeList, changes.toArray(new Change[0]));
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/reset/GitUncommitAction$1", "run"));
            }
        }.queue();
    }

    @NotNull
    private static Collection<Change> getChangesInCommit(@NotNull VcsLogData data, @NotNull VcsShortCommitDetails commit) throws VcsException {
        VirtualFile root;
        Hash hash;
        VcsFullCommitDetails details;
        if (data == null) {
            GitUncommitAction.$$$reportNull$$$0(7);
        }
        if (commit == null) {
            GitUncommitAction.$$$reportNull$$$0(8);
        }
        if ((details = GitUncommitAction.getChangesFromCache(data, hash = (Hash)commit.getId(), root = commit.getRoot())) == null) {
            details = VcsLogUtil.getDetails((VcsLogData)data, (VirtualFile)root, (Hash)hash);
        }
        Collection collection = details.getChanges();
        if (collection == null) {
            GitUncommitAction.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Nullable
    private static VcsFullCommitDetails getChangesFromCache(@NotNull VcsLogData data, @NotNull Hash hash, @NotNull VirtualFile root) {
        if (data == null) {
            GitUncommitAction.$$$reportNull$$$0(10);
        }
        if (hash == null) {
            GitUncommitAction.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitUncommitAction.$$$reportNull$$$0(12);
        }
        Ref details = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> details.set((Object)((VcsFullCommitDetails)data.getCommitDetailsGetter().getCommitDataIfAvailable(data.getCommitIndex(hash, root)))));
        if (details.isNull() || details.get() instanceof LoadingDetails) {
            return null;
        }
        return (VcsFullCommitDetails)details.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitEditingData";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/reset/GitUncommitAction";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/reset/GitUncommitAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailureTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesInCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedAfterChecks";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetInBackground";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getChangesInCommit";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getChangesFromCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

