/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchCheckoutOperation;
import git4idea.update.GitUpdateExecutionProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0003\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\bH\u0001\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a$\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\bH\u0000\u001a$\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a,\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0000\u00a8\u0006\u0016"}, d2={"createOrCheckoutNewBranch", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "startPoint", "", "title", "initialName", "hasRemotes", "", "hasTrackingConflicts", "conflictingLocalBranches", "", "Lgit4idea/GitLocalBranch;", "remoteBranchName", "isTrackingInfosExist", "branchNames", "updateBranches", "localBranchNames", "intellij.vcs.git"})
public final class GitBranchActionsUtilKt {
    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nullable String initialName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        GitNewBranchOptions gitNewBranchOptions = new GitNewBranchDialog(project, repositories, title, initialName, true, true, false, true, null, 256, null).showAndGetOptions();
        if (gitNewBranchOptions == null) {
            return;
        }
        GitNewBranchOptions options = gitNewBranchOptions;
        new GitBranchCheckoutOperation(project, repositories).perform(startPoint, options);
    }

    public static /* synthetic */ void createOrCheckoutNewBranch$default(Project project, List list2, String string, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            String string4 = GitBundle.message("branches.create.new.branch.dialog.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"GitBundle.message(\"branc\u2026new.branch.dialog.title\")");
            string2 = string4;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        GitBranchActionsUtilKt.createOrCheckoutNewBranch(project, list2, string, string2, string3);
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title) {
        GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project, repositories, startPoint, title, null, 16, null);
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint) {
        GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project, repositories, startPoint, null, null, 24, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateBranches(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull List<String> localBranchNames) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(localBranchNames, (String)"localBranchNames");
        Iterable $this$associateWith$iv = repositories;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void it;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Collection<GitBranchTrackInfo> collection = it.getBranchTrackInfos();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"it.branchTrackInfos");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                GitBranchTrackInfo info = (GitBranchTrackInfo)element$iv$iv2;
                boolean bl2 = false;
                GitBranchTrackInfo gitBranchTrackInfo = info;
                Intrinsics.checkNotNullExpressionValue((Object)gitBranchTrackInfo, (String)"info");
                GitLocalBranch gitLocalBranch = gitBranchTrackInfo.getLocalBranch();
                Intrinsics.checkNotNullExpressionValue((Object)gitLocalBranch, (String)"info.localBranch");
                if (!localBranchNames.contains(gitLocalBranch.getName())) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list2 = (List)destination$iv$iv;
            map2.put(t, list2);
        }
        Map repoToTrackingInfos = result$iv;
        if (repoToTrackingInfos.isEmpty()) {
            return;
        }
        GitVcs.runInBackground(new Task.Backgroundable(project, repoToTrackingInfos, repositories, project, GitBundle.message("branches.updating.process", new Object[0]), true){
            private final ArrayList<String> successfullyUpdated;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map $repoToTrackingInfos;
            final /* synthetic */ List $repositories;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"GitFetchSupport.fetchSupport(project)");
                GitFetchSupport fetchSupport = gitFetchSupport;
                Map currentBranchesMap = new HashMap<K, V>();
                Object object2 = this.$repoToTrackingInfos;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = object2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void repo;
                    Object object3 = object = iterator.next();
                    boolean bl2 = false;
                    object2 = (GitRepository)object3.getKey();
                    object3 = object;
                    bl2 = false;
                    List trackingInfos = (List)object3.getValue();
                    GitLocalBranch currentBranch = repo.getCurrentBranch();
                    Iterator<E> iterator2 = trackingInfos.iterator();
                    while (iterator2.hasNext()) {
                        GitFetchResult fetchResult;
                        String localBranchName;
                        String remoteBranchName;
                        GitRemoteBranch remoteBranch;
                        GitLocalBranch localBranch;
                        GitBranchTrackInfo trackingInfo;
                        GitBranchTrackInfo gitBranchTrackInfo = trackingInfo = (GitBranchTrackInfo)iterator2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)gitBranchTrackInfo, (String)"trackingInfo");
                        Intrinsics.checkNotNullExpressionValue((Object)gitBranchTrackInfo.getLocalBranch(), (String)"trackingInfo.localBranch");
                        Intrinsics.checkNotNullExpressionValue((Object)trackingInfo.getRemoteBranch(), (String)"trackingInfo.remoteBranch");
                        if (Intrinsics.areEqual((Object)localBranch, (Object)currentBranch)) {
                            currentBranchesMap.put(repo, new GitBranchPair(currentBranch, remoteBranch));
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)localBranch.getName(), (String)"localBranch.name");
                        Intrinsics.checkNotNullExpressionValue((Object)remoteBranch.getNameForRemoteOperations(), (String)"remoteBranch.nameForRemoteOperations");
                        Intrinsics.checkNotNullExpressionValue((Object)fetchSupport.fetch((GitRepository)repo, trackingInfo.getRemote(), remoteBranchName + ':' + localBranchName), (String)"fetchSupport.fetch(repo,\u2026chName:$localBranchName\")");
                        try {
                            fetchResult.throwExceptionIfFailed();
                            this.successfullyUpdated.add(localBranchName);
                        }
                        catch (VcsException ignored) {
                            fetchResult.showNotificationIfFailed(GitBundle.message("branches.update.failed", new Object[0]));
                        }
                    }
                }
                object = currentBranchesMap;
                boolean bl3 = false;
                if (!object.isEmpty()) {
                    Collection collection = this.$repositories;
                    GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcsSettings), (String)"GitVcsSettings.getInstance(project)");
                    UpdateMethod updateMethod = gitVcsSettings.getUpdateMethod();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)updateMethod), (String)"GitVcsSettings.getInstance(project).updateMethod");
                    new GitUpdateExecutionProcess(this.$project, collection, currentBranchesMap, updateMethod, false).execute();
                }
            }

            public void onSuccess() {
                Collection collection = this.successfullyUpdated;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    VcsNotifier.getInstance((Project)this.$project).notifySuccess("git.branches.update.successful", "", GitBundle.message("branches.selected.branches.updated.title", this.successfullyUpdated.size(), CollectionsKt.joinToString$default((Iterable)this.successfullyUpdated, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$repoToTrackingInfos = $captured_local_variable$1;
                this.$repositories = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                boolean bl = false;
                this.successfullyUpdated = new ArrayList<E>();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isTrackingInfosExist(@NotNull List<String> branchNames, @NotNull List<? extends GitRepository> repositories) {
        boolean bl;
        block8: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(branchNames, (String)"branchNames");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Iterable $this$flatMap$iv = repositories;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GitRepository p1 = (GitRepository)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = p1.getBranchTrackInfos();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block7: {
                        GitBranchTrackInfo trackingBranchInfo = (GitBranchTrackInfo)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = branchNames;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String branchName = (String)element$iv2;
                                boolean bl5 = false;
                                GitBranchTrackInfo gitBranchTrackInfo = trackingBranchInfo;
                                Intrinsics.checkNotNullExpressionValue((Object)gitBranchTrackInfo, (String)"trackingBranchInfo");
                                GitLocalBranch gitLocalBranch = gitBranchTrackInfo.getLocalBranch();
                                Intrinsics.checkNotNullExpressionValue((Object)gitLocalBranch, (String)"trackingBranchInfo.localBranch");
                                if (!Intrinsics.areEqual((Object)branchName, (Object)gitLocalBranch.getName())) continue;
                                bl3 = true;
                                break block7;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasRemotes(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection<GitRepository> collection = GitUtil.getRepositories(project);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"GitUtil.getRepositories(project)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository repository = (GitRepository)element$iv;
                    boolean bl2 = false;
                    GitRepository gitRepository = repository;
                    Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"repository");
                    if (!(!gitRepository.getRemotes().isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasTrackingConflicts(@NotNull Map<GitRepository, ? extends GitLocalBranch> conflictingLocalBranches, @NotNull String remoteBranchName) {
        boolean bl;
        Intrinsics.checkNotNullParameter(conflictingLocalBranches, (String)"conflictingLocalBranches");
        Intrinsics.checkNotNullParameter((Object)remoteBranchName, (String)"remoteBranchName");
        Map<GitRepository, ? extends GitLocalBranch> $this$any$iv = conflictingLocalBranches;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Map<GitRepository, ? extends GitLocalBranch> map2 = $this$any$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<GitRepository, ? extends GitLocalBranch>> iterator = map2.entrySet().iterator();
        do {
            void repo;
            Map.Entry<GitRepository, ? extends GitLocalBranch> element$iv;
            if (!iterator.hasNext()) return false;
            Map.Entry<GitRepository, ? extends GitLocalBranch> $dstr$repo$branch = element$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry<GitRepository, ? extends GitLocalBranch> entry = $dstr$repo$branch;
            boolean bl4 = false;
            GitRepository gitRepository = entry.getKey();
            entry = $dstr$repo$branch;
            bl4 = false;
            GitLocalBranch branch = entry.getValue();
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch((GitRepository)repo, branch);
            if (trackInfo != null) {
                GitRemoteBranch gitRemoteBranch = trackInfo.getRemoteBranch();
                Intrinsics.checkNotNullExpressionValue((Object)gitRemoteBranch, (String)"trackInfo.remoteBranch");
                if (!GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)gitRemoteBranch.getName())) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

