/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="StructuralSearchPlugin", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ConfigurationManager
implements PersistentStateComponent<Element> {
    private static final int MAX_RECENT_SIZE = 30;
    @NonNls
    private static final String SEARCH_TAG_NAME = "searchConfiguration";
    @NonNls
    private static final String REPLACE_TAG_NAME = "replaceConfiguration";
    @NonNls
    private static final String SAVE_HISTORY_ATTR_NAME = "history";
    private final List<Configuration> configurations = new SmartList();
    private final List<Configuration> historyConfigurations = new SmartList();
    private final ConfigurationManagerState myApplicationState;
    private final Project myProject;

    public static ConfigurationManager getInstance(@NotNull Project project) {
        if (project == null) {
            ConfigurationManager.$$$reportNull$$$0(0);
        }
        return (ConfigurationManager)project.getService(ConfigurationManager.class);
    }

    public ConfigurationManager(Project project) {
        this.myProject = project;
        this.myApplicationState = ConfigurationManagerState.getInstance();
    }

    public Element getState() {
        Element state = new Element("state");
        ConfigurationManager.writeConfigurations(state, this.configurations, this.historyConfigurations);
        return state;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(1);
        }
        this.configurations.clear();
        this.historyConfigurations.clear();
        SmartList tmp = new SmartList();
        ConfigurationManager.readConfigurations(element, this.configurations, (Collection<? super Configuration>)tmp);
        this.migrate(this.configurations);
        for (Configuration configuration : tmp) {
            configuration.getMatchOptions().initScope(this.myProject);
            this.addHistoryConfiguration(configuration);
        }
        Collections.reverse(this.historyConfigurations);
    }

    private void migrate(@NotNull List<? extends Configuration> configurations) {
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(2);
        }
        if (configurations.isEmpty()) {
            return;
        }
        block0: for (Configuration configuration : configurations) {
            Configuration existing = this.myApplicationState.get(configuration.getRefName());
            while (existing != null) {
                if (configuration.equals(existing)) continue block0;
                configuration.setName(configuration.getName() + "~");
                existing = this.myApplicationState.get(configuration.getRefName());
            }
            this.myApplicationState.add(configuration);
        }
    }

    public void addHistoryConfiguration(@NotNull Configuration configuration) {
        Configuration old;
        if (configuration == null) {
            ConfigurationManager.$$$reportNull$$$0(3);
        }
        if ((configuration = configuration.copy()).getCreated() <= 0L) {
            configuration.setCreated(System.currentTimeMillis());
        }
        if ((old = ConfigurationManager.findConfiguration(this.historyConfigurations, configuration)) != null) {
            this.historyConfigurations.remove(old);
        }
        this.historyConfigurations.add(0, configuration);
        while (this.historyConfigurations.size() > 30) {
            this.historyConfigurations.remove(this.historyConfigurations.size() - 1);
        }
    }

    public Configuration getMostRecentConfiguration() {
        return this.historyConfigurations.isEmpty() ? null : this.historyConfigurations.get(0);
    }

    @TestOnly
    public void addConfiguration(Configuration configuration) {
        this.myApplicationState.add(configuration);
    }

    public void removeConfiguration(Configuration configuration) {
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            this.myApplicationState.remove(configuration.getRefName());
        }
        this.configurations.remove(configuration);
    }

    public static void writeConfigurations(@NotNull Element element, @NotNull Collection<? extends Configuration> configurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(4);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(5);
        }
        ConfigurationManager.writeConfigurations(element, configurations, Collections.emptyList());
    }

    private static void writeConfigurations(@NotNull Element element, @NotNull Collection<? extends Configuration> configurations, @NotNull Collection<? extends Configuration> historyConfigurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(6);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(7);
        }
        if (historyConfigurations == null) {
            ConfigurationManager.$$$reportNull$$$0(8);
        }
        for (Configuration configuration : configurations) {
            configuration.getMatchOptions().setScope(null);
            ConfigurationManager.saveConfiguration(element, configuration);
        }
        for (Configuration configuration : historyConfigurations) {
            Element infoElement = ConfigurationManager.saveConfiguration(element, configuration);
            infoElement.setAttribute(SAVE_HISTORY_ATTR_NAME, "1");
        }
    }

    @NotNull
    private static Element saveConfiguration(@NotNull Element element, @NotNull Configuration config) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(9);
        }
        if (config == null) {
            ConfigurationManager.$$$reportNull$$$0(10);
        }
        Element infoElement = new Element(config instanceof SearchConfiguration ? SEARCH_TAG_NAME : REPLACE_TAG_NAME);
        element.addContent(infoElement);
        config.writeExternal(infoElement);
        Element element2 = infoElement;
        if (element2 == null) {
            ConfigurationManager.$$$reportNull$$$0(11);
        }
        return element2;
    }

    public static void readConfigurations(@NotNull Element element, @NotNull Collection<? super Configuration> configurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(12);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(13);
        }
        ConfigurationManager.readConfigurations(element, configurations, (Collection<? super Configuration>)new SmartList());
    }

    private static void readConfigurations(@NotNull Element element, @NotNull Collection<? super Configuration> configurations, @NotNull Collection<? super Configuration> historyConfigurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(14);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(15);
        }
        if (historyConfigurations == null) {
            ConfigurationManager.$$$reportNull$$$0(16);
        }
        for (Element pattern : element.getChildren()) {
            Configuration config = ConfigurationManager.readConfiguration(pattern);
            if (config == null) continue;
            if (pattern.getAttribute(SAVE_HISTORY_ATTR_NAME) != null) {
                historyConfigurations.add(config);
                continue;
            }
            configurations.add(config);
        }
    }

    private static Configuration readConfiguration(@NotNull Element element) {
        Configuration config;
        String name;
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(17);
        }
        if ((name = element.getName()).equals(SEARCH_TAG_NAME)) {
            config = new SearchConfiguration();
        } else if (name.equals(REPLACE_TAG_NAME)) {
            config = new ReplaceConfiguration();
        } else {
            return null;
        }
        ((Configuration)config).readExternal(element);
        return config;
    }

    public List<String> getAllConfigurationNames() {
        Stream<Configuration> stream = Stream.concat(StructuralSearchUtil.getPredefinedTemplates().stream(), this.getConfigurations().stream());
        return stream.map(c -> c.getRefName()).collect(Collectors.toList());
    }

    public List<Configuration> getAllConfigurations() {
        Stream<Configuration> stream = Stream.concat(StructuralSearchUtil.getPredefinedTemplates().stream(), this.getConfigurations().stream());
        return stream.collect(Collectors.toList());
    }

    @NotNull
    public Collection<Configuration> getConfigurations() {
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            Collection<Configuration> collection = this.myApplicationState.getAll();
            if (collection == null) {
                ConfigurationManager.$$$reportNull$$$0(18);
            }
            return collection;
        }
        List<Configuration> list = Collections.unmodifiableList(this.configurations);
        if (list == null) {
            ConfigurationManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    public Configuration findConfigurationByName(String name) {
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            Configuration ideConfiguration = this.myApplicationState.get(name);
            if (ideConfiguration != null) {
                return ideConfiguration;
            }
        } else {
            Configuration configuration = ConfigurationManager.findConfigurationByName(this.configurations, name);
            if (configuration != null) {
                return configuration;
            }
        }
        return ConfigurationManager.findConfigurationByName(StructuralSearchUtil.getPredefinedTemplates(), name);
    }

    @Nullable
    private static Configuration findConfigurationByName(Collection<? extends Configuration> configurations, String name) {
        return (Configuration)ContainerUtil.find(configurations, config -> config.getRefName().equals(name));
    }

    @Nullable
    private static Configuration findConfiguration(@NotNull Collection<? extends Configuration> configurations, Configuration configuration) {
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(20);
        }
        return (Configuration)ContainerUtil.find(configurations, c -> {
            if (configuration instanceof ReplaceConfiguration) {
                return c instanceof ReplaceConfiguration && c.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern()) && c.getReplaceOptions().getReplacement().equals(configuration.getReplaceOptions().getReplacement());
            }
            return c instanceof SearchConfiguration && c.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern());
        });
    }

    @NotNull
    public List<Configuration> getHistoryConfigurations() {
        List<Configuration> list = Collections.unmodifiableList(this.historyConfigurations);
        if (list == null) {
            ConfigurationManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    public boolean showSaveTemplateAsDialog(@NotNull Configuration newConfiguration) {
        if (newConfiguration == null) {
            ConfigurationManager.$$$reportNull$$$0(22);
        }
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            return ConfigurationManager.showSaveTemplateAsDialog(newConfiguration, this.myProject, n -> this.myApplicationState.get((String)n) != null, c -> {
                this.myApplicationState.add((Configuration)c);
                this.configurations.remove(c);
                this.configurations.add((Configuration)c);
            });
        }
        return ConfigurationManager.showSaveTemplateAsDialog(this.configurations, newConfiguration, this.myProject);
    }

    public static boolean showSaveTemplateAsDialog(@NotNull Configuration newConfiguration, @NotNull Project project, @NotNull Predicate<? super String> nameExistsPredicate, @NotNull Consumer<? super Configuration> namedConfigurationConsumer) {
        int answer;
        if (newConfiguration == null) {
            ConfigurationManager.$$$reportNull$$$0(23);
        }
        if (project == null) {
            ConfigurationManager.$$$reportNull$$$0(24);
        }
        if (nameExistsPredicate == null) {
            ConfigurationManager.$$$reportNull$$$0(25);
        }
        if (namedConfigurationConsumer == null) {
            ConfigurationManager.$$$reportNull$$$0(26);
        }
        String name = ConfigurationManager.showInputDialog(newConfiguration.getName(), project);
        while (name != null && nameExistsPredicate.test(name) && (answer = Messages.showYesNoDialog((Project)project, (String)SSRBundle.message("overwrite.message", new Object[0]), (String)SSRBundle.message("overwrite.title", name), (String)SSRBundle.message("button.replace", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon())) != 0) {
            name = ConfigurationManager.showInputDialog(name, project);
        }
        if (name != null) {
            newConfiguration.setName(name);
            newConfiguration.setUuid(null);
            namedConfigurationConsumer.accept(newConfiguration.copy());
            return true;
        }
        return false;
    }

    public static boolean showSaveTemplateAsDialog(@NotNull Collection<Configuration> configurations, @NotNull Configuration newConfiguration, @NotNull Project project) {
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(27);
        }
        if (newConfiguration == null) {
            ConfigurationManager.$$$reportNull$$$0(28);
        }
        if (project == null) {
            ConfigurationManager.$$$reportNull$$$0(29);
        }
        return ConfigurationManager.showSaveTemplateAsDialog(newConfiguration, project, n -> ConfigurationManager.findConfigurationByName(configurations, n) != null, c -> {
            configurations.remove(c);
            configurations.add((Configuration)c);
        });
    }

    @Nullable
    @NlsSafe
    private static String showInputDialog(@NotNull String initial, @NotNull Project project) {
        if (initial == null) {
            ConfigurationManager.$$$reportNull$$$0(30);
        }
        if (project == null) {
            ConfigurationManager.$$$reportNull$$$0(31);
        }
        return Messages.showInputDialog((Project)project, (String)SSRBundle.message("template.name.button", new Object[0]), (String)SSRBundle.message("save.template.description.button", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)initial, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyConfigurations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ConfigurationManager";
                break;
            }
            case 22: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfiguration";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExistsPredicate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedConfigurationConsumer";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ConfigurationManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "saveConfiguration";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addHistoryConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeConfigurations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveConfiguration";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readConfigurations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readConfiguration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findConfiguration";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showSaveTemplateAsDialog";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showInputDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="StructuralSearch", storages={@Storage(value="structuralSearch.xml")}, category=SettingsCategory.CODE)
    private static class ConfigurationManagerState
    implements PersistentStateComponent<Element> {
        public final Map<String, Configuration> configurations = new LinkedHashMap<String, Configuration>();

        private ConfigurationManagerState() {
        }

        public static ConfigurationManagerState getInstance() {
            return (ConfigurationManagerState)ApplicationManager.getApplication().getService(ConfigurationManagerState.class);
        }

        public static ConfigurationManagerState getInstance(Project project) {
            return (ConfigurationManagerState)project.getService(ConfigurationManagerState.class);
        }

        public void add(Configuration configuration) {
            configuration.getMatchOptions().setScope(null);
            this.configurations.put(configuration.getRefName(), configuration);
        }

        public Configuration get(String name) {
            return this.configurations.get(name);
        }

        public void remove(String name) {
            this.configurations.remove(name);
        }

        public Collection<Configuration> getAll() {
            return Collections.unmodifiableCollection(this.configurations.values());
        }

        @Nullable
        public Element getState() {
            Element element = new Element("state");
            for (Configuration configuration : this.configurations.values()) {
                ConfigurationManager.saveConfiguration(element, configuration);
            }
            return element;
        }

        public void loadState(@NotNull Element state) {
            if (state == null) {
                ConfigurationManagerState.$$$reportNull$$$0(0);
            }
            for (Element child : state.getChildren()) {
                Configuration configuration = ConfigurationManager.readConfiguration(child);
                if (configuration == null) continue;
                this.configurations.put(configuration.getRefName(), configuration);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager$ConfigurationManagerState", "loadState"));
        }
    }
}

