/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class StructuralSearchUsageTarget
implements ConfigurableUsageTarget,
ItemPresentation {
    private final Configuration myConfiguration;
    private final Runnable mySearchStarter;
    private final SearchContext mySearchContext;

    StructuralSearchUsageTarget(@NotNull Configuration configuration, @NotNull SearchContext searchContext, @NotNull Runnable searchStarter) {
        if (configuration == null) {
            StructuralSearchUsageTarget.$$$reportNull$$$0(0);
        }
        if (searchContext == null) {
            StructuralSearchUsageTarget.$$$reportNull$$$0(1);
        }
        if (searchStarter == null) {
            StructuralSearchUsageTarget.$$$reportNull$$$0(2);
        }
        this.myConfiguration = configuration;
        this.mySearchStarter = searchStarter;
        this.mySearchContext = searchContext;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myConfiguration.getMatchOptions().getSearchPattern();
        if (string == null) {
            StructuralSearchUsageTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIcon(boolean unused) {
        return null;
    }

    public void findUsages() {
        this.mySearchStarter.run();
    }

    public boolean isValid() {
        return true;
    }

    public String getName() {
        return "my name";
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    public void navigate(boolean requestFocus) {
        throw new UnsupportedOperationException();
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void showSettings() {
        UIUtil.invokeAction(this.myConfiguration, this.mySearchContext);
    }

    public KeyboardShortcut getShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(this.myConfiguration instanceof ReplaceConfiguration ? "StructuralSearchPlugin.StructuralReplaceAction" : "StructuralSearchPlugin.StructuralSearchAction");
    }

    @Nls
    @NotNull
    public String getLongDescriptiveName() {
        String result;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        String pattern = matchOptions.getSearchPattern();
        SearchScope scope = matchOptions.getScope();
        assert (scope != null);
        String scopeString = scope.getDisplayName();
        if (this.myConfiguration instanceof ReplaceConfiguration) {
            ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)this.myConfiguration;
            String replacement = replaceConfiguration.getReplaceOptions().getReplacement();
            result = SSRBundle.message("replace.occurrences.of.0.with.1.in.2", pattern, replacement, scopeString);
        } else {
            result = SSRBundle.message("occurrences.of.0.in.1", pattern, scopeString);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)result, (int)150, (int)0, (boolean)true);
        if (string == null) {
            StructuralSearchUsageTarget.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchStarter";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchUsageTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchUsageTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescriptiveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

