/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.internal.impldep.org.apache.ivy.osgi.p2.XMLInputParser;
import org.gradle.internal.impldep.org.apache.ivy.osgi.util.DelegetingHandler;
import org.gradle.internal.impldep.org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P2CompositeParser
implements XMLInputParser {
    private Set childLocations = new LinkedHashSet();

    public Set getChildLocations() {
        return this.childLocations;
    }

    public void parse(InputStream in) throws ParseException, IOException, SAXException {
        RepositoryHandler handler = new RepositoryHandler();
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        this.childLocations.addAll(handler.childLocations);
    }

    static class ChildHandler
    extends DelegetingHandler {
        private static final String CHILD = "child";
        private static final String LOCATION = "location";
        String location;

        public ChildHandler() {
            super(CHILD);
        }

        protected void handleAttributes(Attributes atts) {
            this.location = atts.getValue(LOCATION);
        }
    }

    static class ChildrenHandler
    extends DelegetingHandler {
        private static final String CHILDREN = "children";
        private static final String SIZE = "size";
        List childLocations;

        public ChildrenHandler() {
            super(CHILDREN);
            this.addChild(new ChildHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    ChildrenHandler.this.childLocations.add(((ChildHandler)child).location);
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.childLocations = new ArrayList(size);
        }
    }

    static class RepositoryHandler
    extends DelegetingHandler {
        private static final String REPOSITORY = "repository";
        List childLocations;

        public RepositoryHandler() {
            super(REPOSITORY);
            this.addChild(new ChildrenHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    RepositoryHandler.this.childLocations = ((ChildrenHandler)child).childLocations;
                }
            });
        }
    }
}

