/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.data;

import com.jetbrains.packagesearch.api.v2.ApiRepository;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.RepositoryDeclaration;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.KnownRepositories;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.ModuleModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryUsageInfo;
import com.jetbrains.packagesearch.intellij.plugin.util.LogExtensionsKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0000\u001a\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u001a\u001a\u0010\u000f\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00100\u00032\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"allKnownRepositoryModels", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$All;", "allModules", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/ModuleModel;", "knownRepositoriesRemoteInfo", "Lcom/jetbrains/packagesearch/api/v2/ApiRepository;", "areEquivalentUrls", "", "first", "", "second", "tryParsingAsURI", "Ljava/net/URI;", "rawValue", "anyMatches", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/RepositoryDeclaration;", "remoteInfo", "intellij.packageSearch"})
public final class RepositoryMoldeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KnownRepositories.All allKnownRepositoryModels(@NotNull List<ModuleModel> allModules, @NotNull List<ApiRepository> knownRepositoriesRemoteInfo) {
        Collection<RepositoryModel> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(allModules, (String)"allModules");
        Intrinsics.checkNotNullParameter(knownRepositoriesRemoteInfo, (String)"knownRepositoriesRemoteInfo");
        Iterable $this$map$iv = knownRepositoriesRemoteInfo;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            ModuleModel module;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void remoteInfo;
            ApiRepository apiRepository = (ApiRepository)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String url = remoteInfo.getUrl();
            String id = remoteInfo.getId();
            Iterable iterable2 = allModules;
            String string = url;
            String string2 = remoteInfo.getFriendlyName();
            String string3 = id;
            boolean $i$f$filter = false;
            void var20_18 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                module = (ModuleModel)element$iv$iv;
                boolean bl2 = false;
                if (!RepositoryMoldeUtilsKt.anyMatches(module.getDeclaredRepositories(), (ApiRepository)remoteInfo)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection<RepositoryUsageInfo> collection2 = (List)destination$iv$iv2;
            $this$filter$iv = collection2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                module = (ModuleModel)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl3 = false;
                RepositoryUsageInfo repositoryUsageInfo = new RepositoryUsageInfo(module.getProjectModule());
                collection2.add(repositoryUsageInfo);
            }
            collection2 = (List)destination$iv$iv2;
            void var33_29 = remoteInfo;
            Collection<RepositoryUsageInfo> collection3 = collection2;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            RepositoryModel repositoryModel = new RepositoryModel(string6, string5, string4, (List<RepositoryUsageInfo>)collection3, (ApiRepository)var33_29);
            collection.add(repositoryModel);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        return new KnownRepositories.All(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean anyMatches(List<RepositoryDeclaration> $this$anyMatches, ApiRepository remoteInfo) {
        boolean bl;
        List list = remoteInfo.getAlternateUrls();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List urls = CollectionsKt.plus((Collection)list, (Object)remoteInfo.getUrl());
        String id = remoteInfo.getId();
        if (urls.isEmpty() && StringsKt.isBlank((CharSequence)id)) {
            return false;
        }
        Iterable $this$any$iv = $this$anyMatches;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            boolean bl2;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            RepositoryDeclaration declaredRepo = (RepositoryDeclaration)element$iv;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)declaredRepo.getId(), (Object)id)) return true;
            Iterable $this$any$iv2 = urls;
            boolean $i$f$any2 = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv2 : $this$any$iv2) {
                    String knownRepoUrl = (String)element$iv2;
                    boolean bl4 = false;
                    if (!RepositoryMoldeUtilsKt.areEquivalentUrls(declaredRepo.getUrl(), knownRepoUrl)) continue;
                    return true;
                }
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean areEquivalentUrls(String first, String second) {
        if (first == null || second == null) {
            return false;
        }
        URI uRI = RepositoryMoldeUtilsKt.tryParsingAsURI(first);
        if (uRI == null) {
            return false;
        }
        URI firstUri = uRI;
        URI uRI2 = RepositoryMoldeUtilsKt.tryParsingAsURI(second);
        if (uRI2 == null) {
            return false;
        }
        URI secondUri = uRI2;
        return Intrinsics.areEqual((Object)firstUri.normalize(), (Object)secondUri.normalize());
    }

    private static final URI tryParsingAsURI(String rawValue) {
        Object object;
        try {
            object = rawValue;
            boolean bl = false;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = new URI(StringsKt.trimEnd((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (char[])new char[]{'/', '?', '#'}));
        }
        catch (Exception e) {
            LogExtensionsKt.logInfo("PackageSearchDataService#tryParsingAsURI", (Function0<String>)((Function0)new Function0<String>(rawValue){
                final /* synthetic */ String $rawValue;

                @NotNull
                public final String invoke() {
                    return "Unable to parse URI: '" + this.$rawValue + '\'';
                }
                {
                    this.$rawValue = string;
                    super(0);
                }
            }));
            object = null;
        }
        return object;
    }
}

