/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUIKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.DependencyUsageInfo;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.KnownRepositories;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.OperationExecutor;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageIdentifier;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageScope;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.TargetModules;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.UiPackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperation;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperationFactory;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.versions.NormalizedPackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTable;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTableItem;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTableModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.ActionsColumn;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.NameColumn;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.ScopeColumn;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.VersionColumn;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.IntScalingExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.JComponentExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.util.LogExtensionsKt;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001cBA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012*\u0010\b\u001a&\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fJ,\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020\u00132\f\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u00152\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015H\u0002J\u000e\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020HJ \u0010I\u001a\u00020\r2\u0016\u0010J\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030L0\u00150KH\u0002J\u001a\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020\u00132\u0006\u0010P\u001a\u00020\u0013H\u0016J\u0018\u0010Q\u001a\u00020R2\u0006\u0010O\u001a\u00020\u00132\u0006\u0010P\u001a\u00020\u0013H\u0016J\u0012\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020VH\u0016J\u000e\u0010W\u001a\b\u0012\u0002\b\u0003\u0018\u00010XH\u0002J\u0010\u0010Y\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020[H\u0016J\u0010\u0010]\u001a\u00020\r2\u0006\u0010Z\u001a\u00020[H\u0016J\u001c\u0010^\u001a\u00020\r2\n\u0010_\u001a\u0006\u0012\u0002\b\u0003002\u0006\u0010`\u001a\u00020\fH\u0002J \u0010a\u001a\u00020\r2\n\u0010_\u001a\u0006\u0012\u0002\b\u0003002\n\u0010b\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010*\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u001a\"\u0004\b,\u0010-R\u001d\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u0001000/\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u00109\u001a\b\u0012\u0004\u0012\u00020\r0:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable;", "Lcom/intellij/ui/table/JBTable;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "operationExecutor", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/OperationExecutor;", "onSearchResultStateChanged", "Lkotlin/Function3;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel$SearchResult;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/versions/NormalizedPackageVersion;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageScope;", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/SearchResultStateChangeListener;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/OperationExecutor;Lkotlin/jvm/functions/Function3;)V", "actionsColumn", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/ActionsColumn;", "actionsColumnIndex", "", "autosizingColumnsIndices", "", "columnWeights", "", "firstPackageIndex", "getFirstPackageIndex", "()I", "hasInstalledItems", "", "getHasInstalledItems", "()Z", "knownRepositoriesInTargetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;", "listSelectionListener", "Ljavax/swing/event/ListSelectionListener;", "nameColumn", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/NameColumn;", "operationFactory", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperationFactory;", "scopeColumn", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/ScopeColumn;", "value", "selectedIndex", "getSelectedIndex", "setSelectedIndex", "(I)V", "selectedPackageStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/UiPackageModel;", "getSelectedPackageStateFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "tableModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableModel;", "getTableModel", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableModel;", "targetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;", "transferFocusUp", "Lkotlin/Function0;", "getTransferFocusUp", "()Lkotlin/jvm/functions/Function0;", "setTransferFocusUp", "(Lkotlin/jvm/functions/Function0;)V", "versionColumn", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/VersionColumn;", "applyColumnSizes", "tW", "columns", "Ljavax/swing/table/TableColumn;", "weights", "display", "viewModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel;", "executeActionColumnOperations", "operations", "Lkotlinx/coroutines/Deferred;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "getCellEditor", "Ljavax/swing/table/TableCellEditor;", "row", "column", "getCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "getData", "", "dataId", "", "getSelectedTableItem", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableItem;", "isCopyEnabled", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "performCopy", "updatePackageScope", "uiPackageModel", "newScope", "updatePackageVersion", "newVersion", "ViewModel", "intellij.packageSearch"})
public final class PackagesTable
extends JBTable
implements CopyProvider,
DataProvider {
    private final PackageSearchOperationFactory operationFactory;
    @NotNull
    private Function0<Unit> transferFocusUp;
    private final List<Float> columnWeights;
    private final NameColumn nameColumn;
    private final ScopeColumn scopeColumn;
    private final VersionColumn versionColumn;
    private final ActionsColumn actionsColumn;
    private final int actionsColumnIndex;
    private final List<Integer> autosizingColumnsIndices;
    private TargetModules targetModules;
    private KnownRepositories.InTargetModules knownRepositoriesInTargetModules;
    @NotNull
    private final MutableStateFlow<UiPackageModel<?>> selectedPackageStateFlow;
    private final ListSelectionListener listSelectionListener;
    private final Project project;
    private final OperationExecutor operationExecutor;
    private final Function3<PackageModel.SearchResult, NormalizedPackageVersion<?>, PackageScope, Unit> onSearchResultStateChanged;

    private final PackagesTableModel getTableModel() {
        TableModel tableModel = this.getModel();
        if (tableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTableModel");
        }
        return (PackagesTableModel)((Object)tableModel);
    }

    @NotNull
    public final Function0<Unit> getTransferFocusUp() {
        return this.transferFocusUp;
    }

    public final void setTransferFocusUp(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.transferFocusUp = function0;
    }

    @NotNull
    public final MutableStateFlow<UiPackageModel<?>> getSelectedPackageStateFlow() {
        return this.selectedPackageStateFlow;
    }

    public final boolean getHasInstalledItems() {
        boolean bl;
        block3: {
            List list = this.getTableModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tableModel.items");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PackagesTableItem it = (PackagesTableItem)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PackagesTableItem.InstalledPackage)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final int getFirstPackageIndex() {
        int n;
        block2: {
            List list = this.getTableModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tableModel.items");
            List $this$indexOfFirst$iv = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                PackagesTableItem it = (PackagesTableItem)item$iv;
                boolean bl = false;
                if (it instanceof PackagesTableItem.InstalledPackage) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public final int getSelectedIndex() {
        return this.getSelectedRow();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setSelectedIndex(int value) {
        List list = this.getTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tableModel.items");
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty()) {
            List list2 = this.getTableModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"tableModel.items");
            collection = list2;
            bl = false;
            if (RangesKt.until((int)0, (int)collection.size()).contains(value)) {
                this.setRowSelectionInterval(value, value);
                return;
            }
        }
        this.clearSelection();
    }

    @NotNull
    public TableCellRenderer getCellRenderer(int row, int column) {
        Object object = (ColumnInfo)ArraysKt.getOrNull((Object[])this.getTableModel().getColumns(), (int)column);
        if (object == null || (object = object.getRenderer(this.getTableModel().getItems().get(row))) == null) {
            object = new DefaultTableCellRenderer();
        }
        return object;
    }

    @Nullable
    public TableCellEditor getCellEditor(int row, int column) {
        ColumnInfo columnInfo = (ColumnInfo)ArraysKt.getOrNull((Object[])this.getTableModel().getColumns(), (int)column);
        return columnInfo != null ? columnInfo.getEditor(this.getTableModel().getItems().get(row)) : null;
    }

    public final void display(@NotNull ViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.knownRepositoriesInTargetModules = viewModel.getKnownRepositoriesInTargetModules();
        this.targetModules = viewModel.getTargetModules();
        this.versionColumn.updateData(viewModel.getOnlyStable(), viewModel.getTargetModules());
        this.actionsColumn.updateData(viewModel.getOnlyStable(), viewModel.getTargetModules(), viewModel.getKnownRepositoriesInTargetModules());
        this.selectionModel.removeListSelectionListener(this.listSelectionListener);
        this.getTableModel().setItems(viewModel.getItems());
        this.selectionModel.addListSelectionListener(this.listSelectionListener);
        PackageSearchUIKt.updateAndRepaint((JComponent)((Object)this));
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this : null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            PackagesTableItem<?> packagesTableItem = this.getSelectedTableItem();
            if (packagesTableItem == null) break block0;
            packagesTableItem.performCopy(dataContext);
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        PackagesTableItem<?> packagesTableItem = this.getSelectedTableItem();
        return packagesTableItem != null ? packagesTableItem.isCopyEnabled(dataContext) : false;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        PackagesTableItem<?> packagesTableItem = this.getSelectedTableItem();
        return packagesTableItem != null ? packagesTableItem.isCopyVisible(dataContext) : false;
    }

    private final PackagesTableItem<?> getSelectedTableItem() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        Object object = this.getTableModel().getValueAt(this.getSelectedIndex(), 0);
        if (!(object instanceof PackagesTableItem)) {
            object = null;
        }
        return (PackagesTableItem)object;
    }

    private final void updatePackageScope(UiPackageModel<?> uiPackageModel, PackageScope newScope) {
        block1: {
            UiPackageModel<?> uiPackageModel2;
            block0: {
                uiPackageModel2 = uiPackageModel;
                if (!(uiPackageModel2 instanceof UiPackageModel.Installed)) break block0;
                List<PackageSearchOperation<?>> operations = this.operationFactory.createChangePackageScopeOperations(((UiPackageModel.Installed)uiPackageModel).getPackageModel(), newScope, this.targetModules, null);
                LogExtensionsKt.logDebug("PackagesTable#updatePackageScope()", (Function0<String>)((Function0)new Function0<String>(uiPackageModel, newScope, operations){
                    final /* synthetic */ UiPackageModel $uiPackageModel;
                    final /* synthetic */ PackageScope $newScope;
                    final /* synthetic */ List $operations;

                    @NotNull
                    public final String invoke() {
                        return "The user has selected a new scope for " + PackageIdentifier.toString-impl(this.$uiPackageModel.getIdentifier-f1q_7Ec()) + ": '" + this.$newScope + "'. This resulted in " + this.$operations.size() + " operation(s).";
                    }
                    {
                        this.$uiPackageModel = uiPackageModel;
                        this.$newScope = packageScope;
                        this.$operations = list;
                        super(0);
                    }
                }));
                this.operationExecutor.executeOperations(operations);
                break block1;
            }
            if (!(uiPackageModel2 instanceof UiPackageModel.SearchResult)) break block1;
            NormalizedPackageVersion<?> selectedVersion = uiPackageModel.getSelectedVersion();
            this.onSearchResultStateChanged.invoke((Object)((UiPackageModel.SearchResult)uiPackageModel).getPackageModel(), selectedVersion, (Object)newScope);
            LogExtensionsKt.logDebug("PackagesTable#updatePackageScope()", (Function0<String>)((Function0)new Function0<String>(uiPackageModel, newScope){
                final /* synthetic */ UiPackageModel $uiPackageModel;
                final /* synthetic */ PackageScope $newScope;

                @NotNull
                public final String invoke() {
                    return "The user has selected a new scope for search result " + PackageIdentifier.toString-impl(this.$uiPackageModel.getIdentifier-f1q_7Ec()) + ": '" + this.$newScope + "'.";
                }
                {
                    this.$uiPackageModel = uiPackageModel;
                    this.$newScope = packageScope;
                    super(0);
                }
            }));
            PackageSearchUIKt.updateAndRepaint((JComponent)((Object)this));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePackageVersion(UiPackageModel<?> uiPackageModel, NormalizedPackageVersion<?> newVersion) {
        block2: {
            UiPackageModel<?> uiPackageModel2;
            block1: {
                void $this$flatMapTo$iv$iv;
                uiPackageModel2 = uiPackageModel;
                if (!(uiPackageModel2 instanceof UiPackageModel.Installed)) break block1;
                Iterable $this$flatMap$iv = ((UiPackageModel.Installed)uiPackageModel).getPackageModel().getUsageInfo();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    DependencyUsageInfo it = (DependencyUsageInfo)element$iv$iv;
                    boolean bl = false;
                    RepositoryModel repoToInstall = this.knownRepositoriesInTargetModules.repositoryToAddWhenInstallingOrUpgrading(this.project, ((UiPackageModel.Installed)uiPackageModel).getPackageModel(), (PackageVersion)newVersion.getOriginalVersion());
                    Iterable list$iv$iv = this.operationFactory.createChangePackageVersionOperations(((UiPackageModel.Installed)uiPackageModel).getPackageModel(), (PackageVersion)newVersion.getOriginalVersion(), this.targetModules, repoToInstall);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List operations = (List)destination$iv$iv;
                LogExtensionsKt.logDebug("PackagesTable#updatePackageVersion()", (Function0<String>)((Function0)new Function0<String>(uiPackageModel, newVersion, operations){
                    final /* synthetic */ UiPackageModel $uiPackageModel;
                    final /* synthetic */ NormalizedPackageVersion $newVersion;
                    final /* synthetic */ List $operations;

                    @NotNull
                    public final String invoke() {
                        return "The user has selected a new version for " + PackageIdentifier.toString-impl(this.$uiPackageModel.getIdentifier-f1q_7Ec()) + ": '" + this.$newVersion + "'. " + "This resulted in " + this.$operations.size() + " operation(s).";
                    }
                    {
                        this.$uiPackageModel = uiPackageModel;
                        this.$newVersion = normalizedPackageVersion;
                        this.$operations = list;
                        super(0);
                    }
                }));
                this.operationExecutor.executeOperations(operations);
                break block2;
            }
            if (!(uiPackageModel2 instanceof UiPackageModel.SearchResult)) break block2;
            this.onSearchResultStateChanged.invoke((Object)((UiPackageModel.SearchResult)uiPackageModel).getPackageModel(), newVersion, (Object)uiPackageModel.getSelectedScope());
            LogExtensionsKt.logDebug("PackagesTable#updatePackageVersion()", (Function0<String>)((Function0)new Function0<String>(uiPackageModel, newVersion){
                final /* synthetic */ UiPackageModel $uiPackageModel;
                final /* synthetic */ NormalizedPackageVersion $newVersion;

                @NotNull
                public final String invoke() {
                    return "The user has selected a new version for search result " + PackageIdentifier.toString-impl(this.$uiPackageModel.getIdentifier-f1q_7Ec()) + ": '" + this.$newVersion + "'.";
                }
                {
                    this.$uiPackageModel = uiPackageModel;
                    this.$newVersion = normalizedPackageVersion;
                    super(0);
                }
            }));
            PackageSearchUIKt.updateAndRepaint((JComponent)((Object)this));
        }
    }

    private final void executeActionColumnOperations(Deferred<? extends List<? extends PackageSearchOperation<?>>> operations) {
        LogExtensionsKt.logDebug("PackagesTable#executeActionColumnOperations()", (Function0<String>)((Function0)executeActionColumnOperations.1.INSTANCE));
        this.operationExecutor.executeOperations(operations);
    }

    private final void applyColumnSizes(int tW, List<? extends TableColumn> columns2, List<Float> weights) {
        boolean bl = this.columnWeights.size() == columns2.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Column weights count != columns count! We have " + columns2.size() + " columns, " + this.columnWeights.size() + " weights";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        for (TableColumn tableColumn : columns2) {
            tableColumn.setPreferredWidth(MathKt.roundToInt((float)(((Number)weights.get(tableColumn.getModelIndex())).floatValue() * (float)tW)));
        }
    }

    public PackagesTable(@NotNull Project project, @NotNull OperationExecutor operationExecutor, @NotNull Function3<? super PackageModel.SearchResult, ? super NormalizedPackageVersion<?>, ? super PackageScope, Unit> onSearchResultStateChanged2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)operationExecutor, (String)"operationExecutor");
        Intrinsics.checkNotNullParameter(onSearchResultStateChanged2, (String)"onSearchResultStateChanged");
        this.project = project;
        this.operationExecutor = operationExecutor;
        this.onSearchResultStateChanged = onSearchResultStateChanged2;
        this.operationFactory = new PackageSearchOperationFactory();
        this.transferFocusUp = (Function0)new Function0<Unit>(this){
            final /* synthetic */ PackagesTable this$0;

            public final void invoke() {
                this.this$0.transferFocusBackward();
            }
            {
                this.this$0 = packagesTable2;
                super(0);
            }
        };
        this.columnWeights = CollectionsKt.listOf((Object[])new Float[]{Float.valueOf(0.5f), Float.valueOf(0.2f), Float.valueOf(0.2f), Float.valueOf(0.1f)});
        this.nameColumn = new NameColumn();
        this.scopeColumn = new ScopeColumn((Function2)new Function2<UiPackageModel<?>, PackageScope, Unit>(this){
            final /* synthetic */ PackagesTable this$0;

            public final void invoke(@NotNull UiPackageModel<?> packageModel, @NotNull PackageScope newScope) {
                Intrinsics.checkNotNullParameter(packageModel, (String)"packageModel");
                Intrinsics.checkNotNullParameter((Object)newScope, (String)"newScope");
                PackagesTable.access$updatePackageScope(this.this$0, packageModel, newScope);
            }
            {
                this.this$0 = packagesTable2;
                super(2);
            }
        });
        this.versionColumn = new VersionColumn((Function2)new Function2<UiPackageModel<?>, NormalizedPackageVersion<?>, Unit>(this){
            final /* synthetic */ PackagesTable this$0;

            public final void invoke(@NotNull UiPackageModel<?> packageModel, @NotNull NormalizedPackageVersion<?> newVersion) {
                Intrinsics.checkNotNullParameter(packageModel, (String)"packageModel");
                Intrinsics.checkNotNullParameter(newVersion, (String)"newVersion");
                PackagesTable.access$updatePackageVersion(this.this$0, packageModel, newVersion);
            }
            {
                this.this$0 = packagesTable2;
                super(2);
            }
        });
        this.actionsColumn = new ActionsColumn(this.project, (Function1)new Function1<Deferred<? extends List<? extends PackageSearchOperation<?>>>, Unit>(this){

            public final void invoke(@NotNull Deferred<? extends List<? extends PackageSearchOperation<?>>> p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                PackagesTable.access$executeActionColumnOperations((PackagesTable)((Object)this.receiver), p1);
            }
        });
        this.targetModules = TargetModules.None.INSTANCE;
        this.knownRepositoriesInTargetModules = KnownRepositories.InTargetModules.Companion.getEMPTY();
        this.selectedPackageStateFlow = StateFlowKt.MutableStateFlow(null);
        this.listSelectionListener = new ListSelectionListener(this){
            final /* synthetic */ PackagesTable this$0;

            public final void valueChanged(ListSelectionEvent it) {
                PackagesTableItem item = PackagesTable.access$getSelectedTableItem(this.this$0);
                if (this.this$0.getSelectedIndex() >= 0 && item != null) {
                    TableUtil.scrollSelectionToVisible((JTable)((JTable)((Object)this.this$0)));
                    PackageSearchUIKt.updateAndRepaint((JComponent)((Object)this.this$0));
                    this.this$0.getSelectedPackageStateFlow().tryEmit(item.getUiPackageModel());
                } else {
                    this.this$0.getSelectedPackageStateFlow().tryEmit(null);
                }
            }
            {
                this.this$0 = packagesTable2;
            }
        };
        boolean bl = CollectionsKt.sumOfFloat((Iterable)this.columnWeights) == 1.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The column weights must sum to 1.0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.setModel((TableModel)((Object)new PackagesTableModel(this.nameColumn, this.scopeColumn, this.versionColumn, this.actionsColumn)));
        Object[] columnInfos = this.getTableModel().getColumnInfos();
        Intrinsics.checkNotNullExpressionValue((Object)columnInfos, (String)"columnInfos");
        this.actionsColumnIndex = ArraysKt.indexOf((Object[])columnInfos, (Object)((Object)this.actionsColumn));
        this.autosizingColumnsIndices = CollectionsKt.listOf((Object[])new Integer[]{ArraysKt.indexOf((Object[])columnInfos, (Object)((Object)this.scopeColumn)), ArraysKt.indexOf((Object[])columnInfos, (Object)((Object)this.versionColumn)), this.actionsColumnIndex});
        this.setTableHeader((JTableHeader)new JBTable.InvisibleResizableHeader((JBTable)this));
        JTableHeader jTableHeader = this.getTableHeader();
        bl3 = false;
        boolean bl5 = false;
        JTableHeader $this$apply = jTableHeader;
        boolean bl6 = false;
        $this$apply.setReorderingAllowed(false);
        $this$apply.setResizingAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        this.rowHeight = IntScalingExtensionsKt.scaled(20);
        this.setBackground(UIUtil.getTableBackground());
        this.setForeground(UIUtil.getTableForeground());
        this.selectionBackground = UIUtil.getTableSelectionBackground((boolean)true);
        this.selectionForeground = UIUtil.getTableSelectionForeground((boolean)true);
        this.setExpandableItemsEnabled(false);
        ListSelectionModel listSelectionModel = this.selectionModel;
        Intrinsics.checkNotNullExpressionValue((Object)listSelectionModel, (String)"selectionModel");
        listSelectionModel.setSelectionMode(0);
        this.putClientProperty("terminateEditOnFocusLost", true);
        this.setIntercellSpacing(new Dimension(0, 2));
        this.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        this.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                if (this.getTableModel().getRowCount() > 0) {
                    int[] nArray = this.getSelectedRows();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"selectedRows");
                    int[] nArray2 = nArray;
                    boolean bl = false;
                    if (nArray2.length == 0) {
                        this.setRowSelectionInterval(0, 0);
                    }
                }
            }
        });
        PackageSearchUI.INSTANCE.overrideKeyStroke$intellij_packageSearch((JComponent)((Object)this), "jtable:RIGHT", "RIGHT", (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.transferFocus();
            }
        }));
        PackageSearchUI.INSTANCE.overrideKeyStroke$intellij_packageSearch((JComponent)((Object)this), "jtable:ENTER", "ENTER", (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.transferFocus();
            }
        }));
        PackageSearchUI.INSTANCE.overrideKeyStroke$intellij_packageSearch((JComponent)((Object)this), "shift ENTER", (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.clearSelection();
                this.getTransferFocusUp().invoke();
            }
        }));
        this.selectionModel.addListSelectionListener(this.listSelectionListener);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                if (this.getSelectedIndex() == -1) {
                    this.setSelectedIndex(this.getFirstPackageIndex());
                }
            }
        });
        jTableHeader = new TableSpeedSearch((JTable)((Object)this), (PairFunction)8.INSTANCE);
        bl3 = false;
        bl5 = false;
        $this$apply = jTableHeader;
        boolean bl7 = false;
        $this$apply.setComparator(new SpeedSearchComparator(false));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                TableColumnModel tableColumnModel = columnModel;
                Intrinsics.checkNotNullExpressionValue((Object)tableColumnModel, (String)"columnModel");
                int n = tableColumnModel.getTotalColumnWidth();
                TableColumnModel tableColumnModel2 = columnModel;
                Intrinsics.checkNotNullExpressionValue((Object)tableColumnModel2, (String)"columnModel");
                Enumeration<TableColumn> enumeration = tableColumnModel2.getColumns();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"columnModel.columns");
                Enumeration<TableColumn> enumeration2 = enumeration;
                boolean bl = false;
                ArrayList<TableColumn> arrayList = Collections.list(enumeration2);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                this.applyColumnSizes(n, arrayList, columnWeights);
                this.removeComponentListener(this);
            }
        });
        JComponentExtensionsKt.onMouseMotion$default((JComponent)((Object)this), (Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent mouseEvent) {
                Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
                Point point = mouseEvent.getPoint();
                int hoverColumn = this.columnAtPoint(point);
                int hoverRow = this.rowAtPoint(point);
                if (this.getTableModel().getItems().isEmpty() || hoverRow < 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                boolean isHoveringActionsColumn = hoverColumn == actionsColumnIndex;
                this.setCursor(isHoveringActionsColumn ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
            }
        }, null, 2, null);
    }

    public static final /* synthetic */ void access$updatePackageScope(PackagesTable $this, UiPackageModel uiPackageModel, PackageScope newScope) {
        $this.updatePackageScope(uiPackageModel, newScope);
    }

    public static final /* synthetic */ void access$updatePackageVersion(PackagesTable $this, UiPackageModel uiPackageModel, NormalizedPackageVersion newVersion) {
        $this.updatePackageVersion(uiPackageModel, newVersion);
    }

    public static final /* synthetic */ void access$executeActionColumnOperations(PackagesTable $this, Deferred operations) {
        $this.executeActionColumnOperations(operations);
    }

    public static final /* synthetic */ PackagesTableItem access$getSelectedTableItem(PackagesTable $this) {
        return $this.getSelectedTableItem();
    }

    public static final /* synthetic */ void access$setColumnModel$p(PackagesTable $this, TableColumnModel tableColumnModel) {
        $this.columnModel = tableColumnModel;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel;", "", "items", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel$TableItems;", "onlyStable", "", "targetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;", "knownRepositoriesInTargetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;", "(Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel$TableItems;ZLcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;)V", "getItems", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel$TableItems;", "getKnownRepositoriesInTargetModules", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;", "getOnlyStable", "()Z", "getTargetModules", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "TableItems", "intellij.packageSearch"})
    public static final class ViewModel {
        @NotNull
        private final TableItems items;
        private final boolean onlyStable;
        @NotNull
        private final TargetModules targetModules;
        @NotNull
        private final KnownRepositories.InTargetModules knownRepositoriesInTargetModules;

        @NotNull
        public final TableItems getItems() {
            return this.items;
        }

        public final boolean getOnlyStable() {
            return this.onlyStable;
        }

        @NotNull
        public final TargetModules getTargetModules() {
            return this.targetModules;
        }

        @NotNull
        public final KnownRepositories.InTargetModules getKnownRepositoriesInTargetModules() {
            return this.knownRepositoriesInTargetModules;
        }

        public ViewModel(@NotNull TableItems items, boolean onlyStable, @NotNull TargetModules targetModules, @NotNull KnownRepositories.InTargetModules knownRepositoriesInTargetModules) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)targetModules, (String)"targetModules");
            Intrinsics.checkNotNullParameter((Object)knownRepositoriesInTargetModules, (String)"knownRepositoriesInTargetModules");
            this.items = items;
            this.onlyStable = onlyStable;
            this.targetModules = targetModules;
            this.knownRepositoriesInTargetModules = knownRepositoriesInTargetModules;
        }

        @NotNull
        public final TableItems component1() {
            return this.items;
        }

        public final boolean component2() {
            return this.onlyStable;
        }

        @NotNull
        public final TargetModules component3() {
            return this.targetModules;
        }

        @NotNull
        public final KnownRepositories.InTargetModules component4() {
            return this.knownRepositoriesInTargetModules;
        }

        @NotNull
        public final ViewModel copy(@NotNull TableItems items, boolean onlyStable, @NotNull TargetModules targetModules, @NotNull KnownRepositories.InTargetModules knownRepositoriesInTargetModules) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)targetModules, (String)"targetModules");
            Intrinsics.checkNotNullParameter((Object)knownRepositoriesInTargetModules, (String)"knownRepositoriesInTargetModules");
            return new ViewModel(items, onlyStable, targetModules, knownRepositoriesInTargetModules);
        }

        public static /* synthetic */ ViewModel copy$default(ViewModel viewModel, TableItems tableItems, boolean bl, TargetModules targetModules, KnownRepositories.InTargetModules inTargetModules, int n, Object object) {
            if ((n & 1) != 0) {
                tableItems = viewModel.items;
            }
            if ((n & 2) != 0) {
                bl = viewModel.onlyStable;
            }
            if ((n & 4) != 0) {
                targetModules = viewModel.targetModules;
            }
            if ((n & 8) != 0) {
                inTargetModules = viewModel.knownRepositoriesInTargetModules;
            }
            return viewModel.copy(tableItems, bl, targetModules, inTargetModules);
        }

        @NotNull
        public String toString() {
            return "ViewModel(items=" + this.items + ", onlyStable=" + this.onlyStable + ", targetModules=" + this.targetModules + ", knownRepositoriesInTargetModules=" + this.knownRepositoriesInTargetModules + ")";
        }

        public int hashCode() {
            TableItems tableItems = this.items;
            int n = (tableItems != null ? ((Object)tableItems).hashCode() : 0) * 31;
            int n2 = this.onlyStable ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            TargetModules targetModules = this.targetModules;
            KnownRepositories.InTargetModules inTargetModules = this.knownRepositoriesInTargetModules;
            return ((n + n2) * 31 + (targetModules != null ? targetModules.hashCode() : 0)) * 31 + (inTargetModules != null ? ((Object)inTargetModules).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ViewModel)) break block3;
                    ViewModel viewModel = (ViewModel)object;
                    if (!Intrinsics.areEqual((Object)this.items, (Object)viewModel.items) || this.onlyStable != viewModel.onlyStable || !Intrinsics.areEqual((Object)this.targetModules, (Object)viewModel.targetModules) || !Intrinsics.areEqual((Object)this.knownRepositoriesInTargetModules, (Object)viewModel.knownRepositoriesInTargetModules)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 %2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001%B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001H\u00c6\u0003J\u0015\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0096\u0003J\u001b\u0010\u000f\u001a\u00020\r2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0011H\u0096\u0001J\u001d\u0010\u0012\u001a\u00020\u00002\u0012\b\u0002\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\u0015\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0017\u001a\u00020\bH\u0096\u0003J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\u0015\u0010\u0019\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0096\u0001J\t\u0010\u001a\u001a\u00020\rH\u0096\u0001J\u0013\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001cH\u0096\u0003J\u0015\u0010\u001d\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0096\u0001J\u0013\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001fH\u0096\u0001J\u001b\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\bH\u0096\u0001J#\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0096\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel$TableItems;", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableItem;", "items", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "size", "", "getSize", "()I", "component1", "contains", "", "element", "containsAll", "elements", "", "copy", "equals", "other", "", "get", "index", "hashCode", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "toString", "", "Companion", "intellij.packageSearch"})
        public static final class TableItems
        implements List<PackagesTableItem<?>>,
        KMappedMarker {
            @NotNull
            private final List<PackagesTableItem<?>> items;
            @NotNull
            private static final TableItems EMPTY;
            @NotNull
            public static final Companion Companion;

            @NotNull
            public final List<PackagesTableItem<?>> getItems() {
                return this.items;
            }

            public TableItems(@NotNull List<? extends PackagesTableItem<?>> items) {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                this.items = items;
            }

            static {
                Companion = new Companion(null);
                EMPTY = new TableItems(CollectionsKt.emptyList());
            }

            public int getSize() {
                return this.items.size();
            }

            public boolean contains(@NotNull PackagesTableItem<?> element) {
                Intrinsics.checkNotNullParameter(element, (String)"element");
                return this.items.contains(element);
            }

            @Override
            public boolean containsAll(@NotNull Collection<? extends Object> elements) {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                return this.items.containsAll(elements);
            }

            @Override
            @NotNull
            public PackagesTableItem<?> get(int index2) {
                PackagesTableItem<?> packagesTableItem = this.items.get(index2);
                Intrinsics.checkNotNullExpressionValue(packagesTableItem, (String)"get(...)");
                return packagesTableItem;
            }

            public int indexOf(@NotNull PackagesTableItem<?> element) {
                Intrinsics.checkNotNullParameter(element, (String)"element");
                return this.items.indexOf(element);
            }

            @Override
            public boolean isEmpty() {
                return this.items.isEmpty();
            }

            @Override
            @NotNull
            public Iterator<PackagesTableItem<?>> iterator() {
                return this.items.iterator();
            }

            public int lastIndexOf(@NotNull PackagesTableItem<?> element) {
                Intrinsics.checkNotNullParameter(element, (String)"element");
                return this.items.lastIndexOf(element);
            }

            @Override
            @NotNull
            public ListIterator<PackagesTableItem<?>> listIterator() {
                return this.items.listIterator();
            }

            @Override
            @NotNull
            public ListIterator<PackagesTableItem<?>> listIterator(int index2) {
                return this.items.listIterator(index2);
            }

            @Override
            @NotNull
            public List<PackagesTableItem<?>> subList(int fromIndex, int toIndex) {
                return this.items.subList(fromIndex, toIndex);
            }

            @NotNull
            public final List<PackagesTableItem<?>> component1() {
                return this.items;
            }

            @NotNull
            public final TableItems copy(@NotNull List<? extends PackagesTableItem<?>> items) {
                Intrinsics.checkNotNullParameter(items, (String)"items");
                return new TableItems(items);
            }

            public static /* synthetic */ TableItems copy$default(TableItems tableItems, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = tableItems.items;
                }
                return tableItems.copy(list);
            }

            @NotNull
            public String toString() {
                return "TableItems(items=" + this.items + ")";
            }

            @Override
            public int hashCode() {
                List<PackagesTableItem<?>> list = this.items;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            @Override
            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof TableItems)) break block3;
                        TableItems tableItems = (TableItems)object;
                        if (!Intrinsics.areEqual(this.items, tableItems.items)) break block3;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean add(PackagesTableItem<?> packagesTableItem) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public void add(int n, PackagesTableItem<?> packagesTableItem) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public boolean addAll(int n, Collection<? extends PackagesTableItem<?>> collection) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public boolean addAll(Collection<? extends PackagesTableItem<?>> collection) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public boolean removeAll(Collection<? extends Object> collection) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public PackagesTableItem<?> remove(int n) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public void replaceAll(UnaryOperator<PackagesTableItem<?>> unaryOperator) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public boolean retainAll(Collection<? extends Object> collection) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public PackagesTableItem<?> set(int n, PackagesTableItem<?> packagesTableItem) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public void sort(Comparator<? super PackagesTableItem<?>> comparator) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public /* synthetic */ boolean add(Object object) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public /* synthetic */ void add(int n, Object object) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public /* synthetic */ Object remove(int n) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public /* synthetic */ Object set(int n, Object object) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            @Override
            public Object[] toArray() {
                return CollectionToArray.toArray((Collection)this);
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return CollectionToArray.toArray((Collection)this, (Object[])TArray);
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel$TableItems$Companion;", "", "()V", "EMPTY", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel$TableItems;", "getEMPTY", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTable$ViewModel$TableItems;", "intellij.packageSearch"})
            public static final class Companion {
                @NotNull
                public final TableItems getEMPTY() {
                    return EMPTY;
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

