/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.rdtext.impl;

import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.rdtext.impl.RdTextBuffer;
import com.jetbrains.rd.rdtext.impl.intrinsics.RdTextBufferChange;
import com.jetbrains.rd.rdtext.impl.intrinsics.RdTextBufferState;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rd.rdtext.intrinsics.TextBufferVersion;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0014J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rd/rdtext/impl/TextBufferTypingSession;", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "buffer", "Lcom/jetbrains/rd/rdtext/impl/RdTextBuffer;", "(Lcom/jetbrains/rd/rdtext/impl/RdTextBuffer;)V", "initialVersion", "Lcom/jetbrains/rd/rdtext/intrinsics/TextBufferVersion;", "isCommitting", "", "()Z", "localVersionToConfirmOrRollback", "", "onLocalChange", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnLocalChange", "()Lcom/jetbrains/rd/util/reactive/Signal;", "onRemoteChange", "getOnRemoteChange", "remoteChanges", "Lcom/jetbrains/rd/rdtext/impl/intrinsics/RdTextBufferChange;", "state", "Lcom/jetbrains/rd/rdtext/impl/TextBufferTypingSession$State;", "versionBeforeOpening", "finishCommitRemoteVersion", "", "rollbackRemoteVersion", "startCommitRemoteVersion", "tryPushLocalChange", "changeWithVersion", "tryPushRemoteChange", "State", "rd-text"})
public final class TextBufferTypingSession
implements ITypingSession<RdTextChange> {
    private final TextBufferVersion versionBeforeOpening;
    private State state;
    private final List<TextBufferVersion> localVersionToConfirmOrRollback;
    private final List<RdTextBufferChange> remoteChanges;
    private final TextBufferVersion initialVersion;
    @NotNull
    private final Signal<RdTextChange> onRemoteChange;
    @NotNull
    private final Signal<RdTextChange> onLocalChange;
    private final RdTextBuffer buffer;

    @Override
    @NotNull
    public Signal<RdTextChange> getOnRemoteChange() {
        return this.onRemoteChange;
    }

    @Override
    @NotNull
    public Signal<RdTextChange> getOnLocalChange() {
        return this.onLocalChange;
    }

    public final boolean isCommitting() {
        return this.state == State.Committing;
    }

    @Override
    public void startCommitRemoteVersion() {
        boolean bl = this.state == State.Opened;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.state = State.Committing;
    }

    @Override
    public void finishCommitRemoteVersion() {
        this.buffer.updateHistory$rd_text(this.initialVersion, this.localVersionToConfirmOrRollback, this.remoteChanges);
    }

    @Override
    public void rollbackRemoteVersion() {
        boolean bl = this.state == State.Opened;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.state = State.Closing;
        if (this.buffer.isMaster()) {
            this.buffer.promoteLocalVersion$rd_text();
        }
    }

    public final boolean tryPushLocalChange(@NotNull RdTextBufferChange changeWithVersion) {
        Intrinsics.checkNotNullParameter((Object)changeWithVersion, (String)"changeWithVersion");
        if (this.state != State.Opened) {
            return false;
        }
        RdTextChange change = changeWithVersion.getChange();
        boolean bl = RdTextChangeKt.isNormalChange(change);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "change.isNormalChange";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.getOnLocalChange().fire((Object)change);
        this.localVersionToConfirmOrRollback.add(changeWithVersion.getVersion());
        return true;
    }

    public final boolean tryPushRemoteChange(@NotNull RdTextBufferChange changeWithVersion) {
        Intrinsics.checkNotNullParameter((Object)changeWithVersion, (String)"changeWithVersion");
        if (this.state != State.Opened) {
            return false;
        }
        if (changeWithVersion.getVersion().compareTo(this.versionBeforeOpening) <= 0) {
            return false;
        }
        RdTextChange change = changeWithVersion.getChange();
        boolean bl = RdTextChangeKt.isNormalChange(change);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "change.isNormalChange";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.getOnRemoteChange().fire((Object)change);
        this.remoteChanges.add(changeWithVersion);
        return true;
    }

    public TextBufferTypingSession(@NotNull RdTextBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.state = State.Opened;
        boolean bl = false;
        this.localVersionToConfirmOrRollback = new ArrayList();
        bl = false;
        this.remoteChanges = new ArrayList();
        this.initialVersion = this.buffer.getBufferVersion();
        this.onRemoteChange = new Signal();
        this.onLocalChange = new Signal();
        if (this.buffer.isMaster()) {
            this.versionBeforeOpening = this.buffer.getBufferVersion();
            ((RdTextBufferState)this.buffer.getDelegatedBy()).getVersionBeforeTypingSession().set((Object)this.versionBeforeOpening);
        } else {
            this.versionBeforeOpening = (TextBufferVersion)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)((RdTextBufferState)this.buffer.getDelegatedBy()).getVersionBeforeTypingSession()));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/rdtext/impl/TextBufferTypingSession$State;", "", "(Ljava/lang/String;I)V", "Opened", "Committing", "Closing", "rd-text"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State Opened;
        public static final /* enum */ State Committing;
        public static final /* enum */ State Closing;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = Opened = new State();
            stateArray[1] = Committing = new State();
            stateArray[2] = Closing = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

