/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.security.asn1.ASN1Exception;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.DERCoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;

public class ASN1Util
implements Serializable {
    private static DERCoder derCoder = new DERCoder();

    public static ASN1Object fromByteArray(byte[] content) throws ASN1Exception {
        if (content == null || content.length == 0) {
            return null;
        }
        ASN1Object object = null;
        byte[] base64Decoded = CBBase64.decode(content);
        byte[] byteArray = base64Decoded != null ? base64Decoded : content;
        object = derCoder.decode(byteArray);
        return object;
    }

    public static ASN1Object fromFile(File f) throws IOException, ASN1Exception {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        byte[] buffer = new byte[(int)f.length()];
        String s = null;
        while ((s = reader.readLine()) != null && !s.startsWith("-----BEGIN")) {
        }
        if (s != null) {
            s = reader.readLine();
            int offset = 0;
            while (s != null) {
                byte[] temp = s.getBytes();
                System.arraycopy(temp, 0, buffer, offset, temp.length);
                offset += temp.length;
                s = reader.readLine();
                if (s == null) {
                    reader.close();
                    return null;
                }
                if (!s.startsWith("-----END")) continue;
                s = null;
            }
            reader.close();
            byte[] result = new byte[offset];
            System.arraycopy(buffer, 0, result, 0, offset);
            return ASN1Util.fromByteArray(result);
        }
        reader.close();
        FileInputStream in = new FileInputStream(f);
        in.read(buffer);
        in.close();
        return ASN1Util.fromByteArray(buffer);
    }

    public static byte[] toByteArrayDER(ASN1Object o) throws ASN1Exception {
        if (o.getByteArray() == null) {
            byte[] data = derCoder.encode(o);
            o.setByteArray(data);
            return data;
        }
        return o.getByteArray();
    }

    public static byte[] toByteArrayPEM(ASN1Object o) throws ASN1Exception {
        if (o.getByteArray() == null) {
            byte[] data = derCoder.encode(o);
            o.setByteArray(data);
            return CBBase64.encode(data);
        }
        return CBBase64.encode(o.getByteArray());
    }

    public static void saveDER(ASN1Object o, File file) throws IOException, ASN1Exception {
        byte[] data = ASN1Util.toByteArrayDER(o);
        FileOutputStream out = new FileOutputStream(file);
        out.write(data);
        out.close();
    }

    public static void savePEM(ASN1Object o, File file, String name) throws IOException, ASN1Exception {
        byte[] inPEM = ASN1Util.toByteArrayPEM(o);
        ASN1Util.savePEM(inPEM, file, name);
    }

    public static void savePEM(byte[] inPEM, File file, String name) throws IOException {
        String temp;
        int i;
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.print("-----BEGIN ");
        writer.print(name);
        writer.println("-----");
        for (i = 0; i < inPEM.length / 64; ++i) {
            temp = new String(inPEM, i * 64, 64);
            writer.println(temp);
        }
        if (inPEM.length != i * 64) {
            temp = new String(inPEM, i * 64, inPEM.length - i * 64);
            writer.println(temp);
        }
        writer.print("-----END ");
        writer.print(name);
        writer.println("-----");
        writer.close();
    }
}

