"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var portal_1 = require("../../../../../components/portal");
var tooltip_content_1 = require("./tooltip_content");
exports.AnnotationTooltip = function (_a) {
    var state = _a.state, chartRef = _a.chartRef, chartId = _a.chartId, onScroll = _a.onScroll;
    var _b, _c, _d, _e, _f, _g, _h;
    var renderTooltip = react_1.useCallback(function () {
        if (!state || !state.isVisible) {
            return null;
        }
        return react_1.default.createElement(tooltip_content_1.TooltipContent, __assign({}, state));
    }, [state]);
    var handleScroll = function () {
        if (onScroll) {
            onScroll();
        }
    };
    react_1.useEffect(function () {
        if (onScroll) {
            window.addEventListener('scroll', handleScroll, true);
            return function () { return window.removeEventListener('scroll', handleScroll, true); };
        }
    }, []);
    var popperSettings = react_1.useMemo(function () {
        var _a, _b, _c, _d;
        var settings = (_a = state) === null || _a === void 0 ? void 0 : _a.tooltipSettings;
        if (!settings) {
            return;
        }
        var placement = settings.placement, boundary = settings.boundary, rest = __rest(settings, ["placement", "boundary"]);
        return __assign(__assign({}, rest), { placement: (_d = (placement !== null && placement !== void 0 ? placement : (_c = (_b = state) === null || _b === void 0 ? void 0 : _b.anchor) === null || _c === void 0 ? void 0 : _c.position), (_d !== null && _d !== void 0 ? _d : portal_1.Placement.Right)), boundary: boundary === 'chart' && chartRef.current ? chartRef.current : undefined });
    }, [(_b = state) === null || _b === void 0 ? void 0 : _b.tooltipSettings, (_d = (_c = state) === null || _c === void 0 ? void 0 : _c.anchor) === null || _d === void 0 ? void 0 : _d.position, chartRef]);
    var position = react_1.useMemo(function () { var _a, _b; return _b = (_a = state) === null || _a === void 0 ? void 0 : _a.anchor, (_b !== null && _b !== void 0 ? _b : null); }, [(_e = state) === null || _e === void 0 ? void 0 : _e.anchor]);
    if (!((_f = state) === null || _f === void 0 ? void 0 : _f.isVisible)) {
        return null;
    }
    return (react_1.default.createElement(portal_1.TooltipPortal, { scope: "AnnotationTooltip", chartId: chartId, anchor: {
            position: position,
            ref: chartRef.current,
        }, visible: (_h = (_g = state) === null || _g === void 0 ? void 0 : _g.isVisible, (_h !== null && _h !== void 0 ? _h : false)), settings: popperSettings }, renderTooltip()));
};
//# sourceMappingURL=annotation_tooltip.js.map