/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.renderer.AbstractRenderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.process.CleanPaginatedBoxesStep;
import org.jfree.layouting.renderer.process.ComputeBreakabilityStep;
import org.jfree.layouting.renderer.process.ComputeICMMetricsStep;
import org.jfree.layouting.renderer.process.ComputeMarginsStep;
import org.jfree.layouting.renderer.process.ComputeStaticPropertiesStep;
import org.jfree.layouting.renderer.process.ComputeTableICMMetricsStep;
import org.jfree.layouting.renderer.process.FillPhysicalPagesStep;
import org.jfree.layouting.renderer.process.InfiniteMajorAxisLayoutStep;
import org.jfree.layouting.renderer.process.InfiniteMinorAxisLayoutStep;
import org.jfree.layouting.renderer.process.PaginationStep;
import org.jfree.layouting.renderer.process.ParagraphLineBreakStep;
import org.jfree.layouting.renderer.process.TableRowHeightStep;
import org.jfree.layouting.renderer.process.TableValidationStep;
import org.jfree.layouting.renderer.process.UpdateTokensStep;
import org.jfree.layouting.renderer.process.ValidateModelStep;

public class PaginatingRenderer
extends AbstractRenderer {
    private ValidateModelStep validateModelStep;
    private TableValidationStep tableValidationStep;
    private ComputeStaticPropertiesStep staticPropertiesStep;
    private ComputeMarginsStep marginsStep;
    private ComputeICMMetricsStep icmMetricsStep;
    private ComputeTableICMMetricsStep tableICMMetricsStep;
    private ParagraphLineBreakStep paragraphLinebreakStep;
    private InfiniteMinorAxisLayoutStep minorAxisLayoutStep;
    private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;
    private TableRowHeightStep tableRowHeightStep;
    private ComputeBreakabilityStep breakabilityStep;
    private PaginationStep paginationStep;
    private FillPhysicalPagesStep fillPhysicalPagesStep;
    private CleanPaginatedBoxesStep cleanPaginatedBoxesStep;
    private UpdateTokensStep updateTokensStep;

    protected PaginatingRenderer(LayoutProcess layoutProcess, boolean bl) {
        super(layoutProcess, bl);
        if (bl) {
            this.validateModelStep = new ValidateModelStep();
            this.staticPropertiesStep = new ComputeStaticPropertiesStep();
            this.tableValidationStep = new TableValidationStep();
            this.marginsStep = new ComputeMarginsStep();
            this.paragraphLinebreakStep = new ParagraphLineBreakStep();
            this.icmMetricsStep = new ComputeICMMetricsStep();
            this.tableICMMetricsStep = new ComputeTableICMMetricsStep();
            this.minorAxisLayoutStep = new InfiniteMinorAxisLayoutStep();
            this.majorAxisLayoutStep = new InfiniteMajorAxisLayoutStep();
            this.tableRowHeightStep = new TableRowHeightStep();
            this.breakabilityStep = new ComputeBreakabilityStep();
            this.paginationStep = new PaginationStep();
            this.fillPhysicalPagesStep = new FillPhysicalPagesStep();
            this.cleanPaginatedBoxesStep = new CleanPaginatedBoxesStep();
            this.updateTokensStep = new UpdateTokensStep();
        }
    }

    public PaginatingRenderer(LayoutProcess layoutProcess) {
        this(layoutProcess, true);
    }

    @Override
    protected void validateOutput() throws NormalizationException {
        LogicalPageBox logicalPageBox = this.getLogicalPageBox();
        if (!this.validateModelStep.isLayoutable(logicalPageBox)) {
            this.setLayoutFailureReason(this.validateModelStep.getLayoutFailureResolution(), this.validateModelStep.getLayoutFailureNodeId());
            return;
        }
        this.tableValidationStep.validate(logicalPageBox);
        this.updateTokensStep.compute(logicalPageBox, this.getLayoutProcess(), this.getPageContext());
        this.staticPropertiesStep.compute(logicalPageBox);
        this.marginsStep.compute(logicalPageBox);
        this.paragraphLinebreakStep.compute(logicalPageBox);
        this.icmMetricsStep.compute(logicalPageBox);
        boolean bl = true;
        while (bl) {
            this.tableICMMetricsStep.compute(logicalPageBox);
            this.minorAxisLayoutStep.compute(logicalPageBox);
            this.majorAxisLayoutStep.compute(logicalPageBox);
            this.tableRowHeightStep.compute(logicalPageBox);
            this.breakabilityStep.compute(logicalPageBox);
            if (this.paginationStep.performPagebreak(logicalPageBox) || !logicalPageBox.isOpen()) {
                OutputProcessor outputProcessor = this.getLayoutProcess().getOutputProcessor();
                long l = this.paginationStep.getNextOffset();
                long l2 = logicalPageBox.getPageOffset();
                LogicalPageBox logicalPageBox2 = this.fillPhysicalPagesStep.compute(logicalPageBox, l2, l);
                outputProcessor.processContent(logicalPageBox2);
                bl = logicalPageBox.isOpen();
                if (bl) {
                    this.firePagebreak();
                    logicalPageBox.setPageOffset(l);
                    this.cleanPaginatedBoxesStep.compute(logicalPageBox);
                    continue;
                }
                outputProcessor.processingFinished();
                continue;
            }
            bl = false;
        }
    }

    protected void firePagebreak() throws NormalizationException {
        PageContext pageContext = this.getRenderPageContext().getPageContext();
        LayoutStyle layoutStyle = pageContext.getStyle();
        this.getLayoutProcess().pageBreakEncountered(null, new PseudoPage[0]);
    }

    @Override
    public State saveState() throws StateException {
        return new DefaultFlowRendererState(this);
    }

    protected static class DefaultFlowRendererState
    extends AbstractRenderer.RendererState {
        private ValidateModelStep validateModelStep;
        private TableValidationStep tableValidationStep;
        private ComputeStaticPropertiesStep staticPropertiesStep;
        private ComputeMarginsStep marginsStep;
        private ComputeICMMetricsStep icmMetricsStep;
        private ComputeTableICMMetricsStep tableICMMetricsStep;
        private ParagraphLineBreakStep paragraphLinebreakStep;
        private InfiniteMinorAxisLayoutStep minorAxisLayoutStep;
        private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;
        private TableRowHeightStep tableRowHeightStep;
        private ComputeBreakabilityStep breakabilityStep;
        private PaginationStep paginationStep;
        private FillPhysicalPagesStep fillPhysicalPagesStep;
        private CleanPaginatedBoxesStep cleanPaginatedBoxesStep;
        private UpdateTokensStep updateTokensStep;

        protected DefaultFlowRendererState(PaginatingRenderer paginatingRenderer) throws StateException {
            super(paginatingRenderer);
            this.validateModelStep = paginatingRenderer.validateModelStep;
            this.tableValidationStep = paginatingRenderer.tableValidationStep;
            this.staticPropertiesStep = paginatingRenderer.staticPropertiesStep;
            this.marginsStep = paginatingRenderer.marginsStep;
            this.icmMetricsStep = paginatingRenderer.icmMetricsStep;
            this.tableICMMetricsStep = paginatingRenderer.tableICMMetricsStep;
            this.paragraphLinebreakStep = paginatingRenderer.paragraphLinebreakStep;
            this.minorAxisLayoutStep = paginatingRenderer.minorAxisLayoutStep;
            this.majorAxisLayoutStep = paginatingRenderer.majorAxisLayoutStep;
            this.tableRowHeightStep = paginatingRenderer.tableRowHeightStep;
            this.breakabilityStep = paginatingRenderer.breakabilityStep;
            this.paginationStep = paginatingRenderer.paginationStep;
            this.fillPhysicalPagesStep = paginatingRenderer.fillPhysicalPagesStep;
            this.cleanPaginatedBoxesStep = paginatingRenderer.cleanPaginatedBoxesStep;
            this.updateTokensStep = paginatingRenderer.updateTokensStep;
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            PaginatingRenderer paginatingRenderer = new PaginatingRenderer(layoutProcess, false);
            this.fill(paginatingRenderer, layoutProcess);
            paginatingRenderer.validateModelStep = this.validateModelStep;
            paginatingRenderer.tableValidationStep = this.tableValidationStep;
            paginatingRenderer.staticPropertiesStep = this.staticPropertiesStep;
            paginatingRenderer.marginsStep = this.marginsStep;
            paginatingRenderer.icmMetricsStep = this.icmMetricsStep;
            paginatingRenderer.tableICMMetricsStep = this.tableICMMetricsStep;
            paginatingRenderer.paragraphLinebreakStep = this.paragraphLinebreakStep;
            paginatingRenderer.minorAxisLayoutStep = this.minorAxisLayoutStep;
            paginatingRenderer.majorAxisLayoutStep = this.majorAxisLayoutStep;
            paginatingRenderer.tableRowHeightStep = this.tableRowHeightStep;
            paginatingRenderer.paginationStep = this.paginationStep;
            paginatingRenderer.fillPhysicalPagesStep = this.fillPhysicalPagesStep;
            paginatingRenderer.cleanPaginatedBoxesStep = this.cleanPaginatedBoxesStep;
            paginatingRenderer.breakabilityStep = this.breakabilityStep;
            paginatingRenderer.updateTokensStep = this.updateTokensStep;
            return paginatingRenderer;
        }
    }
}

