/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import org.pentaho.reporting.libraries.repository.zip.ZipContentItem;

public class ZipEntryOutputStream
extends OutputStream {
    private ByteArrayOutputStream outputStream;
    private DeflaterOutputStream deflaterOutputStream;
    private boolean closed;
    private ZipContentItem item;
    private CRC32 crc32;
    private long size;

    public ZipEntryOutputStream(ZipContentItem item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.item = item;
        this.outputStream = new ByteArrayOutputStream();
        this.deflaterOutputStream = new DeflaterOutputStream(this.outputStream);
        this.crc32 = new CRC32();
        this.size = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b);
        this.crc32.update(b);
        ++this.size;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b, off, len);
        this.crc32.update(b, off, len);
        this.size += (long)len;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.deflaterOutputStream.close();
        this.item.setRawData(this.outputStream.toByteArray(), this.size, this.crc32.getValue());
        this.closed = true;
        this.outputStream = null;
        this.deflaterOutputStream = null;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(b);
        this.crc32.update(b);
        this.size += (long)b.length;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.flush();
    }

    public long getSize() {
        return this.size;
    }

    public long getCrc() {
        return this.crc32.getValue();
    }
}

