/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul * u64vec2(10ul, 12ul)) => u64vec2(0ul, 0ul)
 * (0ul * u64vec2(42ul, 48ul)) => u64vec2(0ul, 0ul)
 * (3ul * u64vec2(10ul, 12ul)) => u64vec2(30ul, 36ul)
 * (3ul * u64vec2(42ul, 48ul)) => u64vec2(126ul, 144ul)
 * (1192ul * u64vec2(10ul, 12ul)) => u64vec2(11920ul, 14304ul)
 * (1192ul * u64vec2(42ul, 48ul)) => u64vec2(50064ul, 57216ul)
 * (1048576ul * u64vec2(10ul, 12ul)) => u64vec2(10485760ul, 12582912ul)
 * (1048576ul * u64vec2(42ul, 48ul)) => u64vec2(44040192ul, 50331648ul)
 * (4251475ul * u64vec2(10ul, 12ul)) => u64vec2(42514750ul, 51017700ul)
 * (4251475ul * u64vec2(42ul, 48ul)) => u64vec2(178561950ul, 204070800ul)
 * (29852643761ul * u64vec2(10ul, 12ul)) => u64vec2(298526437610ul, 358231725132ul)
 * (29852643761ul * u64vec2(42ul, 48ul)) => u64vec2(1253811037962ul, 1432926900528ul)
 * (4398046511104ul * u64vec2(10ul, 12ul)) => u64vec2(43980465111040ul, 52776558133248ul)
 * (4398046511104ul * u64vec2(42ul, 48ul)) => u64vec2(184717953466368ul, 211106232532992ul)
 * (3948976685146ul * u64vec2(10ul, 12ul)) => u64vec2(39489766851460ul, 47387720221752ul)
 * (3948976685146ul * u64vec2(42ul, 48ul)) => u64vec2(165857020776132ul, 189550880887008ul)
 * (135763469567146206ul * u64vec2(10ul, 12ul)) => u64vec2(1357634695671462060ul, 1629161634805754472ul)
 * (135763469567146206ul * u64vec2(42ul, 48ul)) => u64vec2(5702065721820140652ul, 6516646539223017888ul)
 * (11654173250180970009ul * u64vec2(10ul, 12ul)) => u64vec2(5861268059552390394ul, 10722870486204778796ul)
 * (11654173250180970009ul * u64vec2(42ul, 48ul)) => u64vec2(9859930591152398362ul, 5997993797400011952ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul * u64vec2(10ul, 12ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((0ul * u64vec2(42ul, 48ul)), u64vec2(0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((3ul * u64vec2(10ul, 12ul)), u64vec2(30ul, 36ul))) ? 1 : -1] array2;
  float[all(equal((3ul * u64vec2(42ul, 48ul)), u64vec2(126ul, 144ul))) ? 1 : -1] array3;
  float[all(equal((1192ul * u64vec2(10ul, 12ul)), u64vec2(11920ul, 14304ul))) ? 1 : -1] array4;
  float[all(equal((1192ul * u64vec2(42ul, 48ul)), u64vec2(50064ul, 57216ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul * u64vec2(10ul, 12ul)), u64vec2(10485760ul, 12582912ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul * u64vec2(42ul, 48ul)), u64vec2(44040192ul, 50331648ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul * u64vec2(10ul, 12ul)), u64vec2(42514750ul, 51017700ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul * u64vec2(42ul, 48ul)), u64vec2(178561950ul, 204070800ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul * u64vec2(10ul, 12ul)), u64vec2(298526437610ul, 358231725132ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul * u64vec2(42ul, 48ul)), u64vec2(1253811037962ul, 1432926900528ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul * u64vec2(10ul, 12ul)), u64vec2(43980465111040ul, 52776558133248ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul * u64vec2(42ul, 48ul)), u64vec2(184717953466368ul, 211106232532992ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul * u64vec2(10ul, 12ul)), u64vec2(39489766851460ul, 47387720221752ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul * u64vec2(42ul, 48ul)), u64vec2(165857020776132ul, 189550880887008ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul * u64vec2(10ul, 12ul)), u64vec2(1357634695671462060ul, 1629161634805754472ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul * u64vec2(42ul, 48ul)), u64vec2(5702065721820140652ul, 6516646539223017888ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul * u64vec2(10ul, 12ul)), u64vec2(5861268059552390394ul, 10722870486204778796ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul * u64vec2(42ul, 48ul)), u64vec2(9859930591152398362ul, 5997993797400011952ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
