/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.AuTool;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;

public class AuAudioOutputStream
extends TAudioOutputStream {
    private static String description = "Created by Tritonus";

    protected static void writeText(TDataOutputStream dos, String s) throws IOException {
        if (s.length() > 0) {
            dos.writeBytes(s);
            dos.writeByte(0);
            if (s.length() % 2 == 0) {
                dos.writeByte(0);
            }
        }
    }

    protected static int getTextLength(String s) {
        if (s.length() == 0) {
            return 0;
        }
        return s.length() + 2 & 0xFFFFFFFE;
    }

    public AuAudioOutputStream(AudioFormat audioFormat, long lLength, TDataOutputStream dataOutputStream) {
        super(audioFormat, lLength > Integer.MAX_VALUE ? -1L : lLength, dataOutputStream, lLength == -1L && dataOutputStream.supportsSeek());
    }

    protected void writeHeader() throws IOException {
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out((String)"AuAudioOutputStream.writeHeader(): called.");
        }
        AudioFormat format = this.getFormat();
        long lLength = this.getLength();
        TDataOutputStream dos = this.getDataOutputStream();
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out((String)("AuAudioOutputStream.writeHeader(): AudioFormat: " + format));
            TDebug.out((String)("AuAudioOutputStream.writeHeader(): length: " + lLength));
        }
        dos.writeInt(779316836);
        dos.writeInt(24 + AuAudioOutputStream.getTextLength(description));
        dos.writeInt(lLength != -1L ? (int)lLength : -1);
        dos.writeInt(AuTool.getFormatCode(format));
        dos.writeInt((int)format.getSampleRate());
        dos.writeInt(format.getChannels());
        AuAudioOutputStream.writeText(dos, description);
    }

    protected void patchHeader() throws IOException {
        TDataOutputStream tdos = this.getDataOutputStream();
        tdos.seek(0L);
        this.setLengthFromCalculatedLength();
        this.writeHeader();
    }
}

