/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import processing.app.Base;
import processing.app.Editor;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.app.tools.Tool;

public class Uncrustify
implements Tool {
    private Editor editor;

    public String getMenuTitle() {
        return "Uncrustify (experimental)";
    }

    public void init(Editor editor) {
        this.editor = editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            File lib = Base.getContentFile("lib");
            File uncrustify = new File(lib, "uncrustify");
            File config = new File(lib, "uncrustify-pde.cfg");
            File tmp = File.createTempFile("uncrustify", ".pde");
            try {
                FileWriter out = new FileWriter(tmp);
                try {
                    out.write(this.editor.getText());
                }
                finally {
                    out.close();
                }
                ProcessResult result = new ProcessHelper(uncrustify.getAbsolutePath(), "-c", config.getAbsolutePath(), "-l", "JAVA", "-f", tmp.getAbsolutePath()).execute();
                if (!result.succeeded()) {
                    Base.showMessage("Could not Uncrustify", result.getStderr());
                    return;
                }
                this.editor.setText(result.getStdout());
            }
            catch (InterruptedException e) {
                Base.showWarning("Could not Uncrustify", "Unexpected exception", e);
            }
            finally {
                if (!tmp.delete()) {
                    tmp.deleteOnExit();
                }
            }
        }
        catch (IOException e) {
            Base.showWarning("Could not Uncrustify", "Unexpected exception", e);
        }
    }
}

