/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.primavera.PrimaveraDatabaseReader;
import net.sf.mpxj.writer.ProjectWriter;
import net.sf.mpxj.writer.ProjectWriterUtility;

public final class PrimaveraConvert {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 4) {
                System.out.println("Usage: PrimaveraConvert <JDBC Driver Class> <JDBC connection string> <project ID> <output file name>");
            } else {
                PrimaveraConvert primaveraConvert = new PrimaveraConvert();
                primaveraConvert.process(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void process(String string, String string2, String string3, String string4) throws Exception {
        System.out.println("Reading Primavera database started.");
        Class.forName(string);
        Properties properties = new Properties();
        if (string.equals("org.sqlite.JDBC")) {
            properties.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
        }
        Connection connection = DriverManager.getConnection(string2, properties);
        PrimaveraDatabaseReader primaveraDatabaseReader = new PrimaveraDatabaseReader();
        primaveraDatabaseReader.setConnection(connection);
        this.processProject(primaveraDatabaseReader, Integer.parseInt(string3), string4);
    }

    private void processProject(PrimaveraDatabaseReader primaveraDatabaseReader, int n, String string) throws Exception {
        long l = System.currentTimeMillis();
        primaveraDatabaseReader.setProjectID(n);
        ProjectFile projectFile = primaveraDatabaseReader.read();
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Reading database completed in " + l2 + "ms.");
        System.out.println("Writing output file started.");
        l = System.currentTimeMillis();
        ProjectWriter projectWriter = ProjectWriterUtility.getProjectWriter(string);
        projectWriter.write(projectFile, string);
        l2 = System.currentTimeMillis() - l;
        System.out.println("Writing output completed in " + l2 + "ms.");
    }
}

