/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.SourceLineCounter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.KotlinInlineVisitingFilter;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.LinesUtil;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.util.StringsPool;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TIntObjectProcedure;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveHook
implements Runnable {
    private final File myDataFile;
    private File mySourceMapFile;
    private final boolean myAppendUnloaded;
    private final ClassFinder myClassFinder;
    private final boolean myMergeFile;

    public SaveHook(File dataFile, boolean appendUnloaded, ClassFinder classFinder, boolean mergeFile) {
        this.myDataFile = dataFile;
        this.myAppendUnloaded = appendUnloaded;
        this.myClassFinder = classFinder;
        this.myMergeFile = mergeFile;
    }

    @Override
    public void run() {
        this.save(ProjectData.getProjectData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save(ProjectData projectData) {
        projectData.stop();
        CoverageIOUtil.FileLock lock = null;
        try {
            projectData.applyLinesMask();
            projectData.applyBranchData();
            if (this.myAppendUnloaded) {
                SaveHook.appendUnloaded(projectData, this.myClassFinder, this.mySourceMapFile != null);
            }
            projectData.checkLineMappings();
            this.checkLineSignatures(projectData);
            lock = CoverageIOUtil.FileLock.lock(this.myDataFile);
            if (this.myMergeFile) {
                ProjectData load = ProjectDataLoader.load(this.myDataFile);
                projectData.merge(load);
            }
            DataOutputStream os = null;
            try {
                os = CoverageIOUtil.openFile(this.myDataFile);
                TObjectIntHashMap<String> dict = new TObjectIntHashMap<String>();
                HashMap<String, ClassData> classes = new HashMap<String, ClassData>(projectData.getClasses());
                CoverageIOUtil.writeINT(os, classes.size());
                SaveHook.saveDictionary(os, dict, classes);
                SaveHook.saveData(os, dict, classes);
                SaveHook.saveSourceMap(classes, this.mySourceMapFile);
            }
            catch (IOException e) {
                ErrorReporter.reportError("Error writing file " + this.myDataFile.getPath(), e);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    ErrorReporter.reportError("Error writing file " + this.myDataFile.getPath(), e);
                }
            }
            CoverageIOUtil.FileLock.unlock(lock);
        }
        catch (OutOfMemoryError e) {
            ErrorReporter.reportError("Out of memory error occurred, try to increase memory available for the JVM, or make include / exclude patterns more specific", e);
        }
        catch (Throwable e2) {
            ErrorReporter.reportError("Unexpected error", e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            CoverageIOUtil.FileLock.unlock(lock);
        }
        finally {
            CoverageIOUtil.FileLock.unlock(lock);
        }
    }

    public static void saveSourceMap(Map str_clData_classes, File sourceMapFile) {
        if (sourceMapFile != null) {
            Map<Object, Object> readNames = Collections.emptyMap();
            try {
                if (sourceMapFile.exists()) {
                    readNames = SaveHook.loadSourceMapFromFile(str_clData_classes, sourceMapFile);
                }
            }
            catch (IOException e) {
                ErrorReporter.reportError("Error loading source map from " + sourceMapFile.getPath(), e);
            }
            try {
                SaveHook.doSaveSourceMap(readNames, sourceMapFile, str_clData_classes);
            }
            catch (IOException e) {
                ErrorReporter.reportError("Error writing source map " + sourceMapFile.getPath(), e);
            }
        }
    }

    public static void loadAndApplySourceMap(ProjectData projectData, File sourceMapFile) throws IOException {
        Map<Object, Object> map = SaveHook.loadSourceMapFromFile(new HashMap(), sourceMapFile);
        Iterator<Map.Entry<Object, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> o;
            Map.Entry<Object, Object> entry = o = iterator.next();
            String className = (String)entry.getKey();
            String source = (String)entry.getValue();
            ClassData data = projectData.getClassData(className);
            if (data == null) continue;
            data.setSource(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Object, Object> loadSourceMapFromFile(Map classes, File mySourceMapFile) throws IOException {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(mySourceMapFile));
            int classNumber = CoverageIOUtil.readINT((DataInput)((Object)in));
            HashMap<Object, Object> readNames = new HashMap<Object, Object>(classNumber);
            for (int i = 0; i < classNumber; ++i) {
                String className = CoverageIOUtil.readUTFFast((DataInput)((Object)in));
                String classSource = CoverageIOUtil.readUTFFast((DataInput)((Object)in));
                if ("".equals(classSource)) continue;
                ClassData data = (ClassData)classes.get(className);
                if (data == null) {
                    readNames.put(className, classSource);
                    continue;
                }
                if (data.getSource() != null && data.getSource().equals(classSource)) continue;
                readNames.put(className, classSource);
            }
            HashMap<Object, Object> hashMap = readNames;
            return hashMap;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static void saveData(DataOutputStream os, final TObjectIntHashMap<String> dict, Map classes) throws IOException {
        for (Object o : classes.values()) {
            ((ClassData)o).save(os, new DictionaryLookup(){

                public int getDictionaryIndex(String className) {
                    return dict.containsKey(className) ? dict.get(className) : -1;
                }
            });
        }
    }

    private static void saveDictionary(DataOutputStream os, TObjectIntHashMap<String> dict, Map classes) throws IOException {
        int i = 0;
        for (Object o : classes.keySet()) {
            String className = (String)o;
            dict.put(className, i++);
            CoverageIOUtil.writeUTF(os, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSaveSourceMap(Map<Object, Object> str_str_readNames, File sourceMapFile, Map str_clData_classes) throws IOException {
        HashMap<Object, Object> str_str_merged_map = new HashMap<Object, Object>(str_str_readNames);
        for (Object o1 : str_clData_classes.values()) {
            ClassData classData = (ClassData)o1;
            if (str_str_merged_map.containsKey(classData.getName())) continue;
            str_str_merged_map.put(classData.getName(), classData.getSource());
        }
        DataOutputStream out = null;
        try {
            out = CoverageIOUtil.openFile(sourceMapFile);
            CoverageIOUtil.writeINT(out, str_str_merged_map.size());
            Iterator<Map.Entry<Object, Object>> iterator = str_str_merged_map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> o;
                Map.Entry<Object, Object> str_str_entry = o = iterator.next();
                CoverageIOUtil.writeUTF(out, (String)str_str_entry.getKey());
                String value = (String)str_str_entry.getValue();
                CoverageIOUtil.writeUTF(out, value != null ? value : "");
            }
        }
        finally {
            if (out != null) {
                CoverageIOUtil.close(out);
            }
        }
    }

    public static void appendUnloaded(ProjectData projectData, ClassFinder classFinder, boolean calculateSource) {
        Collection<ClassEntry> matchedClasses = classFinder.findMatchedClasses();
        for (ClassEntry classEntry : matchedClasses) {
            ClassData cd = projectData.getClassData(classEntry.getClassName());
            if (cd != null) continue;
            try {
                ClassReader reader = new ClassReader(classEntry.getClassInputStream());
                if (calculateSource) {
                    cd = projectData.getOrCreateClassData(classEntry.getClassName());
                }
                SourceLineCounter slc = new SourceLineCounter(cd, false, calculateSource ? projectData : null);
                reader.accept(slc, 0);
                if (!slc.isEnum() && slc.getNSourceLines() <= 0) continue;
                final TIntObjectHashMap lines = new TIntObjectHashMap(4, 0.99f);
                final int[] maxLine = new int[]{1};
                final ClassData classData = projectData.getOrCreateClassData(StringsPool.getFromPool(classEntry.getClassName()));
                slc.getSourceLines().forEachEntry(new TIntObjectProcedure<String>(){

                    @Override
                    public boolean execute(int line, String methodSig) {
                        LineData ld = new LineData(line, StringsPool.getFromPool(methodSig));
                        lines.put(line, ld);
                        if (line > maxLine[0]) {
                            maxLine[0] = line;
                        }
                        classData.registerMethodSignature(ld);
                        ld.setStatus((byte)0);
                        return true;
                    }
                });
                classData.setLines(LinesUtil.calcLineArray(maxLine[0], lines));
            }
            catch (Throwable e) {
                e.printStackTrace();
                ErrorReporter.reportError("Failed to process class: " + classEntry.getClassName() + ", error: " + e.getMessage(), e);
            }
        }
    }

    public void setSourceMapFile(File sourceMapFile) {
        this.mySourceMapFile = sourceMapFile;
    }

    private void checkLineSignatures(ProjectData projectData) {
        if (!KotlinInlineVisitingFilter.shouldCheckLineSignatures()) {
            return;
        }
        Map<String, FileMapData[]> linesMap = projectData.getLinesMap();
        if (linesMap == null) {
            return;
        }
        HashSet<String> classes = new HashSet<String>();
        for (Map.Entry<String, FileMapData[]> mapData : linesMap.entrySet()) {
            if (mapData.getValue() == null) continue;
            for (FileMapData data : mapData.getValue()) {
                if (data == null || mapData.getKey().equals(data.getClassName())) continue;
                classes.add(data.getClassName());
            }
        }
        for (String className : classes) {
            ClassData classData = projectData.getClassData(className);
            if (classData == null) continue;
            KotlinInlineVisitingFilter.checkLineSignatures(classData, this.myClassFinder);
        }
    }
}

