/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTrackingIOUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTestResults(File tracesDirectory, String name, Map<Object, boolean[]> trace) throws IOException {
        File traceFile = new File(tracesDirectory, name + ".tr");
        if (!traceFile.exists()) {
            traceFile.createNewFile();
        }
        FilterOutputStream os = null;
        try {
            os = new DataOutputStream(new FileOutputStream(traceFile));
            int size = trace.size();
            ((DataOutputStream)os).writeInt(size);
            int entries = 0;
            for (Map.Entry<Object, boolean[]> entry : trace.entrySet()) {
                int idx;
                if (entries >= size) {
                    break;
                }
                ++entries;
                ((DataOutputStream)os).writeUTF(entry.getKey().toString());
                boolean[] oldLines = entry.getValue();
                boolean[] lines = new boolean[oldLines.length];
                System.arraycopy(oldLines, 0, lines, 0, lines.length);
                int numberOfTraces = 0;
                for (idx = 1; idx < lines.length; ++idx) {
                    if (!lines[idx]) continue;
                    ++numberOfTraces;
                }
                ((DataOutputStream)os).writeInt(numberOfTraces);
                for (idx = 1; idx < lines.length; ++idx) {
                    boolean incl = lines[idx];
                    if (!incl) continue;
                    ((DataOutputStream)os).writeInt(idx);
                }
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, int[]>> loadTestTrackingData(File tracesDirectory) throws IOException {
        File[] traces = tracesDirectory.listFiles();
        HashMap<String, Map<String, int[]>> result = new HashMap<String, Map<String, int[]>>();
        if (traces == null) {
            return result;
        }
        for (File traceFile : traces) {
            String fileName = traceFile.getName();
            String name = fileName.substring(0, fileName.length() - ".tr".length());
            HashMap<String, int[]> classes = new HashMap<String, int[]>();
            FilterInputStream is = null;
            try {
                is = new DataInputStream(new FileInputStream(traceFile));
                int size = ((DataInputStream)is).readInt();
                for (int i = 0; i < size; ++i) {
                    String className = ((DataInputStream)is).readUTF();
                    int lines = ((DataInputStream)is).readInt();
                    int[] coveredLines = new int[lines];
                    for (int j = 0; j < lines; ++j) {
                        coveredLines[j] = ((DataInputStream)is).readInt();
                    }
                    classes.put(className, coveredLines);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            result.put(name, classes);
        }
        return result;
    }
}

