/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.SuperUserStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;

public final class IoTestUtil {
    @Nullable
    private static final Boolean symLinkMode = SystemInfo.isUnix ? Boolean.TRUE : IoTestUtil.canCreateSymlinks();
    public static final boolean isSymLinkCreationSupported = symLinkMode != null;
    private static final String[] UNICODE_PARTS = new String[]{"\u042e\u043d\u0438\u043a\u043e\u0434\u0435", "\u00da\u00f1\u00ed\u00e7\u00f8d\u00ea"};

    private IoTestUtil() {
    }

    @Nullable
    public static String getUnicodeName() {
        return IoTestUtil.filterParts(PathUtil::isValidFileName);
    }

    @Nullable
    public static String getUnicodeName(String forEncoding) {
        return IoTestUtil.filterParts(Charset.forName(forEncoding).newEncoder()::canEncode);
    }

    private static String filterParts(Predicate<String> predicate) {
        return StringUtil.nullize((String)Stream.of(UNICODE_PARTS).filter(predicate).collect(Collectors.joining("_")));
    }

    @NotNull
    public static File getTempDirectory() {
        File dir = new File(FileUtil.getTempDirectory());
        File file2 = dir = IoTestUtil.expandWindowsPath(dir);
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(0);
        }
        return file2;
    }

    private static File expandWindowsPath(File file2) {
        if (SystemInfo.isWindows && file2.getPath().indexOf(126) > 0) {
            try {
                return file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file2;
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(1);
        }
        if (link == null) {
            IoTestUtil.$$$reportNull$$$0(2);
        }
        File file2 = IoTestUtil.createSymLink(target, link, Boolean.TRUE);
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link, boolean shouldExist) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(4);
        }
        if (link == null) {
            IoTestUtil.$$$reportNull$$$0(5);
        }
        File file2 = IoTestUtil.createSymLink(target, link, (Boolean)shouldExist);
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @NotNull
    public static Path createSymbolicLink(@NotNull Path link, @NotNull Path target) throws IOException {
        Path path;
        if (link == null) {
            IoTestUtil.$$$reportNull$$$0(7);
        }
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(8);
        }
        try {
            path = IoTestUtil.createSymLink(target.toString(), link.toString(), null).toPath();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        if (path == null) {
            IoTestUtil.$$$reportNull$$$0(9);
        }
        return path;
    }

    private static File createSymLink(String target, String link, @Nullable Boolean shouldExist) {
        File linkFile = IoTestUtil.getFullLinkPath(link);
        File targetFile = new File(target);
        try {
            if (symLinkMode == Boolean.TRUE) {
                Files.createSymbolicLink(linkFile.toPath(), targetFile.toPath(), new FileAttribute[0]);
            } else if (Files.isDirectory(targetFile.isAbsolute() ? targetFile.toPath() : linkFile.toPath().getParent().resolve(target), new LinkOption[0])) {
                IoTestUtil.runCommand("cmd", "/C", "mklink", "/D", linkFile.getPath(), targetFile.getPath());
            } else {
                IoTestUtil.runCommand("cmd", "/C", "mklink", linkFile.getPath(), targetFile.getPath());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (shouldExist != null) {
            Assert.assertEquals((String)("target=" + target + ", link=" + linkFile), (Object)shouldExist, (Object)linkFile.exists());
        }
        return linkFile;
    }

    public static void assumeSymLinkCreationIsSupported() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Can't create symlinks on " + SystemInfo.getOsNameAndVersion()), (boolean)isSymLinkCreationSupported);
    }

    public static void assumeNioSymLinkCreationIsSupported() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Can't create symlinks via NIO2 on " + SystemInfo.getOsNameAndVersion()), (symLinkMode == Boolean.TRUE ? 1 : 0) != 0);
    }

    public static void assumeWindows() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Windows, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isWindows);
    }

    public static void assumeMacOS() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need macOS, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isMac);
    }

    public static void assumeLinux() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Linux, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isLinux);
    }

    public static void assumeUnix() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Need Unix, can't run on " + SystemInfo.OS_NAME), (boolean)SystemInfo.isUnix);
    }

    public static void assumeCaseSensitiveFS() throws AssumptionViolatedException {
        Assume.assumeTrue((String)("Assumed case sensitive FS but got " + SystemInfo.getOsNameAndVersion()), (boolean)SystemInfo.isFileSystemCaseSensitive);
    }

    public static void assumeCaseInsensitiveFS() throws AssumptionViolatedException {
        Assume.assumeFalse((String)("Assumed case insensitive FS but got " + SystemInfo.getOsNameAndVersion()), (boolean)SystemInfo.isFileSystemCaseSensitive);
    }

    public static void assumeWslPresence() throws AssumptionViolatedException {
        Assume.assumeTrue((String)"'wsl.exe' not found in %Path%", (WSLDistribution.findWslExe() != null ? 1 : 0) != 0);
    }

    @NotNull
    public static Path createWslTempDir(@NotNull String wsl, @NotNull String testName) throws IOException {
        if (wsl == null) {
            IoTestUtil.$$$reportNull$$$0(10);
        }
        if (testName == null) {
            IoTestUtil.$$$reportNull$$$0(11);
        }
        Path path = Files.createTempDirectory(Paths.get("\\\\wsl$\\" + wsl + "\\tmp", new String[0]), "unitTest_" + testName + "_", new FileAttribute[0]);
        if (path == null) {
            IoTestUtil.$$$reportNull$$$0(12);
        }
        return path;
    }

    @NotNull
    public static File createJunction(@NotNull String target, @NotNull String junction) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(13);
        }
        if (junction == null) {
            IoTestUtil.$$$reportNull$$$0(14);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        File junctionFile = IoTestUtil.getFullLinkPath(junction);
        IoTestUtil.runCommand("cmd", "/C", "mklink", "/J", junctionFile.getPath(), targetFile.getPath());
        Assert.assertTrue((String)("target=" + targetFile + ", link=" + junctionFile), (boolean)junctionFile.isDirectory());
        File file2 = junctionFile;
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(15);
        }
        return file2;
    }

    public static void deleteJunction(@NotNull String junction) {
        if (junction == null) {
            IoTestUtil.$$$reportNull$$$0(16);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        Assert.assertTrue((boolean)new File(junction).delete());
    }

    @NotNull
    public static File createSubst(@NotNull String target) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(17);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        String substRoot = IoTestUtil.getFirstFreeDriveLetter() + ":";
        IoTestUtil.runCommand("subst", substRoot, targetFile.getPath());
        File rootFile = new File(substRoot + "\\");
        Assert.assertTrue((String)("target=" + targetFile + ", subst=" + rootFile), (boolean)rootFile.isDirectory());
        File file2 = rootFile;
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(18);
        }
        return file2;
    }

    public static void deleteSubst(@NotNull String substRoot) {
        if (substRoot == null) {
            IoTestUtil.$$$reportNull$$$0(19);
        }
        IoTestUtil.runCommand("subst", StringUtil.trimEnd((String)substRoot, (char)'\\'), "/d");
    }

    public static void createFifo(@NotNull String path) {
        if (path == null) {
            IoTestUtil.$$$reportNull$$$0(20);
        }
        IoTestUtil.runCommand("mkfifo", path);
    }

    private static char getFirstFreeDriveLetter() {
        Set roots = StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).map(root -> Character.valueOf(StringUtil.toUpperCase((String)root.toString()).charAt(0))).collect(Collectors.toSet());
        Logger.getInstance(IoTestUtil.class).debug("logical drives: " + roots);
        for (char c = 'E'; c <= 'Z'; c = (char)(c + '\u0001')) {
            if (roots.contains(Character.valueOf(c))) continue;
            return c;
        }
        throw new RuntimeException("No free roots");
    }

    private static File getFullLinkPath(String link) {
        File linkFile = new File(link);
        if (!linkFile.isAbsolute()) {
            linkFile = new File(IoTestUtil.getTempDirectory(), link);
        }
        Assert.assertTrue((String)link, (!linkFile.exists() || linkFile.delete() ? 1 : 0) != 0);
        File parentDir = linkFile.getParentFile();
        Assert.assertTrue((String)("link=" + link + ", parent=" + parentDir), (parentDir != null && (parentDir.isDirectory() || parentDir.mkdirs()) ? 1 : 0) != 0);
        return linkFile;
    }

    private static String runCommand(String ... command) {
        try {
            GeneralCommandLine cmd = new GeneralCommandLine(command).withRedirectErrorStream(true);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)30000);
            String out = output.getStdout().trim();
            if (output.getExitCode() != 0) {
                Assert.fail((String)("failed: " + cmd + "\nexit code: " + output.getExitCode() + "; output:\n" + out));
            }
            return out;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertTimestampsEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertEquals((String)("expected: " + expected + ", actual: " + actual), (long)roundedExpected, (long)roundedActual);
    }

    public static void assertTimestampsNotEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertTrue((String)("(un)expected: " + expected + ", actual: " + actual), (roundedExpected != roundedActual ? 1 : 0) != 0);
    }

    @NotNull
    public static File createTestJar(@NotNull File jarFile) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(21);
        }
        return IoTestUtil.createTestJar(jarFile, "META-INF/MANIFEST.MF", "");
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, String ... namesAndTexts) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(22);
        }
        if (namesAndTexts == null) {
            IoTestUtil.$$$reportNull$$$0(23);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        for (int i = 0; i < namesAndTexts.length; i += 2) {
            stream.putNextEntry(new ZipEntry(namesAndTexts[i]));
            if (namesAndTexts[i + 1] != null) {
                stream.write(namesAndTexts[i + 1].getBytes(StandardCharsets.UTF_8));
            }
            stream.closeEntry();
        }
        File file2 = jarFile;
        stream.close();
        File file3 = file2;
        if (file3 == null) {
            IoTestUtil.$$$reportNull$$$0(24);
        }
        return file3;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull Collection<Pair<String, byte[]>> namesAndContents) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(25);
        }
        if (namesAndContents == null) {
            IoTestUtil.$$$reportNull$$$0(26);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        for (Pair<String, byte[]> p : namesAndContents) {
            String name = (String)p.first;
            byte[] content = (byte[])p.second;
            stream.putNextEntry(new ZipEntry(name));
            stream.write(content);
            stream.closeEntry();
        }
        File file2 = jarFile;
        stream.close();
        Object object = file2;
        if (object == null) {
            IoTestUtil.$$$reportNull$$$0(27);
        }
        return object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull File root) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(28);
        }
        if (root == null) {
            IoTestUtil.$$$reportNull$$$0(29);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        FileUtil.visitFiles((File)root, file2 -> {
            if (file2.isFile()) {
                String path = FileUtil.toSystemIndependentName((String)Objects.requireNonNull(FileUtil.getRelativePath((File)root, (File)file2)));
                try {
                    stream.putNextEntry(new ZipEntry(path));
                    try (FileInputStream is = new FileInputStream((File)file2);){
                        FileUtil.copy((InputStream)is, (OutputStream)stream);
                    }
                    stream.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        });
        File file3 = jarFile;
        stream.close();
        File file4 = file3;
        if (file4 == null) {
            IoTestUtil.$$$reportNull$$$0(30);
        }
        return file4;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @NotNull
    public static File createTestDir(@NotNull String name) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(31);
        }
        return IoTestUtil.createTestDir(IoTestUtil.getTempDirectory(), name);
    }

    @NotNull
    public static File createTestDir(@NotNull File parent, @NotNull String name) {
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(32);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(33);
        }
        File dir = new File(parent, name);
        Assert.assertTrue((String)dir.getPath(), (boolean)dir.mkdirs());
        File file2 = dir;
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(34);
        }
        return file2;
    }

    @NotNull
    public static File createTestFile(@NotNull String name) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(35);
        }
        return IoTestUtil.createTestFile(name, null);
    }

    @NotNull
    public static File createTestFile(@NotNull String name, @Nullable String content) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(36);
        }
        return IoTestUtil.createTestFile(IoTestUtil.getTempDirectory(), name, content);
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name) {
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(38);
        }
        return IoTestUtil.createTestFile(parent, name, null);
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name, @Nullable String content) {
        File file2;
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(39);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(40);
        }
        try {
            Assert.assertTrue((String)parent.getPath(), (parent.isDirectory() || parent.mkdirs() ? 1 : 0) != 0);
            File file3 = new File(parent, name);
            Assert.assertTrue((String)file3.getPath(), (boolean)file3.createNewFile());
            if (content != null) {
                FileUtil.writeToFile((File)file3, (String)content);
            }
            file2 = file3;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(41);
        }
        return file2;
    }

    public static void delete(File ... files) {
        if (files == null) {
            IoTestUtil.$$$reportNull$$$0(42);
        }
        for (File file2 : files) {
            if (file2 == null) continue;
            FileUtil.delete((File)file2);
        }
    }

    public static void writeToFile(@NotNull File file2, @NotNull String content) {
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(43);
        }
        if (content == null) {
            IoTestUtil.$$$reportNull$$$0(44);
        }
        try {
            FileUtil.writeToFile((File)file2, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static Boolean canCreateSymlinks() {
        try {
            Path target = Files.createTempFile("IOTestUtil_link_target.", ".txt", new FileAttribute[0]);
            try {
                Boolean bl;
                Path link = target.getParent().resolve("IOTestUtil_link");
                try {
                    Files.createSymbolicLink(link, target.getFileName(), new FileAttribute[0]);
                    bl = Boolean.TRUE;
                }
                catch (IOException e) {
                    Logger.getInstance(IoTestUtil.class).debug((Throwable)e);
                    IoTestUtil.runCommand("cmd", "/C", "mklink", link.toString(), target.getFileName().toString());
                    Boolean bl2 = Boolean.FALSE;
                    Files.deleteIfExists(link);
                    Files.delete(target);
                    return bl2;
                    {
                        catch (Throwable throwable) {
                            Files.deleteIfExists(link);
                            throw throwable;
                        }
                    }
                }
                Files.deleteIfExists(link);
                return bl;
            }
            finally {
                Files.delete(target);
            }
        }
        catch (Throwable t) {
            Logger.getInstance(IoTestUtil.class).debug(t);
            return null;
        }
    }

    @NotNull
    public static String toLocalUncPath(@NotNull String localPath) {
        if (localPath == null) {
            IoTestUtil.$$$reportNull$$$0(45);
        }
        String string = "\\\\127.0.0.1\\" + localPath.charAt(0) + "$" + localPath.substring(2);
        if (string == null) {
            IoTestUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public static @NotNull List<@NotNull String> enumerateWslDistributions() {
        ProcessOutput output;
        block5: {
            Assert.assertTrue((boolean)SystemInfo.isWin10OrNewer);
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"wsl", "-l", "-q"}).withRedirectErrorStream(true).withCharset(StandardCharsets.UTF_16LE);
            output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)30000);
            if (output.getExitCode() != 0) break block5;
            List list = output.getStdoutLines();
            if (list == null) {
                IoTestUtil.$$$reportNull$$$0(47);
            }
            return list;
        }
        try {
            Logger.getInstance(IoTestUtil.class).debug(output.getExitCode() + " " + output.getStdout().trim());
        }
        catch (Exception e) {
            Logger.getInstance(IoTestUtil.class).debug((Throwable)e);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            IoTestUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    public static boolean reanimateWslDistribution(@NotNull String name) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(49);
        }
        try {
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"wsl", "-d", name, "-e", "pwd"}).withRedirectErrorStream(true);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)30000);
            if (output.getExitCode() == 0) {
                return true;
            }
            Logger.getInstance(IoTestUtil.class).debug(output.getExitCode() + " " + output.getStdout().trim());
        }
        catch (Exception e) {
            Logger.getInstance(IoTestUtil.class).debug((Throwable)e);
        }
        return false;
    }

    public static void setCaseSensitivity(@NotNull File dir, boolean caseSensitive) throws IOException {
        if (dir == null) {
            IoTestUtil.$$$reportNull$$$0(50);
        }
        Assert.assertTrue((String)"'fsutil.exe' needs elevated privileges to work", (boolean)SuperUserStatus.isSuperUser());
        String changeOut = IoTestUtil.runCommand("fsutil", "file", "setCaseSensitiveInfo", dir.getPath(), caseSensitive ? "enable" : "disable");
        String out = IoTestUtil.runCommand("fsutil", "file", "queryCaseSensitiveInfo", dir.getPath());
        if (!out.endsWith(caseSensitive ? "enabled." : "disabled.")) {
            throw new IOException("Can't setCaseSensitivity(" + dir + ", " + caseSensitive + "). 'fsutil.exe setCaseSensitiveInfo' output:" + changeOut + "; 'fsutil.exe getCaseSensitiveInfo' output:" + out);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/IoTestUtil";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "junction";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substRoot";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesAndTexts";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesAndContents";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/IoTestUtil";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymLink";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbolicLink";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createWslTempDir";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createJunction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubst";
                break;
            }
            case 24: 
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestJar";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestDir";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestFile";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalUncPath";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerateWslDistributions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSymLink";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicLink";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createWslTempDir";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createJunction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteJunction";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSubst";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteSubst";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFifo";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createTestJar";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTestDir";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createTestFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "toLocalUncPath";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "reanimateWslDistribution";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setCaseSensitivity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

